/*
 * Decompiled with CFR 0.152.
 */
package oms3.util;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oms3.Notification;
import oms3.annotations.Range;
import oms3.annotations.Unit;

public class Listeners {

    public static class Logging
    implements Notification.Listener {
        Logger log;
        Level level;

        public Logging(Logger log, Level level) {
            this.log = log;
            this.level = level;
        }

        @Override
        public void notice(Notification.Type T, EventObject E) {
            this.log.log(this.level, T + ": " + E);
        }
    }

    public static class Printer
    implements Notification.Listener {
        @Override
        public void notice(Notification.Type T, EventObject E) {
            EventObject ce;
            System.out.printf(" '%s' from %s\n", new Object[]{T, E.getSource()});
            if (T == Notification.Type.EXCEPTION) {
                ce = (Notification.ExceptionEvent)E;
                System.out.printf(">>>>>>'%s' in %s\n", ((Notification.ExceptionEvent)ce).getException());
            }
            if (T == Notification.Type.OUT) {
                ce = (Notification.DataflowEvent)E;
                System.out.printf("     '%s' -> \n", ((Notification.DataflowEvent)ce).getValue());
            }
            if (T == Notification.Type.IN) {
                ce = (Notification.DataflowEvent)E;
                System.out.printf("        -> '%s'\n", ((Notification.DataflowEvent)ce).getValue());
            }
        }
    }

    public static class UnitConverter
    implements Notification.Listener {
        Map<Object, String> m = new HashMap<Object, String>();

        @Override
        public void notice(Notification.Type T, EventObject E) {
            Unit inUnit;
            Notification.DataflowEvent ce;
            String out;
            if (T == Notification.Type.OUT) {
                Notification.DataflowEvent ce2 = (Notification.DataflowEvent)E;
                Unit outUnit = ce2.getAccess().getField().getAnnotation(Unit.class);
                if (outUnit != null) {
                    this.m.put(ce2.getValue(), outUnit.value());
                }
            } else if (T == Notification.Type.IN && (out = this.m.get((ce = (Notification.DataflowEvent)E).getValue())) != null && (inUnit = ce.getAccess().getField().getAnnotation(Unit.class)) != null) {
                this.convert(out, inUnit.value(), ce.getValue());
            }
        }

        private void convert(String out, String in, Object value) {
        }
    }

    public static class NullCheck
    implements Notification.Listener {
        @Override
        public void notice(Notification.Type T, EventObject E) {
            Notification.DataflowEvent ce;
            if ((T == Notification.Type.IN || T == Notification.Type.OUT) && (ce = (Notification.DataflowEvent)E).getValue() == null) {
                System.out.println("Null : " + ce.getAccess().getField().getName() + " in " + ce.getAccess().getComponent());
            }
        }
    }

    public static class RangeCheck
    implements Notification.Listener {
        @Override
        public void notice(Notification.Type T, EventObject E) {
            Range range;
            Notification.DataflowEvent ce;
            if (!(T != Notification.Type.IN && T != Notification.Type.OUT || !((ce = (Notification.DataflowEvent)E).getValue() instanceof Number) && ce.getValue() == null || (range = ce.getAccess().getField().getAnnotation(Range.class)) == null)) {
                Number v = (Number)ce.getValue();
                if (v != null) {
                    if (range.min() > v.doubleValue() || range.max() < v.doubleValue()) {
                        System.out.println(v + " not within expected range " + range.min() + "..." + range.max() + " in " + ce.getAccess().getComponent() + ")");
                    }
                } else {
                    System.out.println("Null value");
                }
            }
        }
    }
}

