/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oms3.Access;
import oms3.ComponentAccess;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.ClassField;
import org.scannotation.AnnotationDB;
import org.scannotation.ClasspathUrlFinder;

public class JGrassGears {
    public final Map<String, Class<?>> moduleName2Class = new LinkedHashMap();
    public final Map<String, List<ClassField>> moduleName2Fields = new LinkedHashMap<String, List<ClassField>>();
    private static final String PUBLIC_STATIC_FINAL_STRING = "public static final String ";
    private static final String QUOTATION_MARK_SEMICOLON_NEW_LINE = "\";\n";
    private static JGrassGears jgrassGears = null;
    private String[] allFields;
    private String[] allClasses;
    private URL baseclassUrl;

    private JGrassGears(URL baseclassUrl) {
        this.baseclassUrl = baseclassUrl;
    }

    public String[] getAllFields() {
        return this.allFields;
    }

    public void setAllFields(String[] allFields) {
        this.allFields = allFields;
    }

    public String[] getAllClasses() {
        return this.allClasses;
    }

    public void setAllClasses(String[] allClasses) {
        this.allClasses = allClasses;
    }

    public static synchronized JGrassGears getInstance() {
        if (jgrassGears == null) {
            jgrassGears = new JGrassGears(null);
            jgrassGears.gatherInformations();
        }
        return jgrassGears;
    }

    public static JGrassGears getInstance(URL baseclassUrl) {
        jgrassGears = new JGrassGears(baseclassUrl);
        jgrassGears.gatherInformations();
        return jgrassGears;
    }

    private void gatherInformations() {
        try {
            if (this.baseclassUrl == null) {
                this.baseclassUrl = ClasspathUrlFinder.findClassBase(JGrassGears.class);
            }
            AnnotationDB db = new AnnotationDB();
            db.scanArchives(new URL[]{this.baseclassUrl});
            Map annotationIndex = db.getAnnotationIndex();
            Set simpleClasses = (Set)annotationIndex.get(Execute.class.getName());
            for (String className : simpleClasses) {
                if (!className.startsWith("org.hortonmachine.gears")) continue;
                int lastDot = className.lastIndexOf(46);
                String name = className.substring(lastDot + 1);
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(className);
                    this.moduleName2Class.put(name, clazz);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            ArrayList<String> classNames = new ArrayList<String>();
            ArrayList<String> fieldNamesList = new ArrayList<String>();
            Set<Map.Entry<String, Class<?>>> moduleName2ClassEntries = this.moduleName2Class.entrySet();
            for (Map.Entry<String, Class<?>> moduleName2ClassEntry : moduleName2ClassEntries) {
                String statusString;
                String moduleName = moduleName2ClassEntry.getKey();
                Class<?> moduleClass = moduleName2ClassEntry.getValue();
                Status annotation = moduleClass.getAnnotation(Status.class);
                if (annotation == null) {
                    System.out.println("Missing status: " + moduleClass.getCanonicalName());
                    continue;
                }
                int status = annotation.value();
                switch (status) {
                    case 40: {
                        statusString = "CERTIFIED";
                        break;
                    }
                    case 10: {
                        statusString = "DRAFT";
                        break;
                    }
                    case 20: {
                        statusString = "TESTED";
                        break;
                    }
                    default: {
                        statusString = "UNKNOWN";
                    }
                }
                classNames.add(moduleName);
                ArrayList<ClassField> tmpfields = new ArrayList<ClassField>();
                Object annotatedObject = moduleClass.newInstance();
                ComponentAccess cA = new ComponentAccess(annotatedObject);
                Collection<Access> inputs = cA.inputs();
                for (Access access : inputs) {
                    Field field = access.getField();
                    String name = field.getName();
                    Description descriptionAnnot = field.getAnnotation(Description.class);
                    String description = name;
                    if (descriptionAnnot != null && (description = descriptionAnnot.value()) == null) {
                        description = name;
                    }
                    Class<?> fieldClass = field.getType();
                    ClassField cf = new ClassField();
                    cf.isIn = true;
                    cf.fieldName = name;
                    cf.fieldDescription = description;
                    cf.fieldClass = fieldClass;
                    cf.parentClass = moduleClass;
                    cf.parentClassStatus = statusString;
                    if (!fieldNamesList.contains(name)) {
                        fieldNamesList.add(name);
                    }
                    tmpfields.add(cf);
                }
                Collection<Access> outputs = cA.outputs();
                for (Access access : outputs) {
                    Field field = access.getField();
                    String name = field.getName();
                    Description descriptionAnnot = field.getAnnotation(Description.class);
                    String description = name;
                    if (descriptionAnnot != null && (description = descriptionAnnot.value()) == null) {
                        description = name;
                    }
                    Class<?> fieldClass = field.getType();
                    ClassField cf = new ClassField();
                    cf.isOut = true;
                    cf.fieldName = name;
                    cf.fieldDescription = description;
                    cf.fieldClass = fieldClass;
                    cf.parentClass = moduleClass;
                    cf.parentClassStatus = statusString;
                    if (!fieldNamesList.contains(name)) {
                        fieldNamesList.add(name);
                    }
                    tmpfields.add(cf);
                }
                this.moduleName2Fields.put(moduleName, tmpfields);
            }
            Collections.sort(fieldNamesList);
            this.allFields = fieldNamesList.toArray(new String[fieldNamesList.size()]);
            Collections.sort(classNames);
            this.allClasses = classNames.toArray(new String[classNames.size()]);
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        JGrassGears jgr = JGrassGears.getInstance();
        Set<Map.Entry<String, Class<?>>> cls = jgr.moduleName2Class.entrySet();
        for (Map.Entry<String, Class<?>> cl : cls) {
            System.out.println(cl.getValue().getCanonicalName());
        }
        Map<String, List<ClassField>> moduleName2Fields = jgr.moduleName2Fields;
        Map<String, Class<?>> moduleName2Class = jgr.moduleName2Class;
        Set<Map.Entry<String, List<ClassField>>> entrySet = moduleName2Fields.entrySet();
        for (Map.Entry<String, List<ClassField>> entry : entrySet) {
            String moduleName = entry.getKey();
            StringBuilder sb = new StringBuilder();
            Class<?> moduleClass = moduleName2Class.get(moduleName);
            Description description = moduleClass.getAnnotation(Description.class);
            sb.append(PUBLIC_STATIC_FINAL_STRING + moduleName.toUpperCase() + "_DESCRIPTION = \"" + description.value() + QUOTATION_MARK_SEMICOLON_NEW_LINE);
            Documentation documentation = moduleClass.getAnnotation(Documentation.class);
            String doc = documentation == null ? "" : documentation.value();
            sb.append(PUBLIC_STATIC_FINAL_STRING + moduleName.toUpperCase() + "_DOCUMENTATION = \"" + doc + QUOTATION_MARK_SEMICOLON_NEW_LINE);
            Keywords keywords = moduleClass.getAnnotation(Keywords.class);
            String k = keywords == null ? "" : keywords.value();
            sb.append(PUBLIC_STATIC_FINAL_STRING + moduleName.toUpperCase() + "_KEYWORDS = \"" + k + QUOTATION_MARK_SEMICOLON_NEW_LINE);
            Label label = moduleClass.getAnnotation(Label.class);
            String lab = label == null ? "" : label.value();
            sb.append(PUBLIC_STATIC_FINAL_STRING + moduleName.toUpperCase() + "_LABEL = \"" + lab + QUOTATION_MARK_SEMICOLON_NEW_LINE);
            Name name = moduleClass.getAnnotation(Name.class);
            String n = name == null ? "" : name.value();
            sb.append(PUBLIC_STATIC_FINAL_STRING + moduleName.toUpperCase() + "_NAME = \"" + n + QUOTATION_MARK_SEMICOLON_NEW_LINE);
            Status status = moduleClass.getAnnotation(Status.class);
            sb.append("public static final int " + moduleName.toUpperCase() + "_STATUS = " + status.value() + ";\n");
            License license = moduleClass.getAnnotation(License.class);
            sb.append(PUBLIC_STATIC_FINAL_STRING + moduleName.toUpperCase() + "_LICENSE = \"" + license.value() + QUOTATION_MARK_SEMICOLON_NEW_LINE);
            Author author = moduleClass.getAnnotation(Author.class);
            String authorName = author.name();
            sb.append(PUBLIC_STATIC_FINAL_STRING + moduleName.toUpperCase() + "_AUTHORNAMES = \"" + authorName + QUOTATION_MARK_SEMICOLON_NEW_LINE);
            String authorContact = author.contact();
            sb.append(PUBLIC_STATIC_FINAL_STRING + moduleName.toUpperCase() + "_AUTHORCONTACTS = \"" + authorContact + QUOTATION_MARK_SEMICOLON_NEW_LINE);
            UI ui = moduleClass.getAnnotation(UI.class);
            if (ui != null) {
                sb.append(PUBLIC_STATIC_FINAL_STRING + moduleName.toUpperCase() + "_UI = \"" + ui.value() + QUOTATION_MARK_SEMICOLON_NEW_LINE);
            }
            List<ClassField> value = entry.getValue();
            for (ClassField classField : value) {
                String fieldName = classField.fieldName;
                if (fieldName.equals("pm")) continue;
                String fieldDescription = classField.fieldDescription;
                String str = PUBLIC_STATIC_FINAL_STRING + moduleName.toUpperCase() + "_" + fieldName + "_DESCRIPTION = \"" + fieldDescription + QUOTATION_MARK_SEMICOLON_NEW_LINE;
                sb.append(str);
            }
            System.out.println(sb.toString());
            System.out.println();
        }
    }
}

