/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.adige;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.io.CSTable;
import oms3.io.DataIO;
import oms3.io.TableIterator;
import org.hortonmachine.gears.io.adige.AdigeBoundaryCondition;
import org.hortonmachine.gears.libs.modules.HMModel;

@Description(value="Utility class for reading the initial boundary conditions of the model adige from an OMS formatted csv file.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Reading")
@Label(value="Generic Reader")
@Name(value="adigeboundcondreader")
@Status(value=40)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class AdigeBoundaryConditionReader
extends HMModel {
    @Description(value="The csv file to read from.")
    @UI(value="infile_csv")
    @In
    public String file = null;
    @Description(value="The list initial boundary conditions.")
    @Out
    public Map<Integer, AdigeBoundaryCondition> data;
    private TableIterator<String[]> rowsIterator;
    private CSTable table;

    private void ensureOpen() throws IOException {
        if (this.table == null) {
            this.table = DataIO.table(new File(this.file), null);
            this.rowsIterator = (TableIterator)this.table.rows().iterator();
        }
    }

    @Execute
    public void read() throws IOException {
        if (!this.concatOr(this.data == null, this.doReset)) {
            return;
        }
        this.ensureOpen();
        this.data = new HashMap<Integer, AdigeBoundaryCondition>();
        while (this.rowsIterator.hasNext()) {
            String[] row = (String[])this.rowsIterator.next();
            AdigeBoundaryCondition condition = new AdigeBoundaryCondition();
            int i = 1;
            condition.setBasinId((int)Double.parseDouble(row[i++]));
            condition.setDischarge(Double.parseDouble(row[i++]));
            condition.setDischargeSub(Double.parseDouble(row[i++]));
            condition.setS1(Double.parseDouble(row[i++]));
            condition.setS2(Double.parseDouble(row[i]));
            this.data.put(condition.getBasinId(), condition);
        }
    }

    @Finalize
    public void close() throws IOException {
        this.rowsIterator.close();
    }
}

