/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.adige;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.io.CSTable;
import oms3.io.DataIO;
import oms3.io.TableIterator;
import org.hortonmachine.gears.io.adige.VegetationLibraryRecord;
import org.hortonmachine.gears.libs.modules.HMModel;

@Description(value="Utility class for reading data from a OMS formatted csv file assumed to be containing the Vegetation library data.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Reading")
@Label(value="Generic Reader")
@Name(value="vegetationlibraryreader")
@Status(value=40)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class VegetationLibraryReader
extends HMModel {
    @Description(value="The csv file to read from.")
    @UI(value="infile_csv")
    @In
    public String file = null;
    @Description(value="The list of arrays representing the values in the rows.")
    @Out
    public Map<Integer, VegetationLibraryRecord> data;
    private TableIterator<String[]> rowsIterator;
    private CSTable table;

    private void ensureOpen() throws IOException {
        if (this.table == null) {
            this.table = DataIO.table(new File(this.file), null);
            this.rowsIterator = (TableIterator)this.table.rows().iterator();
        }
    }

    @Execute
    public void read() throws IOException {
        if (!this.concatOr(this.data == null, this.doReset)) {
            return;
        }
        this.ensureOpen();
        this.data = new HashMap<Integer, VegetationLibraryRecord>();
        while (this.rowsIterator.hasNext()) {
            String[] row = (String[])this.rowsIterator.next();
            int i = 1;
            int vegetationIndex = (int)Double.parseDouble(row[i++]);
            double architecturalResistance = Double.parseDouble(row[i++]);
            double minStomatalResistanc = Double.parseDouble(row[i++]);
            double[] laiMonths = new double[12];
            for (int j = 0; j < laiMonths.length; ++j) {
                laiMonths[j] = Double.parseDouble(row[i++]);
            }
            double[] albedoMonths = new double[12];
            for (int j = 0; j < albedoMonths.length; ++j) {
                albedoMonths[j] = Double.parseDouble(row[i++]);
            }
            double[] roughMonths = new double[12];
            for (int j = 0; j < roughMonths.length; ++j) {
                roughMonths[j] = Double.parseDouble(row[i++]);
            }
            double[] displMonths = new double[12];
            for (int j = 0; j < displMonths.length; ++j) {
                displMonths[j] = Double.parseDouble(row[i++]);
            }
            double windHeight = Double.parseDouble(row[i++]);
            double rgl = Double.parseDouble(row[i++]);
            double radAtten = Double.parseDouble(row[i++]);
            double windAtten = Double.parseDouble(row[i++]);
            double trunkRatio = Double.parseDouble(row[i]);
            VegetationLibraryRecord vegetation = new VegetationLibraryRecord(vegetationIndex, architecturalResistance, minStomatalResistanc, laiMonths, albedoMonths, roughMonths, displMonths, windHeight, windAtten, rgl, radAtten, trunkRatio);
            this.data.put(vegetationIndex, vegetation);
        }
    }

    @Finalize
    public void close() throws IOException {
        this.rowsIterator.close();
    }
}

