/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dbs;

import java.util.ArrayList;
import java.util.Date;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.hortonmachine.dbs.compat.ADatabaseSyntaxHelper;
import org.hortonmachine.dbs.compat.ASpatialDb;
import org.hortonmachine.dbs.compat.EDb;
import org.hortonmachine.dbs.compat.GeometryColumn;
import org.hortonmachine.dbs.compat.IGeometryParser;
import org.hortonmachine.dbs.compat.IHMResultSet;
import org.hortonmachine.dbs.compat.IHMResultSetMetaData;
import org.hortonmachine.dbs.compat.IHMStatement;
import org.hortonmachine.dbs.datatypes.ESpatialiteGeometryType;
import org.hortonmachine.dbs.log.Logger;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DbsHelper {
    private static final Logger logger = Logger.INSTANCE;

    public static DefaultFeatureCollection runRawSqlToFeatureCollection(String name, ASpatialDb db, String simpleSql, Polygon roi) throws Exception {
        int indexOf = ((String)simpleSql).toLowerCase().indexOf("from");
        String afterFrom = ((String)simpleSql).substring(indexOf + 5).trim();
        String tableName = null;
        if (afterFrom.startsWith("'")) {
            int nextAp = afterFrom.indexOf("'", 1) + 1;
            tableName = afterFrom.substring(0, nextAp);
        } else {
            int nextSpace = afterFrom.indexOf(32);
            tableName = afterFrom.substring(0, nextSpace);
        }
        if (tableName == null) {
            throw new RuntimeException("The geometry table name needs to be the first after the FROM keyword.");
        }
        GeometryColumn geometryColumns = db.getGeometryColumnsForTable(tableName);
        if (geometryColumns == null) {
            throw new IllegalArgumentException("The supplied table name doesn't seem to be spatial: " + tableName);
        }
        if (geometryColumns.srid == 0) {
            geometryColumns.srid = 4326;
        }
        String geomColumnName = geometryColumns.geometryColumnName;
        if (roi != null) {
            String where = db.getSpatialindexGeometryWherePiece(tableName, null, (Geometry)roi);
            simpleSql = (String)simpleSql + " where " + where;
        }
        String _simpleSql = simpleSql;
        return (DefaultFeatureCollection)db.execOnConnection(connection -> {
            DefaultFeatureCollection fc = new DefaultFeatureCollection();
            try (IHMStatement stmt = connection.createStatement();
                 IHMResultSet rs = stmt.executeQuery(_simpleSql);){
                Geometry geometry;
                String columnName;
                String columnTypeName;
                int i;
                IHMResultSetMetaData rsmd = rs.getMetaData();
                int columnCount = rsmd.getColumnCount();
                int geometryIndex = -1;
                CoordinateReferenceSystem crs = CrsUtilities.getCrsFromEpsg("EPSG:" + geometryColumns.srid);
                SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
                String _name = "shpexport";
                if (name != null) {
                    _name = name;
                }
                b.setName(_name);
                b.setCRS(crs);
                EDb eDb = db.getType();
                ADatabaseSyntaxHelper syntaxHelper = eDb.getDatabaseSyntaxHelper();
                IGeometryParser gp = eDb.getGeometryParser();
                for (i = 1; i <= columnCount; ++i) {
                    columnTypeName = rsmd.getColumnTypeName(i);
                    columnName = rsmd.getColumnName(i);
                    if (!geomColumnName.equalsIgnoreCase(columnName) && !ESpatialiteGeometryType.isGeometryName((String)columnTypeName)) continue;
                    geometryIndex = i;
                    if (!rs.next()) continue;
                    geometry = gp.fromResultSet(rs, geometryIndex);
                    b.add("the_geom", geometry.getClass());
                    break;
                }
                for (i = 1; i <= columnCount; ++i) {
                    columnTypeName = rsmd.getColumnTypeName(i);
                    columnName = rsmd.getColumnName(i);
                    if (i == geometryIndex) continue;
                    if (columnName.toLowerCase().equals("id")) {
                        columnName = "origid";
                    }
                    if (columnName.length() > 9) {
                        columnName = columnName.substring(0, 9);
                    }
                    if ("INTEGER".equals(columnTypeName) || syntaxHelper.INTEGER().equals(columnTypeName)) {
                        b.add(columnName, Integer.class);
                        continue;
                    }
                    if (syntaxHelper.LONG().equals(columnTypeName)) {
                        b.add(columnName, Long.class);
                        continue;
                    }
                    if ("DOUBLE".equals(columnTypeName) || "FLOAT".equals(columnTypeName) || syntaxHelper.REAL().equals(columnTypeName)) {
                        b.add(columnName, Double.class);
                        continue;
                    }
                    if ("DATE".equals(columnTypeName)) {
                        b.add(columnName, Date.class);
                        continue;
                    }
                    if (!syntaxHelper.TEXT().equals(columnTypeName)) {
                        // empty if block
                    }
                    b.add(columnName, String.class);
                }
                SimpleFeatureType type = b.buildFeatureType();
                SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
                do {
                    try {
                        ArrayList<Object> values = new ArrayList<Object>();
                        geometry = gp.fromResultSet(rs, geometryIndex);
                        values.add(geometry);
                        for (int j = 1; j <= columnCount; ++j) {
                            if (j == geometryIndex) continue;
                            Object object = rs.getObject(j);
                            values.add(object);
                        }
                        builder.addAll(values);
                        SimpleFeature feature = builder.buildFeature(null);
                        fc.add(feature);
                    }
                    catch (Exception e) {
                        logger.insertError("DbsHelper", "ERROR", (Throwable)e);
                    }
                } while (rs.next());
            }
            return fc;
        });
    }
}

