/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.disktree;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import org.hortonmachine.gears.io.disktree.IDiskTree;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.strtree.STRtree;

public class DiskTreeReader
implements IDiskTree {
    private final String path;
    private STRtree indexObj;
    private RandomAccessFile raf = null;

    public DiskTreeReader(String path) {
        this.path = path;
    }

    public STRtree readIndex() throws Exception {
        File file = new File(this.path);
        this.raf = new RandomAccessFile(file, "r");
        this.raf.seek(6L);
        this.checkVersions();
        long position = 14L;
        this.raf.seek(position);
        long indexAddress = this.raf.readLong();
        position = 22L;
        this.raf.seek(position);
        long indexSize = this.raf.readLong();
        this.raf.seek(indexAddress);
        byte[] indexBytes = new byte[(int)indexSize];
        int read = this.raf.read(indexBytes);
        if ((long)read != indexSize) {
            throw new IOException();
        }
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(indexBytes));
        this.indexObj = (STRtree)in.readObject();
        return this.indexObj;
    }

    private void checkVersions() throws IOException {
        int fileMajor = this.raf.readInt();
        int fileMinor = this.raf.readInt();
        int currMajor = 1;
        int currMinor = 18;
        if (fileMajor != currMajor || fileMinor != currMinor) {
            System.out.println("Warning, the current used JTS version differs from the one used to create the file. Unexpected results may occurr.");
        }
    }

    public Geometry pickGeometry(long position, long size) throws Exception {
        byte[] geomBytes = new byte[(int)size];
        this.raf.seek(position);
        this.raf.read(geomBytes);
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(geomBytes));
        return (Geometry)in.readObject();
    }

    public void close() throws IOException {
        this.raf.close();
    }
}

