/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.hortonmachine.gears.io.dxfdwg.libs.DwgReader;
import org.hortonmachine.gears.io.dxfdwg.libs.GeometryTranslator;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgFile;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DwgHandler {
    private final DwgFile dwgFile;
    private GeometryTranslator gTranslator;

    public DwgHandler(File dxfFile, CoordinateReferenceSystem crs) {
        this.dwgFile = new DwgFile(dxfFile.getAbsolutePath());
        this.gTranslator = new GeometryTranslator(crs);
    }

    public DwgReader getDwgReader() throws Exception {
        return new DwgReader(this.dwgFile, this.gTranslator);
    }

    public List<String> getLayerTypes() throws Exception {
        this.dwgFile.read();
        this.dwgFile.initializeLayerTable();
        this.dwgFile.calculateGisModelDwgPolylines();
        this.dwgFile.applyExtrusions();
        this.dwgFile.testDwg3D();
        this.dwgFile.blockManagement();
        Vector<String> layerNames = this.dwgFile.getLayerNames();
        if (layerNames.isEmpty()) {
            throw new IOException("No layer found in the file.");
        }
        return layerNames;
    }
}

