/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.SchemaException;
import org.hortonmachine.gears.io.dxfdwg.libs.GeometryTranslator;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgFile;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgObject;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgArc;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgAttrib;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgCircle;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgLine;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgLwPolyline;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgMText;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgPoint;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgPolyline2D;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgPolyline3D;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgSolid;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgText;
import org.opengis.feature.simple.SimpleFeature;

public class DwgReader {
    DwgFile file;
    FeatureIterator<SimpleFeature> enumeration;
    int chosenLayerType = -1;
    private static final String LINES = "lines";
    private DefaultFeatureCollection contourFeatures = new DefaultFeatureCollection();
    private DefaultFeatureCollection multiLineFeatures = new DefaultFeatureCollection();
    private DefaultFeatureCollection multiPointFeatures = new DefaultFeatureCollection();
    private DefaultFeatureCollection multiPolygonFeatures = new DefaultFeatureCollection();
    private DefaultFeatureCollection textFeatures = new DefaultFeatureCollection();
    private DefaultFeatureCollection attributesFeatures = new DefaultFeatureCollection();

    public DwgReader(DwgFile pFile, GeometryTranslator gTranslator) throws SchemaException {
        this.file = pFile;
        Vector dwgObjects = this.file.getDwgObjects();
        int cat = 0;
        int elenmentnum = dwgObjects.size();
        for (int i = 0; i < elenmentnum; ++i) {
            DwgObject text;
            SimpleFeature feature;
            DwgObject entity = (DwgObject)dwgObjects.get(i);
            String layerName = pFile.getLayerName(entity);
            if (entity instanceof DwgArc) {
                DwgArc arc = (DwgArc)entity;
                feature = gTranslator.convertDwgArc(LINES, layerName, arc, cat);
                this.multiLineFeatures.add(feature);
            } else if (entity instanceof DwgCircle) {
                DwgCircle circle = (DwgCircle)entity;
                feature = gTranslator.convertDwgCircle("polygons", layerName, circle, cat);
                this.multiPolygonFeatures.add(feature);
            } else if (entity instanceof DwgLine) {
                DwgLine line = (DwgLine)entity;
                feature = gTranslator.convertDwgLine(LINES, layerName, line, cat);
                this.multiLineFeatures.add(feature);
            } else if (entity instanceof DwgPoint) {
                DwgPoint point = (DwgPoint)entity;
                feature = gTranslator.convertDwgPoint("points", layerName, point, cat);
                this.multiPointFeatures.add(feature);
            } else if (entity instanceof DwgPolyline2D) {
                DwgPolyline2D polyline2d = (DwgPolyline2D)entity;
                feature = gTranslator.convertDwgPolyline2D(LINES, layerName, polyline2d, cat);
                if (feature != null) {
                    this.multiLineFeatures.add(feature);
                }
            } else if (entity instanceof DwgPolyline3D) {
                DwgPolyline3D polyline3d = (DwgPolyline3D)entity;
                feature = gTranslator.convertDwgPolyline3D(LINES, layerName, polyline3d, cat);
                if (feature != null) {
                    this.multiLineFeatures.add(feature);
                }
            } else if (entity instanceof DwgText) {
                text = (DwgText)entity;
                feature = gTranslator.convertDwgText("text", layerName, (DwgText)text, cat);
                this.textFeatures.add(feature);
            } else if (entity instanceof DwgAttrib) {
                DwgAttrib attribute = (DwgAttrib)entity;
                feature = gTranslator.convertDwgAttribute("text", layerName, attribute, cat);
                this.attributesFeatures.add(feature);
            } else if (entity instanceof DwgMText) {
                text = (DwgMText)entity;
                feature = gTranslator.convertDwgMText("text", layerName, (DwgMText)text, cat);
                this.textFeatures.add(feature);
            } else if (entity instanceof DwgSolid) {
                DwgSolid solid = (DwgSolid)entity;
                feature = gTranslator.convertDwgSolid("polygon", layerName, solid, cat);
                this.multiPolygonFeatures.add(feature);
            } else if (entity instanceof DwgLwPolyline) {
                DwgLwPolyline lwPolyline = (DwgLwPolyline)entity;
                feature = gTranslator.convertDwgLwPolyline(LINES, layerName, lwPolyline, cat);
                this.multiLineFeatures.add(feature);
            }
            ++cat;
        }
    }

    public Map<String, SimpleFeatureCollection> getFeatureCollectionsMap() throws IOException {
        HashMap<String, SimpleFeatureCollection> map = new HashMap<String, SimpleFeatureCollection>();
        if (!this.textFeatures.isEmpty()) {
            map.put("text", (SimpleFeatureCollection)this.textFeatures);
        }
        if (!this.attributesFeatures.isEmpty()) {
            map.put("text", (SimpleFeatureCollection)this.attributesFeatures);
        }
        if (!this.multiLineFeatures.isEmpty()) {
            map.put(LINES, (SimpleFeatureCollection)this.multiLineFeatures);
        }
        if (!this.contourFeatures.isEmpty()) {
            map.put(LINES, (SimpleFeatureCollection)this.contourFeatures);
        }
        if (!this.multiPointFeatures.isEmpty()) {
            map.put("points", (SimpleFeatureCollection)this.multiPointFeatures);
        }
        if (!this.multiPolygonFeatures.isEmpty()) {
            map.put("polygons", (SimpleFeatureCollection)this.multiPolygonFeatures);
        }
        return map;
    }

    public SimpleFeatureCollection getTextFeatures() {
        return this.textFeatures;
    }

    public SimpleFeatureCollection getAttributesFeatures() {
        return this.attributesFeatures;
    }

    public SimpleFeatureCollection getMultiLineFeatures() {
        return this.multiLineFeatures;
    }

    public SimpleFeatureCollection getContourFeatures() {
        return this.contourFeatures;
    }

    public SimpleFeatureCollection getMultiPointFeatures() {
        return this.multiPointFeatures;
    }

    public SimpleFeatureCollection getMultiPolygonFeatures() {
        return this.multiPolygonFeatures;
    }

    public synchronized void close() throws IOException {
        if (this.file != null) {
            this.file = null;
        }
        this.enumeration = null;
    }
}

