/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs.dwg;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Vector;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgClass;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgFileReader;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgFileV14Reader;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgFileV15Reader;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgObject;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgObjectOffset;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgSectionOffset;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgArc;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgAttdef;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgAttrib;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgBlock;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgBlockControl;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgBlockHeader;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgCircle;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgEllipse;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgEndblk;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgInsert;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgLayer;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgLayerControl;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgLine;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgLinearDimension;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgLwPolyline;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgMText;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgPoint;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgPolyline2D;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgPolyline3D;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgSeqend;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgSolid;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgSpline;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgText;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgVertex2D;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgVertex3D;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.utils.AcadExtrusionCalculator;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.utils.GisModelCurveCalculator;

public class DwgFile {
    private String fileName;
    private String dwgVersion;
    private Vector dwgSectionOffsets;
    private Vector dwgObjectOffsets;
    private Vector dwgObjects;
    private Vector dwgClasses;
    private DwgFileReader dwgReader;
    private Vector layerTable;
    private Vector layerNames;
    private boolean dwg3DFile;

    public DwgFile(String filePath) {
        this.fileName = filePath;
        this.dwgSectionOffsets = new Vector();
        this.dwgObjectOffsets = new Vector();
        this.dwgObjects = new Vector();
        this.dwgClasses = new Vector();
    }

    public void read() throws IOException {
        System.out.println("DwgFile.read() executed ...");
        this.setDwgVersion();
        if (this.dwgVersion.equals("R13")) {
            this.dwgReader = new DwgFileV14Reader();
            this.dwgReader.read(this);
        } else if (this.dwgVersion.equals("R14")) {
            this.dwgReader = new DwgFileV14Reader();
            this.dwgReader.read(this);
        } else if (this.dwgVersion.equals("R15")) {
            this.dwgReader = new DwgFileV15Reader();
            this.dwgReader.read(this);
        } else if (this.dwgVersion.equals("Unknown")) {
            throw new IOException("DWG version of the file is not supported.");
        }
    }

    public void applyExtrusions() {
        for (int i = 0; i < this.dwgObjects.size(); ++i) {
            int j;
            Point2D[] vertices;
            DwgObject dwgObject = (DwgObject)this.dwgObjects.get(i);
            if (dwgObject instanceof DwgArc) {
                double[] arcCenter = ((DwgArc)dwgObject).getCenter();
                double[] arcExt = ((DwgArc)dwgObject).getExtrusion();
                arcCenter = AcadExtrusionCalculator.CalculateAcadExtrusion(arcCenter, arcExt);
                ((DwgArc)dwgObject).setCenter(arcCenter);
                continue;
            }
            if (dwgObject instanceof DwgAttdef) continue;
            if (dwgObject instanceof DwgAttrib) {
                Point2D attribInsertionPoint = ((DwgAttrib)dwgObject).getInsertionPoint();
                double attribElevation = ((DwgAttrib)dwgObject).getElevation();
                double[] attribInsertionPoint3D = new double[]{attribInsertionPoint.getX(), attribInsertionPoint.getY(), attribElevation};
                double[] attribExt = ((DwgAttrib)dwgObject).getExtrusion();
                attribInsertionPoint3D = AcadExtrusionCalculator.CalculateAcadExtrusion(attribInsertionPoint3D, attribExt);
                ((DwgAttrib)dwgObject).setInsertionPoint(new Point2D.Double(attribInsertionPoint3D[0], attribInsertionPoint3D[1]));
                ((DwgAttrib)dwgObject).setElevation(attribInsertionPoint3D[2]);
                continue;
            }
            if (dwgObject instanceof DwgBlock || dwgObject instanceof DwgBlockControl || dwgObject instanceof DwgBlockHeader) continue;
            if (dwgObject instanceof DwgCircle) {
                double[] circleCenter = ((DwgCircle)dwgObject).getCenter();
                double[] circleExt = ((DwgCircle)dwgObject).getExtrusion();
                circleCenter = AcadExtrusionCalculator.CalculateAcadExtrusion(circleCenter, circleExt);
                ((DwgCircle)dwgObject).setCenter(circleCenter);
                continue;
            }
            if (dwgObject instanceof DwgInsert) {
                double[] insertPoint = ((DwgInsert)dwgObject).getInsertionPoint();
                double[] insertExt = ((DwgInsert)dwgObject).getExtrusion();
                insertPoint = AcadExtrusionCalculator.CalculateAcadExtrusion(insertPoint, insertExt);
                ((DwgInsert)dwgObject).setInsertionPoint(insertPoint);
                continue;
            }
            if (dwgObject instanceof DwgLayer || dwgObject instanceof DwgLayerControl) continue;
            if (dwgObject instanceof DwgLine) {
                double[] lineP1 = ((DwgLine)dwgObject).getP1();
                double[] lineP2 = ((DwgLine)dwgObject).getP2();
                boolean zflag = ((DwgLine)dwgObject).isZflag();
                if (zflag) {
                    lineP1 = new double[]{lineP1[0], lineP1[1], 0.0};
                    lineP2 = new double[]{lineP2[0], lineP2[1], 0.0};
                }
                double[] lineExt = ((DwgLine)dwgObject).getExtrusion();
                lineP1 = AcadExtrusionCalculator.CalculateAcadExtrusion(lineP1, lineExt);
                lineP2 = AcadExtrusionCalculator.CalculateAcadExtrusion(lineP2, lineExt);
                ((DwgLine)dwgObject).setP1(lineP1);
                ((DwgLine)dwgObject).setP2(lineP2);
                continue;
            }
            if (dwgObject instanceof DwgLinearDimension) continue;
            if (dwgObject instanceof DwgLwPolyline && ((DwgLwPolyline)dwgObject).getVertices() != null) {
                vertices = ((DwgLwPolyline)dwgObject).getVertices();
                double[] lwPolylineExt = ((DwgLwPolyline)dwgObject).getNormal();
                if (lwPolylineExt[0] == 0.0 && lwPolylineExt[1] == 0.0 && lwPolylineExt[2] == 0.0) {
                    lwPolylineExt[2] = 1.0;
                }
                double elev = ((DwgLwPolyline)dwgObject).getElevation();
                double[][] lwPolylinePoints3D = new double[vertices.length][3];
                for (j = 0; j < vertices.length; ++j) {
                    lwPolylinePoints3D[j][0] = vertices[j].getX();
                    lwPolylinePoints3D[j][1] = vertices[j].getY();
                    lwPolylinePoints3D[j][2] = elev;
                    lwPolylinePoints3D[j] = AcadExtrusionCalculator.CalculateAcadExtrusion(lwPolylinePoints3D[j], lwPolylineExt);
                }
                ((DwgLwPolyline)dwgObject).setElevation(elev);
                for (j = 0; j < vertices.length; ++j) {
                    vertices[j] = new Point2D.Double(lwPolylinePoints3D[j][0], lwPolylinePoints3D[j][1]);
                }
                ((DwgLwPolyline)dwgObject).setVertices(vertices);
                continue;
            }
            if (dwgObject instanceof DwgMText) {
                double[] mtextPoint = ((DwgMText)dwgObject).getInsertionPoint();
                double[] mtextExt = ((DwgMText)dwgObject).getExtrusion();
                mtextPoint = AcadExtrusionCalculator.CalculateAcadExtrusion(mtextPoint, mtextExt);
                ((DwgMText)dwgObject).setInsertionPoint(mtextPoint);
                continue;
            }
            if (dwgObject instanceof DwgPoint) {
                double[] point = ((DwgPoint)dwgObject).getPoint();
                double[] pointExt = ((DwgPoint)dwgObject).getExtrusion();
                point = AcadExtrusionCalculator.CalculateAcadExtrusion(point, pointExt);
                ((DwgPoint)dwgObject).setPoint(point);
                continue;
            }
            if (dwgObject instanceof DwgSolid) {
                double[] corner1 = ((DwgSolid)dwgObject).getCorner1();
                double[] corner2 = ((DwgSolid)dwgObject).getCorner2();
                double[] corner3 = ((DwgSolid)dwgObject).getCorner3();
                double[] corner4 = ((DwgSolid)dwgObject).getCorner4();
                double[] solidExt = ((DwgSolid)dwgObject).getExtrusion();
                corner1 = AcadExtrusionCalculator.CalculateAcadExtrusion(corner1, solidExt);
                ((DwgSolid)dwgObject).setCorner1(corner1);
                ((DwgSolid)dwgObject).setCorner2(corner2);
                ((DwgSolid)dwgObject).setCorner3(corner3);
                ((DwgSolid)dwgObject).setCorner4(corner4);
                continue;
            }
            if (dwgObject instanceof DwgSpline) continue;
            if (dwgObject instanceof DwgText) {
                Point2D tpoint = ((DwgText)dwgObject).getInsertionPoint();
                double elev = ((DwgText)dwgObject).getElevation();
                double[] textPoint = new double[]{tpoint.getX(), tpoint.getY(), elev};
                double[] textExt = ((DwgText)dwgObject).getExtrusion();
                textPoint = AcadExtrusionCalculator.CalculateAcadExtrusion(textPoint, textExt);
                ((DwgText)dwgObject).setInsertionPoint(new Point2D.Double(textPoint[0], textPoint[1]));
                ((DwgText)dwgObject).setElevation(elev);
                continue;
            }
            if (dwgObject instanceof DwgPolyline2D && ((DwgPolyline2D)dwgObject).getPts() != null) {
                vertices = ((DwgPolyline2D)dwgObject).getPts();
                double[] polyline2DExt = ((DwgPolyline2D)dwgObject).getExtrusion();
                double elev = ((DwgPolyline2D)dwgObject).getElevation();
                double[][] polylinePoints3D = new double[vertices.length][3];
                for (j = 0; j < vertices.length; ++j) {
                    polylinePoints3D[j][0] = vertices[j].getX();
                    polylinePoints3D[j][1] = vertices[j].getY();
                    polylinePoints3D[j][2] = elev;
                    polylinePoints3D[j] = AcadExtrusionCalculator.CalculateAcadExtrusion(polylinePoints3D[j], polyline2DExt);
                }
                ((DwgPolyline2D)dwgObject).setElevation(elev);
                for (j = 0; j < vertices.length; ++j) {
                    vertices[j] = new Point2D.Double(polylinePoints3D[j][0], polylinePoints3D[j][1]);
                }
                ((DwgPolyline2D)dwgObject).setPts(vertices);
                continue;
            }
            if (!(dwgObject instanceof DwgPolyline3D) && !(dwgObject instanceof DwgVertex2D) && !(dwgObject instanceof DwgVertex3D)) continue;
        }
    }

    public void calculateGisModelDwgPolylines() {
        for (int i = 0; i < this.dwgObjects.size(); ++i) {
            int j;
            Vector<Object> pts;
            int flags;
            DwgObject pol = (DwgObject)this.dwgObjects.get(i);
            if (pol instanceof DwgPolyline2D) {
                int j2;
                flags = ((DwgPolyline2D)pol).getFlags();
                int firstHandle = ((DwgPolyline2D)pol).getFirstVertexHandle();
                int lastHandle = ((DwgPolyline2D)pol).getLastVertexHandle();
                pts = new Vector<Object>();
                Vector<Double> bulges = new Vector<Double>();
                double[] pt = new double[3];
                block1: for (int j3 = 0; j3 < this.dwgObjects.size(); ++j3) {
                    int vertexHandle;
                    DwgObject firstVertex = (DwgObject)this.dwgObjects.get(j3);
                    if (!(firstVertex instanceof DwgVertex2D) || (vertexHandle = firstVertex.getHandle()) != firstHandle) continue;
                    int k = 0;
                    while (true) {
                        DwgObject vertex = (DwgObject)this.dwgObjects.get(j3 + k);
                        int vHandle = vertex.getHandle();
                        if (vertex instanceof DwgVertex2D) {
                            pt = ((DwgVertex2D)vertex).getPoint();
                            pts.add(new Point2D.Double(pt[0], pt[1]));
                            double bulge = ((DwgVertex2D)vertex).getBulge();
                            bulges.add(new Double(bulge));
                            ++k;
                            if (vHandle != lastHandle || !(vertex instanceof DwgVertex2D)) continue;
                            continue block1;
                        }
                        if (vertex instanceof DwgSeqend) break;
                    }
                }
                if (pts.size() <= 0) continue;
                Point2D[] newPts = new Point2D[pts.size()];
                if ((flags & 1) == 1) {
                    newPts = new Point2D[pts.size() + 1];
                    for (j2 = 0; j2 < pts.size(); ++j2) {
                        newPts[j2] = (Point2D)pts.get(j2);
                    }
                    newPts[pts.size()] = (Point2D)pts.get(0);
                    bulges.add(new Double(0.0));
                } else {
                    for (j2 = 0; j2 < pts.size(); ++j2) {
                        newPts[j2] = (Point2D)pts.get(j2);
                    }
                }
                double[] bs = new double[bulges.size()];
                for (int j4 = 0; j4 < bulges.size(); ++j4) {
                    bs[j4] = (Double)bulges.get(j4);
                }
                ((DwgPolyline2D)pol).setBulges(bs);
                Point2D[] points = GisModelCurveCalculator.calculateGisModelBulge(newPts, bs);
                ((DwgPolyline2D)pol).setPts(points);
                continue;
            }
            if (pol instanceof DwgPolyline3D) {
                int j5;
                int closedFlags = ((DwgPolyline3D)pol).getClosedFlags();
                int firstHandle = ((DwgPolyline3D)pol).getFirstVertexHandle();
                int lastHandle = ((DwgPolyline3D)pol).getLastVertexHandle();
                pts = new Vector();
                double[] pt = new double[3];
                block6: for (int j6 = 0; j6 < this.dwgObjects.size(); ++j6) {
                    int vertexHandle;
                    DwgObject firstVertex = (DwgObject)this.dwgObjects.get(j6);
                    if (!(firstVertex instanceof DwgVertex3D) || (vertexHandle = firstVertex.getHandle()) != firstHandle) continue;
                    int k = 0;
                    while (true) {
                        DwgObject vertex = (DwgObject)this.dwgObjects.get(j6 + k);
                        int vHandle = vertex.getHandle();
                        if (vertex instanceof DwgVertex3D) {
                            pt = ((DwgVertex3D)vertex).getPoint();
                            pts.add(new double[]{pt[0], pt[1], pt[2]});
                            ++k;
                            if (vHandle != lastHandle || !(vertex instanceof DwgVertex3D)) continue;
                            continue block6;
                        }
                        if (vertex instanceof DwgSeqend) break;
                    }
                }
                if (pts.size() <= 0) continue;
                double[][] newPts = new double[pts.size()][3];
                if ((closedFlags & 1) == 1) {
                    newPts = new double[pts.size() + 1][3];
                    for (j5 = 0; j5 < pts.size(); ++j5) {
                        newPts[j5][0] = ((double[])pts.get(j5))[0];
                        newPts[j5][1] = ((double[])pts.get(j5))[1];
                        newPts[j5][2] = ((double[])pts.get(j5))[2];
                    }
                    newPts[pts.size()][0] = ((double[])pts.get(0))[0];
                    newPts[pts.size()][1] = ((double[])pts.get(0))[1];
                    newPts[pts.size()][2] = ((double[])pts.get(0))[2];
                } else {
                    for (j5 = 0; j5 < pts.size(); ++j5) {
                        newPts[j5][0] = ((double[])pts.get(j5))[0];
                        newPts[j5][1] = ((double[])pts.get(j5))[1];
                        newPts[j5][2] = ((double[])pts.get(j5))[2];
                    }
                }
                ((DwgPolyline3D)pol).setPts(newPts);
                continue;
            }
            if (!(pol instanceof DwgLwPolyline) || ((DwgLwPolyline)pol).getVertices() == null) continue;
            flags = ((DwgLwPolyline)pol).getFlag();
            Point2D[] pts2 = ((DwgLwPolyline)pol).getVertices();
            double[] bulges = ((DwgLwPolyline)pol).getBulges();
            Point2D[] newPts = new Point2D[pts2.length];
            double[] newBulges = new double[bulges.length];
            if (flags == 512 || flags == 776 || flags == 768) {
                newPts = new Point2D[pts2.length + 1];
                newBulges = new double[bulges.length + 1];
                for (j = 0; j < pts2.length; ++j) {
                    newPts[j] = pts2[j];
                }
                newPts[pts2.length] = pts2[0];
                newBulges[pts2.length] = 0.0;
            } else {
                for (j = 0; j < pts2.length; ++j) {
                    newPts[j] = pts2[j];
                }
            }
            if (pts2.length <= 0) continue;
            ((DwgLwPolyline)pol).setBulges(newBulges);
            Point2D[] points = GisModelCurveCalculator.calculateGisModelBulge(newPts, newBulges);
            ((DwgLwPolyline)pol).setVertices(points);
        }
    }

    public void calculateCadModelDwgPolylines() {
        for (int i = 0; i < this.dwgObjects.size(); ++i) {
            DwgObject pol = (DwgObject)this.dwgObjects.get(i);
            if (pol instanceof DwgPolyline2D) {
                int flags = ((DwgPolyline2D)pol).getFlags();
                int firstHandle = ((DwgPolyline2D)pol).getFirstVertexHandle();
                int lastHandle = ((DwgPolyline2D)pol).getLastVertexHandle();
                Vector<Point2D.Double> pts = new Vector<Point2D.Double>();
                Vector<Double> bulges = new Vector<Double>();
                double[] pt = new double[3];
                block1: for (int j = 0; j < this.dwgObjects.size(); ++j) {
                    int vertexHandle;
                    DwgObject firstVertex = (DwgObject)this.dwgObjects.get(j);
                    if (!(firstVertex instanceof DwgVertex2D) || (vertexHandle = firstVertex.getHandle()) != firstHandle) continue;
                    int k = 0;
                    while (true) {
                        DwgObject vertex = (DwgObject)this.dwgObjects.get(j + k);
                        int vHandle = vertex.getHandle();
                        if (vertex instanceof DwgVertex2D) {
                            pt = ((DwgVertex2D)vertex).getPoint();
                            pts.add(new Point2D.Double(pt[0], pt[1]));
                            double bulge = ((DwgVertex2D)vertex).getBulge();
                            bulges.add(new Double(bulge));
                            ++k;
                            if (vHandle != lastHandle || !(vertex instanceof DwgVertex2D)) continue;
                            continue block1;
                        }
                        if (vertex instanceof DwgSeqend) break;
                    }
                }
                if (pts.size() <= 0) continue;
                double[] bs = new double[bulges.size()];
                for (int j = 0; j < bulges.size(); ++j) {
                    bs[j] = (Double)bulges.get(j);
                }
                ((DwgPolyline2D)pol).setBulges(bs);
                Point2D[] points = new Point2D[pts.size()];
                for (int j = 0; j < pts.size(); ++j) {
                    points[j] = (Point2D)pts.get(j);
                }
                ((DwgPolyline2D)pol).setPts(points);
                continue;
            }
            if (!(pol instanceof DwgPolyline3D) && pol instanceof DwgLwPolyline && ((DwgLwPolyline)pol).getVertices() == null) continue;
        }
    }

    public void blockManagement() {
        Vector<DwgObject> dwgObjectsWithoutBlocks = new Vector<DwgObject>();
        boolean addingToBlock = false;
        for (int i = 0; i < this.dwgObjects.size(); ++i) {
            try {
                DwgObject entity = (DwgObject)this.dwgObjects.get(i);
                if (entity instanceof DwgArc && !addingToBlock) {
                    dwgObjectsWithoutBlocks.add(entity);
                    continue;
                }
                if (entity instanceof DwgEllipse && !addingToBlock) {
                    dwgObjectsWithoutBlocks.add(entity);
                    continue;
                }
                if (entity instanceof DwgCircle && !addingToBlock) {
                    dwgObjectsWithoutBlocks.add(entity);
                    continue;
                }
                if (entity instanceof DwgPolyline2D && !addingToBlock) {
                    dwgObjectsWithoutBlocks.add(entity);
                    continue;
                }
                if (entity instanceof DwgPolyline3D && !addingToBlock) {
                    dwgObjectsWithoutBlocks.add(entity);
                    continue;
                }
                if (entity instanceof DwgLwPolyline && !addingToBlock) {
                    dwgObjectsWithoutBlocks.add(entity);
                    continue;
                }
                if (entity instanceof DwgSolid && !addingToBlock) {
                    dwgObjectsWithoutBlocks.add(entity);
                    continue;
                }
                if (entity instanceof DwgLine && !addingToBlock) {
                    dwgObjectsWithoutBlocks.add(entity);
                    continue;
                }
                if (entity instanceof DwgPoint && !addingToBlock) {
                    dwgObjectsWithoutBlocks.add(entity);
                    continue;
                }
                if (entity instanceof DwgMText && !addingToBlock) {
                    dwgObjectsWithoutBlocks.add(entity);
                    continue;
                }
                if (entity instanceof DwgText && !addingToBlock) {
                    dwgObjectsWithoutBlocks.add(entity);
                    continue;
                }
                if (entity instanceof DwgAttrib && !addingToBlock) {
                    dwgObjectsWithoutBlocks.add(entity);
                    continue;
                }
                if (entity instanceof DwgAttdef && !addingToBlock) {
                    dwgObjectsWithoutBlocks.add(entity);
                    continue;
                }
                if (entity instanceof DwgBlock) {
                    addingToBlock = true;
                    continue;
                }
                if (entity instanceof DwgEndblk) {
                    addingToBlock = false;
                    continue;
                }
                if (entity instanceof DwgBlockHeader) {
                    addingToBlock = true;
                    continue;
                }
                if (entity instanceof DwgInsert && addingToBlock) continue;
            }
            catch (StackOverflowError e) {
                e.printStackTrace();
                System.out.println("Overflowerror at object: " + i);
            }
        }
        this.dwgObjects = dwgObjectsWithoutBlocks;
    }

    private void manageInsert(Point2D insPoint, double[] scale, double rot, int bHandle, int id, Vector dwgObjectsWithoutBlocks) {
        for (int i = 0; i < this.dwgObjects.size(); ++i) {
            int j;
            int objHandle;
            DwgObject obj = (DwgObject)this.dwgObjects.get(i);
            if (!(obj instanceof DwgBlockHeader) || (objHandle = ((DwgBlockHeader)obj).getHandle()) != bHandle) continue;
            double[] bPoint = ((DwgBlockHeader)obj).getBasePoint();
            String bname = ((DwgBlockHeader)obj).getName();
            if (bname.startsWith("*")) continue;
            int firstObjectHandle = ((DwgBlockHeader)obj).getFirstEntityHandle();
            int lastObjectHandle = ((DwgBlockHeader)obj).getLastEntityHandle();
            DwgBlock block = null;
            for (j = 0; j < this.dwgObjects.size(); ++j) {
                String name;
                DwgObject ent = (DwgObject)this.dwgObjects.get(j);
                if (!(ent instanceof DwgBlock) || !bname.equals(name = ((DwgBlock)ent).getName())) continue;
                block = (DwgBlock)ent;
                break;
            }
            for (j = 0; j < this.dwgObjects.size(); ++j) {
                int iObjHandle;
                int fObjHandle;
                DwgObject fObj = (DwgObject)this.dwgObjects.get(j);
                if (fObj == null || (fObjHandle = fObj.getHandle()) != firstObjectHandle) continue;
                int k = 0;
                do {
                    DwgObject iObj = (DwgObject)this.dwgObjects.get(j + k);
                    iObjHandle = iObj.getHandle();
                    this.manageBlockEntity(iObj, bPoint, insPoint, scale, rot, id, dwgObjectsWithoutBlocks);
                    ++k;
                } while (iObjHandle != lastObjectHandle);
            }
            break;
        }
    }

    private void manageBlockEntity(DwgObject entity, double[] bPoint, Point2D insPoint, double[] scale, double rot, int id, Vector dwgObjectsWithoutBlocks) {
        if (entity instanceof DwgArc) {
            DwgArc transformedEntity = new DwgArc();
            double[] center = ((DwgArc)entity).getCenter();
            Point2D.Double pointAux = new Point2D.Double(center[0] - bPoint[0], center[1] - bPoint[1]);
            double laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
            double laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
            double laZ = center[2] * scale[2];
            double[] transformedCenter = new double[]{laX, laY, laZ};
            double radius = ((DwgArc)entity).getRadius();
            double transformedRadius = radius * scale[0];
            double initAngle = ((DwgArc)entity).getInitAngle();
            double endAngle = ((DwgArc)entity).getEndAngle();
            double transformedInitAngle = initAngle + rot;
            if (transformedInitAngle < 0.0) {
                transformedInitAngle += Math.PI * 2;
            } else if (transformedInitAngle > Math.PI * 2) {
                transformedInitAngle -= Math.PI * 2;
            }
            double transformedEndAngle = endAngle + rot;
            if (transformedEndAngle < 0.0) {
                transformedEndAngle += Math.PI * 2;
            } else if (transformedEndAngle > Math.PI * 2) {
                transformedEndAngle -= Math.PI * 2;
            }
            transformedEntity = (DwgArc)((DwgArc)entity).clone();
            transformedEntity.setCenter(transformedCenter);
            transformedEntity.setRadius(transformedRadius);
            transformedEntity.setInitAngle(transformedInitAngle);
            transformedEntity.setEndAngle(transformedEndAngle);
            dwgObjectsWithoutBlocks.add(transformedEntity);
        } else if (entity instanceof DwgCircle) {
            DwgCircle transformedEntity = new DwgCircle();
            double[] center = ((DwgCircle)entity).getCenter();
            Point2D.Double pointAux = new Point2D.Double(center[0] - bPoint[0], center[1] - bPoint[1]);
            double laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
            double laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
            double laZ = center[2] * scale[2];
            double[] transformedCenter = new double[]{laX, laY, laZ};
            double radius = ((DwgCircle)entity).getRadius();
            double transformedRadius = radius * scale[0];
            transformedEntity = (DwgCircle)((DwgCircle)entity).clone();
            transformedEntity.setCenter(transformedCenter);
            transformedEntity.setRadius(transformedRadius);
            dwgObjectsWithoutBlocks.add(transformedEntity);
        } else if (entity instanceof DwgEllipse) {
            double axisRatio;
            DwgEllipse transformedEntity = new DwgEllipse();
            double[] center = ((DwgEllipse)entity).getCenter();
            Point2D.Double pointAux = new Point2D.Double(center[0] - bPoint[0], center[1] - bPoint[1]);
            double laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
            double laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
            double laZ = center[2] * scale[2];
            double[] transformedCenter = new double[]{laX, laY, laZ};
            double[] majorAxisVector = ((DwgEllipse)entity).getMajorAxisVector();
            double[] transformedMajorAxisVector = new double[]{majorAxisVector[0] * scale[0], majorAxisVector[1] * scale[1], majorAxisVector[2] * scale[2]};
            double transformedAxisRatio = axisRatio = ((DwgEllipse)entity).getAxisRatio();
            double initAngle = ((DwgEllipse)entity).getInitAngle();
            double endAngle = ((DwgEllipse)entity).getEndAngle();
            double transformedInitAngle = initAngle + rot;
            if (transformedInitAngle < 0.0) {
                transformedInitAngle += Math.PI * 2;
            } else if (transformedInitAngle > Math.PI * 2) {
                transformedInitAngle -= Math.PI * 2;
            }
            double transformedEndAngle = endAngle + rot;
            if (transformedEndAngle < 0.0) {
                transformedEndAngle += Math.PI * 2;
            } else if (transformedEndAngle > Math.PI * 2) {
                transformedEndAngle -= Math.PI * 2;
            }
            transformedEntity = (DwgEllipse)((DwgEllipse)entity).clone();
            transformedEntity.setCenter(transformedCenter);
            transformedEntity.setMajorAxisVector(transformedMajorAxisVector);
            transformedEntity.setAxisRatio(transformedAxisRatio);
            transformedEntity.setInitAngle(transformedInitAngle);
            transformedEntity.setEndAngle(transformedEndAngle);
            dwgObjectsWithoutBlocks.add(transformedEntity);
        } else if (entity instanceof DwgLine) {
            DwgLine transformedEntity = new DwgLine();
            double[] p1 = ((DwgLine)entity).getP1();
            double[] p2 = ((DwgLine)entity).getP2();
            Point2D.Double pointAux = new Point2D.Double(p1[0] - bPoint[0], p1[1] - bPoint[1]);
            double laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
            double laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
            double[] transformedP1 = null;
            if (((DwgLine)entity).isZflag()) {
                double laZ = p1[2] * scale[2];
                transformedP1 = new double[]{laX, laY, laZ};
            } else {
                transformedP1 = new double[]{laX, laY};
            }
            pointAux = new Point2D.Double(p2[0] - bPoint[0], p2[1] - bPoint[1]);
            laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
            laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
            double[] transformedP2 = null;
            if (((DwgLine)entity).isZflag()) {
                double laZ = p2[2] * scale[2];
                transformedP2 = new double[]{laX, laY, laZ};
            } else {
                transformedP2 = new double[]{laX, laY};
            }
            transformedEntity = (DwgLine)((DwgLine)entity).clone();
            transformedEntity.setP1(transformedP1);
            transformedEntity.setP2(transformedP2);
            dwgObjectsWithoutBlocks.add(transformedEntity);
        } else if (entity instanceof DwgLwPolyline) {
            DwgLwPolyline transformedEntity = new DwgLwPolyline();
            Point2D[] vertices = ((DwgLwPolyline)entity).getVertices();
            if (vertices != null) {
                Point2D[] transformedVertices = new Point2D[vertices.length];
                for (int i = 0; i < vertices.length; ++i) {
                    Point2D.Double pointAux = new Point2D.Double(vertices[i].getX() - bPoint[0], vertices[i].getY() - bPoint[1]);
                    double laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
                    double laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
                    transformedVertices[i] = new Point2D.Double(laX, laY);
                }
                transformedEntity = (DwgLwPolyline)((DwgLwPolyline)entity).clone();
                transformedEntity.setVertices(transformedVertices);
                transformedEntity.setElevation(((DwgLwPolyline)entity).getElevation() * scale[2]);
                dwgObjectsWithoutBlocks.add(transformedEntity);
            }
        } else if (!(entity instanceof DwgMText) && !(entity instanceof DwgPoint)) {
            if (entity instanceof DwgPolyline2D) {
                DwgPolyline2D transformedEntity = new DwgPolyline2D();
                Point2D[] vertices = ((DwgPolyline2D)entity).getPts();
                if (vertices != null) {
                    Point2D[] transformedVertices = new Point2D[vertices.length];
                    for (int i = 0; i < vertices.length; ++i) {
                        Point2D.Double pointAux = new Point2D.Double(vertices[i].getX() - bPoint[0], vertices[i].getY() - bPoint[1]);
                        double laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
                        double laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
                        transformedVertices[i] = new Point2D.Double(laX, laY);
                    }
                    transformedEntity = (DwgPolyline2D)((DwgPolyline2D)entity).clone();
                    transformedEntity.setPts(transformedVertices);
                    transformedEntity.setElevation(((DwgPolyline2D)entity).getElevation() * scale[2]);
                    dwgObjectsWithoutBlocks.add(transformedEntity);
                }
            } else if (!(entity instanceof DwgPolyline3D)) {
                if (entity instanceof DwgSolid) {
                    DwgSolid transformedEntity = new DwgSolid();
                    double[] corner1 = ((DwgSolid)entity).getCorner1();
                    double[] corner2 = ((DwgSolid)entity).getCorner2();
                    double[] corner3 = ((DwgSolid)entity).getCorner3();
                    double[] corner4 = ((DwgSolid)entity).getCorner4();
                    Point2D.Double pointAux = new Point2D.Double(corner1[0] - bPoint[0], corner1[1] - bPoint[1]);
                    double laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
                    double laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
                    double[] transformedP1 = new double[]{laX, laY};
                    pointAux = new Point2D.Double(corner2[0] - bPoint[0], corner2[1] - bPoint[1]);
                    laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
                    laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
                    double[] transformedP2 = new double[]{laX, laY};
                    pointAux = new Point2D.Double(corner3[0] - bPoint[0], corner3[1] - bPoint[1]);
                    laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
                    laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
                    double[] transformedP3 = new double[]{laX, laY};
                    pointAux = new Point2D.Double(corner4[0] - bPoint[0], corner4[1] - bPoint[1]);
                    laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
                    laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
                    double[] transformedP4 = new double[]{laX, laY};
                    transformedEntity = (DwgSolid)((DwgSolid)entity).clone();
                    transformedEntity.setCorner1(transformedP1);
                    transformedEntity.setCorner2(transformedP2);
                    transformedEntity.setCorner3(transformedP3);
                    transformedEntity.setCorner4(transformedP4);
                    transformedEntity.setElevation(((DwgSolid)entity).getElevation() * scale[2]);
                    dwgObjectsWithoutBlocks.add(transformedEntity);
                } else if (!(entity instanceof DwgSpline) && !(entity instanceof DwgText) && entity instanceof DwgInsert) {
                    DwgInsert transformedEntity = new DwgInsert();
                    double[] p = ((DwgInsert)entity).getInsertionPoint();
                    Point2D.Double point = new Point2D.Double(p[0], p[1]);
                    double[] newScale = ((DwgInsert)entity).getScale();
                    double newRot = ((DwgInsert)entity).getRotation();
                    int newBlockHandle = ((DwgInsert)entity).getBlockHeaderHandle();
                    Point2D.Double pointAux = new Point2D.Double(((Point2D)point).getX() - bPoint[0], ((Point2D)point).getY() - bPoint[1]);
                    double laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
                    double laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
                    double laZ = p[2] * scale[2];
                    Point2D.Double newInsPoint = new Point2D.Double(laX, laY);
                    newScale = new double[]{scale[0] * newScale[0], scale[1] * newScale[1], scale[2] * newScale[2]};
                    if ((newRot += rot) < 0.0) {
                        newRot += Math.PI * 2;
                    } else if (newRot > Math.PI * 2) {
                        newRot -= Math.PI * 2;
                    }
                    this.manageInsert(newInsPoint, newScale, newRot, newBlockHandle, id, dwgObjectsWithoutBlocks);
                }
            }
        }
    }

    public void initializeLayerTable() {
        this.layerTable = new Vector();
        this.layerNames = new Vector();
        for (int i = 0; i < this.dwgObjects.size(); ++i) {
            DwgObject obj = (DwgObject)this.dwgObjects.get(i);
            if (!(obj instanceof DwgLayer)) continue;
            Vector<Object> layerTableRecord = new Vector<Object>();
            layerTableRecord.add(new Integer(obj.getHandle()));
            layerTableRecord.add(((DwgLayer)obj).getName());
            layerTableRecord.add(new Integer(((DwgLayer)obj).getColor()));
            this.layerTable.add(layerTableRecord);
            this.layerNames.add(((DwgLayer)obj).getName());
        }
        System.out.println("");
    }

    public String getLayerName(DwgObject entity) {
        String layerName = "";
        int layer = entity.getLayerHandle();
        for (int j = 0; j < this.layerTable.size(); ++j) {
            Vector layerTableRecord = (Vector)this.layerTable.get(j);
            int lHandle = (Integer)layerTableRecord.get(0);
            if (lHandle != layer) continue;
            layerName = (String)layerTableRecord.get(1);
        }
        if (layerName.equals("")) {
            return "0";
        }
        return layerName;
    }

    public int getColorByLayer(DwgObject entity) {
        int colorByLayer = 0;
        int layer = entity.getLayerHandle();
        for (int j = 0; j < this.layerTable.size(); ++j) {
            Vector layerTableRecord = (Vector)this.layerTable.get(j);
            int lHandle = (Integer)layerTableRecord.get(0);
            if (lHandle != layer) continue;
            colorByLayer = (Integer)layerTableRecord.get(2);
        }
        return colorByLayer;
    }

    private void setDwgVersion() throws IOException {
        System.out.println("DwgFile.setDwgVersion() executed ...");
        File file = new File(this.fileName);
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        long channelSize = fileChannel.size();
        MappedByteBuffer byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, channelSize);
        byte[] versionBytes = new byte[]{byteBuffer.get(0), byteBuffer.get(1), byteBuffer.get(2), byteBuffer.get(3), byteBuffer.get(4), byteBuffer.get(5)};
        ByteBuffer versionByteBuffer = ByteBuffer.wrap(versionBytes);
        String versionString = this.readDwgVersion(versionByteBuffer);
        String version = versionString.equals("AC1009") ? new String("R12") : (versionString.equals("AC1010") ? new String("R12+") : (versionString.equals("AC1012") ? new String("R13") : (versionString.equals("AC1014") ? new String("R14") : (versionString.equals("AC1015") ? new String("R15") : new String("Unknown")))));
        this.dwgVersion = version;
    }

    private String readDwgVersion(ByteBuffer versionBuffer) {
        String[] bs = new String[versionBuffer.capacity()];
        Object sv = "";
        for (int i = 0; i < versionBuffer.capacity(); ++i) {
            bs[i] = new String(new byte[]{versionBuffer.get(i)});
            sv = (String)sv + bs[i];
        }
        return sv;
    }

    public void testDwg3D() {
        for (int i = 0; i < this.dwgObjects.size(); ++i) {
            int j;
            DwgObject obj = (DwgObject)this.dwgObjects.get(i);
            double z = 0.0;
            if (obj instanceof DwgArc) {
                z = ((DwgArc)obj).getCenter()[2];
                if (z == 0.0) continue;
                this.dwg3DFile = true;
                continue;
            }
            if (obj instanceof DwgAttrib) {
                z = ((DwgAttrib)obj).getElevation();
                if (z == 0.0) continue;
                this.dwg3DFile = true;
                continue;
            }
            if (obj instanceof DwgBlockHeader) {
                z = ((DwgBlockHeader)obj).getBasePoint()[2];
                if (z == 0.0) continue;
                this.dwg3DFile = true;
                continue;
            }
            if (obj instanceof DwgCircle) {
                z = ((DwgCircle)obj).getCenter()[2];
                if (z == 0.0) continue;
                this.dwg3DFile = true;
                continue;
            }
            if (obj instanceof DwgEllipse) {
                z = ((DwgEllipse)obj).getCenter()[2];
                if (z == 0.0) continue;
                this.dwg3DFile = true;
                continue;
            }
            if (obj instanceof DwgInsert) {
                z = ((DwgInsert)obj).getInsertionPoint()[2];
                if (z == 0.0) continue;
                this.dwg3DFile = true;
                continue;
            }
            if (obj instanceof DwgLine) {
                if (((DwgLine)obj).isZflag()) continue;
                double z1 = ((DwgLine)obj).getP1()[2];
                double z2 = ((DwgLine)obj).getP2()[2];
                if (z1 == 0.0 && z2 == 0.0) continue;
                this.dwg3DFile = true;
                continue;
            }
            if (obj instanceof DwgLwPolyline) {
                z = ((DwgLwPolyline)obj).getElevation();
                if (z == 0.0) continue;
                this.dwg3DFile = true;
                continue;
            }
            if (obj instanceof DwgMText) {
                z = ((DwgMText)obj).getInsertionPoint()[2];
                if (z == 0.0) continue;
                this.dwg3DFile = true;
                continue;
            }
            if (obj instanceof DwgPoint) {
                z = ((DwgPoint)obj).getPoint()[2];
                if (z == 0.0) continue;
                this.dwg3DFile = true;
                continue;
            }
            if (obj instanceof DwgPolyline2D) {
                z = ((DwgPolyline2D)obj).getElevation();
                if (z == 0.0) continue;
                this.dwg3DFile = true;
                continue;
            }
            if (obj instanceof DwgPolyline3D) {
                if (((DwgPolyline3D)obj).getPts() == null) continue;
                double[][] pts = ((DwgPolyline3D)obj).getPts();
                for (j = 0; j < pts.length; ++j) {
                    z = pts[j][2];
                    if (z == 0.0) continue;
                    this.dwg3DFile = true;
                }
                continue;
            }
            if (obj instanceof DwgSolid) {
                z = ((DwgSolid)obj).getElevation();
                if (z == 0.0) continue;
                this.dwg3DFile = true;
                continue;
            }
            if (obj instanceof DwgSpline) {
                double[][] pts = ((DwgSpline)obj).getControlPoints();
                for (j = 0; j < pts.length; ++j) {
                    z = pts[j][2];
                    if (z == 0.0) continue;
                    this.dwg3DFile = true;
                }
                continue;
            }
            if (!(obj instanceof DwgText) || (z = ((DwgText)obj).getElevation()) == 0.0) continue;
            this.dwg3DFile = true;
        }
    }

    public void addDwgSectionOffset(String key, int seek, int size) {
        DwgSectionOffset dso = new DwgSectionOffset(key, seek, size);
        this.dwgSectionOffsets.add(dso);
    }

    public int getDwgSectionOffset(String key) {
        int offset = 0;
        for (int i = 0; i < this.dwgSectionOffsets.size(); ++i) {
            DwgSectionOffset dso = (DwgSectionOffset)this.dwgSectionOffsets.get(i);
            String ikey = dso.getKey();
            if (!key.equals(ikey)) continue;
            offset = dso.getSeek();
            break;
        }
        return offset;
    }

    public void addDwgObjectOffset(int handle, int offset) {
        DwgObjectOffset doo = new DwgObjectOffset(handle, offset);
        this.dwgObjectOffsets.add(doo);
    }

    public void addDwgObject(DwgObject dwgObject) {
        this.dwgObjects.add(dwgObject);
    }

    public void addDwgClass(DwgClass dwgClass) {
        System.out.println("DwgFile.addDwgClass() executed ...");
        this.dwgClasses.add(dwgClass);
    }

    public Vector getDwgObjectOffsets() {
        return this.dwgObjectOffsets;
    }

    public Vector getDwgObjects() {
        return this.dwgObjects;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isDwg3DFile() {
        return this.dwg3DFile;
    }

    public void setDwg3DFile(boolean dwg3DFile) {
        this.dwg3DFile = dwg3DFile;
    }

    public Vector<String> getLayerNames() {
        return this.layerNames;
    }
}

