/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs.dwg;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Vector;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgFile;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgFileReader;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgObject;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgObjectOffset;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgUtil;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgArc;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgAttdef;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgAttrib;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgBlock;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgBlockControl;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgBlockHeader;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgCircle;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgEllipse;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgEndblk;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgInsert;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgLayer;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgLayerControl;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgLine;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgLinearDimension;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgLwPolyline;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgMText;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgPoint;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgPolyline2D;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgPolyline3D;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgSeqend;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgSolid;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgSpline;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgText;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgVertex2D;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects.DwgVertex3D;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.utils.ByteUtils;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.utils.HexUtil;

public class DwgFileV15Reader
extends DwgFileReader {
    private DwgFile dwgFile;

    @Override
    public void read(DwgFile dwgFile) throws IOException {
        System.out.println("DwgFileV15Reader.read() executed ...");
        this.dwgFile = dwgFile;
        File f = new File(dwgFile.getFileName());
        FileInputStream fis = new FileInputStream(f);
        FileChannel fc = fis.getChannel();
        long s = fc.size();
        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, s);
        this.readDwgSectionOffsets(bb);
        try {
            this.readDwgObjectOffsets(bb);
        }
        catch (Exception e) {
            System.out.println("Error leyendo offsets y classes. Posible corrupci\ufffdn enel DWG file ...");
        }
        long t1 = System.currentTimeMillis();
        this.readDwgObjects(bb);
        long t2 = System.currentTimeMillis();
        System.out.println("Tiempo empleado por readDwgObjects() = " + (t2 - t1));
    }

    private void readDwgSectionOffsets(ByteBuffer bb) {
        bb.position(19);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        short codePage = bb.getShort();
        int count = bb.getInt();
        for (int i = 0; i < count; ++i) {
            byte rec = bb.get();
            int seek = bb.getInt();
            int size = bb.getInt();
            if (rec == 0) {
                this.dwgFile.addDwgSectionOffset("HEADERS", seek, size);
                continue;
            }
            if (rec == 1) {
                this.dwgFile.addDwgSectionOffset("CLASSES", seek, size);
                continue;
            }
            if (rec == 2) {
                this.dwgFile.addDwgSectionOffset("OBJECTS", seek, size);
                continue;
            }
            if (rec == 3) {
                this.dwgFile.addDwgSectionOffset("UNKNOWN", seek, size);
                continue;
            }
            if (rec == 4) {
                this.dwgFile.addDwgSectionOffset("R14DATA", seek, size);
                continue;
            }
            if (rec == 5) {
                this.dwgFile.addDwgSectionOffset("R14REC5", seek, size);
                continue;
            }
            System.out.println("ERROR: C\ufffddigo de n\ufffdmero de registro no soportado: " + rec);
        }
    }

    private void readDwgObjectOffsets(ByteBuffer bb) throws Exception {
        int offset = this.dwgFile.getDwgSectionOffset("OBJECTS");
        bb.position(offset);
        block0: while (true) {
            bb.order(ByteOrder.BIG_ENDIAN);
            short size = bb.getShort();
            if (size == 2) break;
            bb.order(ByteOrder.LITTLE_ENDIAN);
            byte[] dataBytes = new byte[size];
            for (int i = 0; i < dataBytes.length; ++i) {
                dataBytes[i] = bb.get();
            }
            int[] data = DwgUtil.bytesToMachineBytes(dataBytes);
            int lastHandle = 0;
            int lastLoc = 0;
            int bitPos = 0;
            int bitMax = (size - 2) * 8;
            while (true) {
                if (bitPos >= bitMax) continue block0;
                Vector v = DwgUtil.getModularChar(data, bitPos);
                bitPos = (Integer)v.get(0);
                lastHandle += ((Integer)v.get(1)).intValue();
                v = DwgUtil.getModularChar(data, bitPos);
                bitPos = (Integer)v.get(0);
                this.dwgFile.addDwgObjectOffset(lastHandle, lastLoc += ((Integer)v.get(1)).intValue());
            }
            break;
        }
    }

    private void readDwgClasses(ByteBuffer bb) throws Exception {
        int offset = this.dwgFile.getDwgSectionOffset("CLASSES");
        bb.position(offset + 16);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        int size = bb.getInt();
        byte[] dataBytes = new byte[size];
        for (int i = 0; i < dataBytes.length; ++i) {
            dataBytes[i] = bb.get();
        }
        int[] data = DwgUtil.bytesToMachineBytes(dataBytes);
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)ByteUtils.getUnsigned((byte)data[i]);
        }
        bb.position(bb.position() + 2 + 16);
        int maxbit = size * 8;
        int bitPos = 0;
        while (bitPos + 8 < maxbit) {
            Vector v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            v = DwgUtil.getTextString(data, bitPos);
            bitPos = (Integer)v.get(0);
            v = DwgUtil.getTextString(data, bitPos);
            bitPos = (Integer)v.get(0);
            v = DwgUtil.getTextString(data, bitPos);
            bitPos = (Integer)v.get(0);
            v = DwgUtil.testBit(data, bitPos);
            bitPos = (Integer)v.get(0);
            v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
        }
    }

    private void readDwgObjects(ByteBuffer bb) {
        for (int i = 0; i < this.dwgFile.getDwgObjectOffsets().size(); ++i) {
            DwgObjectOffset doo = (DwgObjectOffset)this.dwgFile.getDwgObjectOffsets().get(i);
            DwgObject obj = this.readDwgObject(bb, doo.getOffset());
            if (obj == null) continue;
            this.dwgFile.addDwgObject(obj);
        }
    }

    private DwgObject readDwgObject(ByteBuffer bb, int offset) {
        try {
            bb.position(offset);
            int size = DwgUtil.getModularShort(bb);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            byte[] dataBytes = new byte[size];
            String[] dataMachValString = new String[size];
            int[] data = new int[size];
            for (int i = 0; i < size; ++i) {
                dataBytes[i] = bb.get();
                dataMachValString[i] = HexUtil.bytesToHex(new byte[]{dataBytes[i]});
                Integer dataMachValShort = Integer.decode("0x" + dataMachValString[i]);
                data[i] = dataMachValShort.byteValue();
                data[i] = ByteUtils.getUnsigned((byte)data[i]);
            }
            int bitPos = 0;
            Vector v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            int type = (Integer)v.get(1);
            DwgObject obj = new DwgObject();
            if (type == 17) {
                obj = new DwgArc();
                obj.setGraphicsFlag(true);
            } else if (type == 18) {
                obj = new DwgCircle();
                obj.setGraphicsFlag(true);
            } else if (type == 19) {
                obj = new DwgLine();
                obj.setGraphicsFlag(true);
            } else if (type == 27) {
                obj = new DwgPoint();
                obj.setGraphicsFlag(true);
            } else if (type == 15) {
                obj = new DwgPolyline2D();
                obj.setGraphicsFlag(true);
            } else if (type == 16) {
                obj = new DwgPolyline3D();
                obj.setGraphicsFlag(true);
            } else if (type == 10) {
                obj = new DwgVertex2D();
                obj.setGraphicsFlag(true);
            } else if (type == 11) {
                obj = new DwgVertex3D();
                obj.setGraphicsFlag(true);
            } else if (type == 6) {
                obj = new DwgSeqend();
                obj.setGraphicsFlag(true);
            } else if (type == 1) {
                obj = new DwgText();
                obj.setGraphicsFlag(true);
            } else if (type == 2) {
                obj = new DwgAttrib();
                obj.setGraphicsFlag(true);
            } else if (type == 3) {
                obj = new DwgAttdef();
                obj.setGraphicsFlag(true);
            } else if (type == 4) {
                obj = new DwgBlock();
                obj.setGraphicsFlag(true);
            } else if (type == 5) {
                obj = new DwgEndblk();
                obj.setGraphicsFlag(true);
            } else if (type == 48) {
                obj = new DwgBlockControl();
                obj.setGraphicsFlag(false);
            } else if (type == 49) {
                obj = new DwgBlockHeader();
                obj.setGraphicsFlag(false);
            } else if (type == 50) {
                obj = new DwgLayerControl();
                obj.setGraphicsFlag(false);
            } else if (type == 51) {
                obj = new DwgLayer();
                obj.setGraphicsFlag(false);
            } else if (type == 7) {
                obj = new DwgInsert();
                obj.setGraphicsFlag(true);
            } else if (type == 44) {
                obj = new DwgMText();
                obj.setGraphicsFlag(true);
            } else if (type == 31) {
                obj = new DwgSolid();
                obj.setGraphicsFlag(true);
            } else if (type == 35) {
                obj = new DwgEllipse();
                obj.setGraphicsFlag(true);
            } else if (type == 36) {
                obj = new DwgSpline();
                obj.setGraphicsFlag(true);
            } else if (type == 21) {
                obj = new DwgLinearDimension();
                obj.setGraphicsFlag(true);
            } else if (type == 77) {
                obj = new DwgLwPolyline();
                obj.setGraphicsFlag(true);
            } else if (type == 78) {
                obj = new DwgLwPolyline();
                obj.setGraphicsFlag(true);
            } else if (type == 79) {
                obj = new DwgLwPolyline();
                obj.setGraphicsFlag(true);
            } else if (type == 80) {
                obj = new DwgLwPolyline();
                obj.setGraphicsFlag(true);
            } else if (type == 81) {
                obj = new DwgLwPolyline();
                obj.setGraphicsFlag(true);
            } else if (type == 82) {
                obj = new DwgLwPolyline();
                obj.setGraphicsFlag(true);
            } else if (type == 83) {
                obj = new DwgLwPolyline();
                obj.setGraphicsFlag(true);
            }
            obj.setType(type);
            v = DwgUtil.getRawLong(data, bitPos);
            bitPos = (Integer)v.get(0);
            int objBSize = (Integer)v.get(1);
            obj.setSizeInBits(objBSize);
            Vector entityHandle = new Vector();
            v = DwgUtil.getHandle(data, bitPos);
            bitPos = (Integer)v.get(0);
            for (int i = 1; i < v.size(); ++i) {
                entityHandle.add(v.get(i));
            }
            obj.setHandle(DwgUtil.handleBinToHandleInt(entityHandle));
            v = DwgUtil.readExtendedData(data, bitPos);
            bitPos = (Integer)v.get(0);
            Vector extData = (Vector)v.get(1);
            obj.setExtendedData(extData);
            boolean gflag = false;
            gflag = obj.isGraphicsFlag();
            if (gflag) {
                v = DwgUtil.testBit(data, bitPos);
                bitPos = (Integer)v.get(0);
                boolean val = (Boolean)v.get(1);
                if (val) {
                    v = DwgUtil.getRawLong(data, bitPos);
                    bitPos = (Integer)v.get(0);
                    size = (Integer)v.get(1);
                    int bgSize = size * 8;
                    Integer giData = (Integer)DwgUtil.getBits(data, bgSize, bitPos);
                    obj.setGraphicData(giData);
                    bitPos += bgSize;
                }
            }
            this.readSpecificObject(obj, data, bitPos);
            return obj;
        }
        catch (Exception e) {
            System.out.println("Exception capturada. Probablemente se ha encontrado unobjeto con type non fixed");
            return null;
        }
    }

    private void readSpecificObject(DwgObject obj, int[] data, int bitPos) throws Exception {
        if (obj.getType() == 17) {
            ((DwgArc)obj).readDwgArcV15(data, bitPos);
        } else if (obj.getType() == 18) {
            ((DwgCircle)obj).readDwgCircleV15(data, bitPos);
        } else if (obj.getType() == 19) {
            ((DwgLine)obj).readDwgLineV15(data, bitPos);
        } else if (obj.getType() == 27) {
            ((DwgPoint)obj).readDwgPointV15(data, bitPos);
        } else if (obj.getType() == 15) {
            ((DwgPolyline2D)obj).readDwgPolyline2DV15(data, bitPos);
        } else if (obj.getType() == 16) {
            ((DwgPolyline3D)obj).readDwgPolyline3DV15(data, bitPos);
        } else if (obj.getType() == 10) {
            ((DwgVertex2D)obj).readDwgVertex2DV15(data, bitPos);
        } else if (obj.getType() == 11) {
            ((DwgVertex3D)obj).readDwgVertex3DV15(data, bitPos);
        } else if (obj.getType() == 6) {
            ((DwgSeqend)obj).readDwgSeqendV15(data, bitPos);
        } else if (obj.getType() == 1) {
            ((DwgText)obj).readDwgTextV15(data, bitPos);
        } else if (obj.getType() == 2) {
            ((DwgAttrib)obj).readDwgAttribV15(data, bitPos);
        } else if (obj.getType() == 3) {
            ((DwgAttdef)obj).readDwgAttdefV15(data, bitPos);
        } else if (obj.getType() == 4) {
            ((DwgBlock)obj).readDwgBlockV15(data, bitPos);
        } else if (obj.getType() == 5) {
            ((DwgEndblk)obj).readDwgEndblkV15(data, bitPos);
        } else if (obj.getType() == 48) {
            ((DwgBlockControl)obj).readDwgBlockControlV15(data, bitPos);
        } else if (obj.getType() == 49) {
            ((DwgBlockHeader)obj).readDwgBlockHeaderV15(data, bitPos);
        } else if (obj.getType() == 50) {
            ((DwgLayerControl)obj).readDwgLayerControlV15(data, bitPos);
        } else if (obj.getType() == 51) {
            ((DwgLayer)obj).readDwgLayerV15(data, bitPos);
        } else if (obj.getType() == 7) {
            ((DwgInsert)obj).readDwgInsertV15(data, bitPos);
        } else if (obj.getType() == 44) {
            ((DwgMText)obj).readDwgMTextV15(data, bitPos);
        } else if (obj.getType() == 31) {
            ((DwgSolid)obj).readDwgSolidV15(data, bitPos);
        } else if (obj.getType() == 35) {
            ((DwgEllipse)obj).readDwgEllipseV15(data, bitPos);
        } else if (obj.getType() == 36) {
            ((DwgSpline)obj).readDwgSplineV15(data, bitPos);
        } else if (obj.getType() != 20 && obj.getType() != 21 && obj.getType() != 22 && obj.getType() != 23 && obj.getType() != 24 && obj.getType() != 25 && obj.getType() != 26) {
            if (obj.getType() == 77) {
                ((DwgLwPolyline)obj).readDwgLwPolylineV15(data, bitPos);
            } else if (obj.getType() == 78) {
                ((DwgLwPolyline)obj).readDwgLwPolylineV15(data, bitPos);
            } else if (obj.getType() == 79) {
                ((DwgLwPolyline)obj).readDwgLwPolylineV15(data, bitPos);
            } else if (obj.getType() == 80) {
                ((DwgLwPolyline)obj).readDwgLwPolylineV15(data, bitPos);
            } else if (obj.getType() == 81) {
                ((DwgLwPolyline)obj).readDwgLwPolylineV15(data, bitPos);
            } else if (obj.getType() == 82) {
                ((DwgLwPolyline)obj).readDwgLwPolylineV15(data, bitPos);
            } else if (obj.getType() == 83) {
                ((DwgLwPolyline)obj).readDwgLwPolylineV15(data, bitPos);
            }
        }
    }
}

