/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs.dwg;

import java.util.Vector;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgUtil;

public class DwgObject {
    protected int type;
    protected int handle;
    protected int layerHandleCode;
    protected String version;
    protected int mode;
    protected int layerHandle;
    protected int color;
    protected int numReactors;
    protected boolean noLinks;
    protected int linetypeFlags;
    protected int plotstyleFlags;
    protected int sizeInBits;
    protected Vector extendedData;
    protected int graphicData;
    protected int subEntityHandle;
    protected int xDicObjHandle;
    protected boolean graphicsFlag;

    public int readObjectHeaderV15(int[] data, int offset) throws Exception {
        int bitPos = offset;
        Integer mode = (Integer)DwgUtil.getBits(data, 2, bitPos);
        this.setMode(mode);
        Vector v = DwgUtil.getBitLong(data, bitPos += 2);
        bitPos = (Integer)v.get(0);
        int rnum = (Integer)v.get(1);
        this.setNumReactors(rnum);
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        boolean nolinks = (Boolean)v.get(1);
        this.setNoLinks(nolinks);
        v = DwgUtil.getBitShort(data, bitPos);
        bitPos = (Integer)v.get(0);
        int color = (Integer)v.get(1);
        this.setColor(color);
        v = DwgUtil.getBitDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        float ltscale = ((Double)v.get(1)).floatValue();
        Integer ltflag = (Integer)DwgUtil.getBits(data, 2, bitPos);
        Integer psflag = (Integer)DwgUtil.getBits(data, 2, bitPos += 2);
        v = DwgUtil.getBitShort(data, bitPos += 2);
        bitPos = (Integer)v.get(0);
        int invis = (Integer)v.get(1);
        v = DwgUtil.getRawChar(data, bitPos);
        bitPos = (Integer)v.get(0);
        int weight = (Integer)v.get(1);
        return bitPos;
    }

    public int readObjectTailV15(int[] data, int offset) throws Exception {
        int i;
        int bitPos = offset;
        Vector v = null;
        if (this.getMode() == 0) {
            v = DwgUtil.getHandle(data, bitPos);
            bitPos = (Integer)v.get(0);
            int[] sh = new int[v.size() - 1];
            for (int i2 = 1; i2 < v.size(); ++i2) {
                sh[i2 - 1] = (Integer)v.get(i2);
            }
            Vector<Integer> shv = new Vector<Integer>();
            for (i = 0; i < sh.length; ++i) {
                shv.add(new Integer(sh[i]));
            }
            this.setSubEntityHandle(DwgUtil.handleBinToHandleInt(shv));
        }
        for (int i3 = 0; i3 < this.getNumReactors(); ++i3) {
            v = DwgUtil.getHandle(data, bitPos);
            bitPos = (Integer)v.get(0);
            int[] handle = new int[v.size() - 1];
            for (int j = 1; j < v.size(); ++j) {
                handle[j - 1] = (Integer)v.get(j);
            }
        }
        v = DwgUtil.getHandle(data, bitPos);
        bitPos = (Integer)v.get(0);
        int[] xh = new int[v.size() - 1];
        for (int i4 = 1; i4 < v.size(); ++i4) {
            xh[i4 - 1] = (Integer)v.get(i4);
        }
        Vector<Integer> xhv = new Vector<Integer>();
        for (i = 0; i < xh.length; ++i) {
            xhv.add(new Integer(xh[i]));
        }
        this.setXDicObjHandle(DwgUtil.handleBinToHandleInt(xhv));
        v = DwgUtil.getHandle(data, bitPos);
        bitPos = (Integer)v.get(0);
        int[] lh = new int[v.size() - 1];
        for (int i5 = 1; i5 < v.size(); ++i5) {
            lh[i5 - 1] = (Integer)v.get(i5);
        }
        this.setLayerHandleCode(lh[0]);
        Vector<Integer> lhv = new Vector<Integer>();
        for (int i6 = 0; i6 < lh.length; ++i6) {
            lhv.add(new Integer(lh[i6]));
        }
        this.setLayerHandle(DwgUtil.handleBinToHandleInt(lhv));
        if (!this.isNoLinks()) {
            v = DwgUtil.getHandle(data, bitPos);
            bitPos = (Integer)v.get(0);
            int[] prev = new int[v.size() - 1];
            for (int i7 = 1; i7 < v.size(); ++i7) {
                prev[i7 - 1] = (Integer)v.get(i7);
            }
            v = DwgUtil.getHandle(data, bitPos);
            bitPos = (Integer)v.get(0);
            int[] next = new int[v.size() - 1];
            for (int i8 = 1; i8 < v.size(); ++i8) {
                next[i8 - 1] = (Integer)v.get(i8);
            }
        }
        if (this.getLinetypeFlags() == 3) {
            v = DwgUtil.getHandle(data, bitPos);
            bitPos = (Integer)v.get(0);
            int[] lth = new int[v.size() - 1];
            for (int i9 = 1; i9 < v.size(); ++i9) {
                lth[i9 - 1] = (Integer)v.get(i9);
            }
        }
        if (this.getPlotstyleFlags() == 3) {
            v = DwgUtil.getHandle(data, bitPos);
            bitPos = (Integer)v.get(0);
            int[] pth = new int[v.size() - 1];
            for (int i10 = 1; i10 < v.size(); ++i10) {
                pth[i10 - 1] = (Integer)v.get(i10);
            }
        }
        return bitPos;
    }

    public int getSizeInBits() {
        return this.sizeInBits;
    }

    public void setSizeInBits(int sizeInBits) {
        this.sizeInBits = sizeInBits;
    }

    public Vector getExtendedData() {
        return this.extendedData;
    }

    public void setExtendedData(Vector extendedData) {
        this.extendedData = extendedData;
    }

    public int getGraphicData() {
        return this.graphicData;
    }

    public void setGraphicData(int graphicData) {
        this.graphicData = graphicData;
    }

    public String getVersion() {
        return this.version;
    }

    public void setLinetypeFlags(int linetypeFlags) {
        this.linetypeFlags = linetypeFlags;
    }

    public void setPlotstyleFlags(int plotstyleFlags) {
        this.plotstyleFlags = plotstyleFlags;
    }

    public int getSubEntityHandle() {
        return this.subEntityHandle;
    }

    public void setSubEntityHandle(int subEntityHandle) {
        this.subEntityHandle = subEntityHandle;
    }

    public int getXDicObjHandle() {
        return this.xDicObjHandle;
    }

    public void setXDicObjHandle(int dicObjHandle) {
        this.xDicObjHandle = dicObjHandle;
    }

    public int getLayerHandleCode() {
        return this.layerHandleCode;
    }

    public void setLayerHandleCode(int layerHandleCode) {
        this.layerHandleCode = layerHandleCode;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getHandle() {
        return this.handle;
    }

    public void setHandle(int handle) {
        this.handle = handle;
    }

    public int getLayerHandle() {
        return this.layerHandle;
    }

    public void setLayerHandle(int layerHandle) {
        this.layerHandle = layerHandle;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public boolean isNoLinks() {
        return this.noLinks;
    }

    public void setNoLinks(boolean noLinks) {
        this.noLinks = noLinks;
    }

    public int getNumReactors() {
        return this.numReactors;
    }

    public void setNumReactors(int numReactors) {
        this.numReactors = numReactors;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getLinetypeFlags() {
        return this.linetypeFlags;
    }

    public int getPlotstyleFlags() {
        return this.plotstyleFlags;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isGraphicsFlag() {
        return this.graphicsFlag;
    }

    public void setGraphicsFlag(boolean graphicsFlag) {
        this.graphicsFlag = graphicsFlag;
    }
}

