/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs.dwg;

import java.io.Serializable;
import java.lang.constant.Constable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Vector;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.utils.ByteUtils;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.utils.HexUtil;

public final class DwgUtil {
    public static Vector readExtendedData(int[] data, int offset) throws Exception {
        int bitPos = offset;
        Vector extData = new Vector();
        while (true) {
            int newBitPos = (Integer)DwgUtil.getBitShort(data, bitPos).get(0);
            int size = (Integer)DwgUtil.getBitShort(data, bitPos).get(1);
            bitPos = newBitPos;
            if (size == 0) break;
            newBitPos = (Integer)DwgUtil.getHandle(data, bitPos).get(0);
            int handle = (Integer)DwgUtil.getHandle(data, bitPos).get(1);
            bitPos = newBitPos;
            Vector<Object> eedata = new Vector<Object>();
            while (size > 0) {
                newBitPos = (Integer)DwgUtil.getRawChar(data, bitPos).get(0);
                int cb = (Integer)DwgUtil.getRawChar(data, bitPos).get(1);
                bitPos = newBitPos;
                --size;
                if (cb == 0) {
                    newBitPos = (Integer)DwgUtil.getRawChar(data, bitPos).get(0);
                    int len = (Integer)DwgUtil.getRawChar(data, bitPos).get(1);
                    bitPos = newBitPos;
                    newBitPos = (Integer)DwgUtil.getRawShort(data, bitPos).get(0);
                    int cp = (Integer)DwgUtil.getRawShort(data, bitPos).get(1);
                    bitPos = newBitPos;
                    Vector<Integer> chars = new Vector<Integer>();
                    for (int i = 0; i < len; ++i) {
                        newBitPos = (Integer)DwgUtil.getRawChar(data, bitPos).get(0);
                        int charr = (Integer)DwgUtil.getRawChar(data, bitPos).get(1);
                        bitPos = newBitPos;
                        chars.add(new Integer(charr));
                    }
                    eedata.add(chars);
                    size = size - len - 3;
                    continue;
                }
                if (cb == 1) {
                    System.out.println("Invalid EXX code byte: 0x1");
                    continue;
                }
                if (cb == 2) {
                    newBitPos = (Integer)DwgUtil.getRawChar(data, bitPos).get(0);
                    int charr = (Integer)DwgUtil.getRawChar(data, bitPos).get(1);
                    bitPos = newBitPos;
                    if (charr == 0) {
                        eedata.add("{");
                    } else if (charr == 1) {
                        eedata.add("}");
                    } else {
                        System.out.println("Unexpected EXX char: " + charr);
                    }
                    --size;
                    continue;
                }
                if (cb == 3 || cb == 5) {
                    Vector<Integer> chars = new Vector<Integer>();
                    for (int i = 0; i < 8; ++i) {
                        newBitPos = (Integer)DwgUtil.getRawChar(data, bitPos).get(0);
                        int charr = (Integer)DwgUtil.getRawChar(data, bitPos).get(1);
                        bitPos = newBitPos;
                        chars.add(new Integer(charr));
                    }
                    eedata.add(chars);
                    size -= 8;
                    continue;
                }
                if (cb == 4) {
                    newBitPos = (Integer)DwgUtil.getRawChar(data, bitPos).get(0);
                    int len = (Integer)DwgUtil.getRawChar(data, bitPos).get(1);
                    bitPos = newBitPos;
                    Vector<Integer> chars = new Vector<Integer>();
                    for (int i = 0; i < len; ++i) {
                        newBitPos = (Integer)DwgUtil.getRawChar(data, bitPos).get(0);
                        int charr = (Integer)DwgUtil.getRawChar(data, bitPos).get(1);
                        bitPos = newBitPos;
                        chars.add(new Integer(charr));
                    }
                    eedata.add(chars);
                    size = size - len - 1;
                    continue;
                }
                if (10 <= cb && cb <= 13) {
                    newBitPos = (Integer)DwgUtil.getRawDouble(data, bitPos).get(0);
                    double d1 = (Double)DwgUtil.getRawDouble(data, bitPos).get(1);
                    bitPos = newBitPos;
                    newBitPos = (Integer)DwgUtil.getRawDouble(data, bitPos).get(0);
                    double d2 = (Double)DwgUtil.getRawDouble(data, bitPos).get(1);
                    bitPos = newBitPos;
                    newBitPos = (Integer)DwgUtil.getRawDouble(data, bitPos).get(0);
                    double d3 = (Double)DwgUtil.getRawDouble(data, bitPos).get(1);
                    bitPos = newBitPos;
                    eedata.add(new double[]{d1, d2, d3});
                    size -= 24;
                    continue;
                }
                if (40 <= cb && cb <= 42) {
                    newBitPos = (Integer)DwgUtil.getRawDouble(data, bitPos).get(0);
                    double d = (Double)DwgUtil.getRawDouble(data, bitPos).get(1);
                    bitPos = newBitPos;
                    eedata.add(new Double(d));
                    size -= 8;
                    continue;
                }
                if (cb == 70) {
                    newBitPos = (Integer)DwgUtil.getRawShort(data, bitPos).get(0);
                    int shortt = (Integer)DwgUtil.getRawShort(data, bitPos).get(1);
                    bitPos = newBitPos;
                    eedata.add(new Integer(shortt));
                    size -= 2;
                    continue;
                }
                if (cb == 71) {
                    newBitPos = (Integer)DwgUtil.getRawLong(data, bitPos).get(0);
                    int longg = (Integer)DwgUtil.getRawLong(data, bitPos).get(1);
                    bitPos = newBitPos;
                    eedata.add(new Integer(longg));
                    size -= 4;
                    continue;
                }
                System.out.println("Unexpected code byte: " + cb);
            }
            Vector v = new Vector();
            extData.add(v);
        }
        Vector<Serializable> v = new Vector<Serializable>();
        v.add(new Integer(bitPos));
        v.add(extData);
        return v;
    }

    public static Vector getDefaultDouble(int[] data, int offset, double defVal) throws Exception {
        double val;
        int flags = (Integer)DwgUtil.getBits(data, 2, offset);
        int read = 2;
        if (flags == 0) {
            val = defVal;
        } else {
            int _offset = offset + 2;
            if (flags == 3) {
                byte[] bytes = (byte[])DwgUtil.getBits(data, 64, _offset);
                ByteBuffer bb = ByteBuffer.wrap(bytes);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                val = bb.getDouble();
                read = 66;
            } else {
                byte[] ddArray;
                byte[] dstrArrayAux = new byte[8];
                int[] doubleOffset = new int[]{0};
                ByteUtils.doubleToBytes(defVal, dstrArrayAux, doubleOffset);
                byte[] dstrArrayAuxx = new byte[]{dstrArrayAux[7], dstrArrayAux[6], dstrArrayAux[5], dstrArrayAux[4], dstrArrayAux[3], dstrArrayAux[2], dstrArrayAux[1], dstrArrayAux[0]};
                int[] dstrArrayAuxxx = new int[8];
                for (int i = 0; i < dstrArrayAuxxx.length; ++i) {
                    dstrArrayAuxxx[i] = ByteUtils.getUnsigned(dstrArrayAuxx[i]);
                }
                byte[] dstrArray = new byte[8];
                for (int i = 0; i < dstrArray.length; ++i) {
                    dstrArray[i] = (byte)dstrArrayAuxxx[i];
                }
                if (flags == 1) {
                    ddArray = (byte[])DwgUtil.getBits(data, 32, _offset);
                    dstrArray[0] = ddArray[0];
                    dstrArray[1] = ddArray[1];
                    dstrArray[2] = ddArray[2];
                    dstrArray[3] = ddArray[3];
                    read = 34;
                } else {
                    ddArray = (byte[])DwgUtil.getBits(data, 48, _offset);
                    dstrArray[4] = ddArray[0];
                    dstrArray[5] = ddArray[1];
                    dstrArray[0] = ddArray[2];
                    dstrArray[1] = ddArray[3];
                    dstrArray[2] = ddArray[4];
                    dstrArray[3] = ddArray[5];
                    read = 50;
                }
                ByteBuffer bb = ByteBuffer.wrap(dstrArray);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                val = bb.getDouble();
            }
        }
        Vector<Number> v = new Vector<Number>();
        v.add(new Integer(offset + read));
        v.add(new Double(val));
        return v;
    }

    public static Vector getBitDouble(int[] data, int offset) throws Exception {
        Vector<Number> v = new Vector<Number>();
        int type = (Integer)DwgUtil.getBits(data, 2, offset);
        int read = 2;
        double val = 0.0;
        if (type == 0) {
            byte[] bytes = (byte[])DwgUtil.getBits(data, 64, offset + 2);
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            val = bb.getDouble();
            read = 66;
        } else if (type == 1) {
            val = 1.0;
        } else if (type == 2) {
            val = 0.0;
        } else {
            System.out.println("Bad type at bit offset: " + offset);
        }
        v.add(new Integer(offset + read));
        v.add(new Double(val));
        return v;
    }

    public static Vector getRawDouble(int[] data, int offset) throws Exception {
        byte[] bytes = (byte[])DwgUtil.getBits(data, 64, offset);
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        double val = bb.getDouble();
        Vector<Number> v = new Vector<Number>();
        v.add(new Integer(offset + 64));
        v.add(new Double(val));
        return v;
    }

    public static Vector getBitShort(int[] data, int offset) throws Exception {
        Vector<Integer> v = new Vector<Integer>();
        int type = (Integer)DwgUtil.getBits(data, 2, offset);
        int read = 2;
        int val = 0;
        if (type == 0) {
            byte[] bytes = (byte[])DwgUtil.getBits(data, 16, offset + 2);
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            val = bb.getShort();
            read = 18;
        } else if (type == 1) {
            val = (Integer)DwgUtil.getBits(data, 8, offset + 2);
            read = 10;
        } else if (type == 2) {
            val = 0;
        } else if (type == 3) {
            val = 256;
        }
        v.add(new Integer(offset + read));
        v.add(new Integer(val));
        return v;
    }

    public static Vector getRawShort(int[] data, int offset) throws Exception {
        byte[] bytes = (byte[])DwgUtil.getBits(data, 16, offset);
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        short val = bb.getShort();
        Vector<Integer> v = new Vector<Integer>();
        v.add(new Integer(offset + 16));
        v.add(new Integer(val));
        return v;
    }

    public static Vector getBitLong(int[] data, int offset) throws Exception {
        int type = (Integer)DwgUtil.getBits(data, 2, offset);
        int read = 2;
        int val = 0;
        if (type == 0) {
            byte[] bytes = (byte[])DwgUtil.getBits(data, 32, offset + 2);
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            val = bb.getInt();
            read = 34;
        } else if (type == 1) {
            val = (Integer)DwgUtil.getBits(data, 8, offset + 2);
            read = 10;
        } else if (type == 2) {
            val = 0;
        } else {
            System.out.println("Bad type at bit offset: " + offset);
        }
        Vector<Integer> v = new Vector<Integer>();
        v.add(new Integer(offset + read));
        v.add(new Integer(val));
        return v;
    }

    public static Vector getRawLong(int[] data, int offset) {
        Vector<Integer> v = new Vector<Integer>();
        int val = 0;
        v.add(new Integer(offset + 32));
        v.add(new Integer(val));
        return v;
    }

    public static Vector getRawChar(int[] data, int offset) throws Exception {
        int charr = (Integer)DwgUtil.getBits(data, 8, offset);
        Vector<Integer> v = new Vector<Integer>();
        v.add(new Integer(offset + 8));
        v.add(new Integer(charr));
        return v;
    }

    public static Vector getModularChar(int[] data, int offset) throws Exception {
        int val = 0;
        Vector<Integer> bytes = new Vector<Integer>();
        boolean read = true;
        int offsett = offset;
        int fac = 1;
        while (read) {
            int bytee = (Integer)DwgUtil.getBits(data, 8, offsett);
            offsett += 8;
            if ((bytee & 0x80) == 0) {
                read = false;
                if ((bytee & 0x40) > 0) {
                    fac = -1;
                    bytee &= 0xBF;
                }
            }
            bytes.add(new Integer(bytee & 0x7F));
        }
        if (bytes.size() == 1) {
            val = (Integer)bytes.get(0);
        } else if (bytes.size() == 2) {
            val = (Integer)bytes.get(0) | (Integer)bytes.get(1) << 7;
        } else if (bytes.size() == 3) {
            val = (Integer)bytes.get(0) | (Integer)bytes.get(1) << 7 | (Integer)bytes.get(2) << 14;
        } else if (bytes.size() == 4) {
            val = (Integer)bytes.get(0) | (Integer)bytes.get(1) << 7 | (Integer)bytes.get(2) << 14 | (Integer)bytes.get(3) << 21;
        } else {
            System.out.println("Unexpected byte array length: " + bytes.size());
        }
        Vector<Integer> v = new Vector<Integer>();
        v.add(new Integer(offsett));
        v.add(new Integer(fac * val));
        return v;
    }

    public static Vector getTextString(int[] data, int offset) throws Exception {
        String string;
        int bitPos = offset;
        int newBitPos = (Integer)DwgUtil.getBitShort(data, bitPos).get(0);
        int len = (Integer)DwgUtil.getBitShort(data, bitPos).get(1);
        int bitLen = len * 8;
        Object cosa = DwgUtil.getBits(data, bitLen, bitPos = newBitPos);
        if (cosa instanceof byte[]) {
            string = new String((byte[])cosa);
        } else {
            byte[] bytes = new byte[]{((Integer)cosa).byteValue()};
            string = new String(bytes);
        }
        Vector<Object> v = new Vector<Object>();
        v.add(new Integer(bitPos += bitLen));
        v.add(string);
        return v;
    }

    public static Vector getHandle(int[] data, int offset) throws Exception {
        Vector<Integer> v = new Vector<Integer>();
        int code = (Integer)DwgUtil.getBits(data, 4, offset);
        int counter = (Integer)DwgUtil.getBits(data, 4, offset + 4);
        int read = 8;
        Vector<Object> hlist = new Vector<Object>();
        if (counter > 0) {
            int hlen = counter * 8;
            Object handle = DwgUtil.getBits(data, hlen, offset + 8);
            read += hlen;
            if (hlen > 8) {
                int i;
                byte[] handleBytes = (byte[])handle;
                int[] handleInts = new int[handleBytes.length];
                for (i = 0; i < handleBytes.length; ++i) {
                    handleInts[i] = ByteUtils.getUnsigned(handleBytes[i]);
                }
                for (i = 0; i < handleInts.length; ++i) {
                    hlist.add(new Integer(handleInts[i]));
                }
            } else {
                hlist.add(handle);
            }
        }
        v.add(new Integer(offset + read));
        v.add(new Integer(code));
        v.add(new Integer(counter));
        for (int i = 0; i < hlist.size(); ++i) {
            v.add((Integer)hlist.get(i));
        }
        return v;
    }

    public static int getModularShort(ByteBuffer bb) {
        Vector<Number> shorts = new Vector<Number>();
        bb.order(ByteOrder.BIG_ENDIAN);
        short shortt = bb.getShort();
        int size = 0;
        while ((shortt & 0x80) > 0) {
            shorts.add(new Short(shortt));
            shortt = bb.getShort();
        }
        shorts.add(new Short(shortt));
        for (int i = 0; i < shorts.size(); ++i) {
            shortt = (Short)shorts.get(i);
            shorts.set(i, new Integer((shortt & 0xFF00) >> 8 | (shortt & 0xFF) << 8));
        }
        int slen = shorts.size();
        if (slen == 1) {
            size = (Integer)shorts.get(0) & Short.MAX_VALUE;
        } else if (slen == 2) {
            int tmp = (Integer)shorts.get(0);
            shorts.set(0, (Number)shorts.get(1));
            shorts.set(1, new Integer(tmp));
            size = ((Integer)shorts.get(0) & Short.MAX_VALUE) << 15 | (Integer)shorts.get(1) & Short.MAX_VALUE;
        } else {
            System.out.println("Unexpected array length: " + slen);
        }
        return size;
    }

    public static Object getBits(int[] data, int count, int offset) throws Exception {
        int idx = offset / 8;
        int bitidx = offset % 8;
        int[][] maskTable = new int[][]{{255, 0, 0, 0}, {127, 1, 128, 7}, {63, 2, 192, 6}, {31, 3, 224, 5}, {15, 4, 240, 4}, {7, 5, 248, 3}, {3, 6, 252, 2}, {1, 7, 254, 1}};
        int mask1 = maskTable[bitidx][0];
        int lsh = maskTable[bitidx][1];
        int mask2 = maskTable[bitidx][2];
        int rsh = maskTable[bitidx][3];
        int binc = 8 - bitidx;
        int read = 0;
        int rem = count;
        int bytee = 0;
        Vector<Integer> bytes = new Vector<Integer>();
        while (read < count) {
            int b1 = 0;
            if (rem > binc) {
                b1 = data[idx] & mask1;
                read += binc;
                rem -= binc;
            } else {
                bytee = b1 = (data[idx] & mask1) >> 8 - bitidx - rem;
                read += rem;
                rem = 0;
            }
            if (read < count) {
                ++idx;
                if (rem > bitidx) {
                    int b2 = data[idx] & mask2;
                    bytee = b1 << lsh | b2 >> rsh;
                    read += bitidx;
                    rem -= bitidx;
                } else {
                    int mask = maskTable[rem][2];
                    int b2 = data[idx] & mask;
                    bytee = b1 << rem | b2 >> 8 - rem;
                    read += rem;
                    rem = 0;
                }
            }
            if (count <= 8) continue;
            bytes.add(new Integer(bytee));
        }
        if (bytes.size() > 0) {
            byte[] newBytes = new byte[bytes.size()];
            for (int i = 0; i < newBytes.length; ++i) {
                newBytes[i] = ((Integer)bytes.get(i)).byteValue();
            }
            return newBytes;
        }
        return new Integer(bytee);
    }

    public static Vector testBit(int[] data, int offset) {
        int idx = offset / 8;
        int bitidx = offset % 8;
        int mask = 1 << 7 - bitidx;
        boolean val = false;
        if ((data[idx] & mask) > 0) {
            val = true;
        }
        Vector<Constable> v = new Vector<Constable>();
        v.add(new Integer(offset + 1));
        v.add(new Boolean(val));
        return v;
    }

    public static int[] bytesToMachineBytes(byte[] data) {
        String[] dataString = new String[data.length];
        int[] dataOut = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            dataString[i] = HexUtil.bytesToHex(new byte[]{data[i]});
            Integer dataInt = Integer.decode("0x" + dataString[i]);
            dataOut[i] = dataInt;
        }
        return dataOut;
    }

    public static int handleBinToHandleInt(Vector layerHandle) {
        byte[] layerBytes = new byte[]{0, 0, 0, 0};
        if (layerHandle.size() > 2) {
            layerBytes[3] = (byte)((Integer)layerHandle.get(2)).intValue();
        }
        if (layerHandle.size() > 3) {
            layerBytes[3] = (byte)((Integer)layerHandle.get(3)).intValue();
            layerBytes[2] = (byte)((Integer)layerHandle.get(2)).intValue();
        }
        if (layerHandle.size() > 4) {
            layerBytes[3] = (byte)((Integer)layerHandle.get(4)).intValue();
            layerBytes[2] = (byte)((Integer)layerHandle.get(3)).intValue();
            layerBytes[1] = (byte)((Integer)layerHandle.get(2)).intValue();
        }
        if (layerHandle.size() > 5) {
            layerBytes[3] = (byte)((Integer)layerHandle.get(5)).intValue();
            layerBytes[2] = (byte)((Integer)layerHandle.get(4)).intValue();
            layerBytes[1] = (byte)((Integer)layerHandle.get(3)).intValue();
            layerBytes[0] = (byte)((Integer)layerHandle.get(2)).intValue();
        }
        int layer = ByteUtils.bytesToInt(layerBytes, new int[]{0});
        return layer;
    }
}

