/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects;

import java.util.Vector;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgObject;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgUtil;

public class DwgInsert
extends DwgObject {
    private double[] insertionPoint;
    private double[] scale;
    private double rotation;
    private double[] extrusion;
    private int blockHeaderHandle;
    private int firstAttribHandle;
    private int lastAttribHandle;
    private int seqendHandle;

    public void readDwgInsertV15(int[] data, int offset) throws Exception {
        int i;
        double rot;
        int bitPos = offset;
        bitPos = this.readObjectHeaderV15(data, bitPos);
        Vector v = DwgUtil.getBitDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        double x = (Double)v.get(1);
        v = DwgUtil.getBitDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        double y = (Double)v.get(1);
        v = DwgUtil.getBitDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        double z = (Double)v.get(1);
        double[] coord = new double[]{x, y, z};
        this.insertionPoint = coord;
        int dflag = (Integer)DwgUtil.getBits(data, 2, bitPos);
        bitPos += 2;
        if (dflag == 0) {
            v = DwgUtil.getRawDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            x = (Double)v.get(1);
            v = DwgUtil.getDefaultDouble(data, bitPos, x);
            bitPos = (Integer)v.get(0);
            y = (Double)v.get(1);
            v = DwgUtil.getDefaultDouble(data, bitPos, x);
            bitPos = (Integer)v.get(0);
            z = (Double)v.get(1);
        } else if (dflag == 1) {
            x = 1.0;
            v = DwgUtil.getDefaultDouble(data, bitPos, x);
            bitPos = (Integer)v.get(0);
            y = (Double)v.get(1);
            v = DwgUtil.getDefaultDouble(data, bitPos, x);
            bitPos = (Integer)v.get(0);
            z = (Double)v.get(1);
        } else if (dflag == 2) {
            v = DwgUtil.getRawDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            y = z = (x = ((Double)v.get(1)).doubleValue());
        } else {
            x = y = (z = 1.0);
        }
        coord = new double[]{x, y, z};
        this.scale = coord;
        v = DwgUtil.getBitDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        this.rotation = rot = ((Double)v.get(1)).doubleValue();
        v = DwgUtil.getBitDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        x = (Double)v.get(1);
        v = DwgUtil.getBitDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        y = (Double)v.get(1);
        v = DwgUtil.getBitDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        z = (Double)v.get(1);
        coord = new double[]{x, y, z};
        this.extrusion = coord;
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        boolean hasattr = (Boolean)v.get(1);
        bitPos = this.readObjectTailV15(data, bitPos);
        v = DwgUtil.getHandle(data, bitPos);
        bitPos = (Integer)v.get(0);
        int[] handle = new int[v.size() - 1];
        for (int i2 = 1; i2 < v.size(); ++i2) {
            handle[i2 - 1] = (Integer)v.get(i2);
        }
        Vector<Integer> handleVect = new Vector<Integer>();
        for (i = 0; i < handle.length; ++i) {
            handleVect.add(new Integer(handle[i]));
        }
        this.blockHeaderHandle = DwgUtil.handleBinToHandleInt(handleVect);
        if (hasattr) {
            v = DwgUtil.getHandle(data, bitPos);
            bitPos = (Integer)v.get(0);
            handle = new int[v.size() - 1];
            for (i = 1; i < v.size(); ++i) {
                handle[i - 1] = (Integer)v.get(i);
            }
            handleVect = new Vector();
            for (i = 0; i < handle.length; ++i) {
                handleVect.add(new Integer(handle[i]));
            }
            this.firstAttribHandle = DwgUtil.handleBinToHandleInt(handleVect);
            v = DwgUtil.getHandle(data, bitPos);
            bitPos = (Integer)v.get(0);
            handle = new int[v.size() - 1];
            for (i = 1; i < v.size(); ++i) {
                handle[i - 1] = (Integer)v.get(i);
            }
            handleVect = new Vector();
            for (i = 0; i < handle.length; ++i) {
                handleVect.add(new Integer(handle[i]));
            }
            this.lastAttribHandle = DwgUtil.handleBinToHandleInt(handleVect);
            v = DwgUtil.getHandle(data, bitPos);
            bitPos = (Integer)v.get(0);
            handle = new int[v.size() - 1];
            for (i = 1; i < v.size(); ++i) {
                handle[i - 1] = (Integer)v.get(i);
            }
            handleVect = new Vector();
            for (i = 0; i < handle.length; ++i) {
                handleVect.add(new Integer(handle[i]));
            }
            this.seqendHandle = DwgUtil.handleBinToHandleInt(handleVect);
        }
    }

    public int getBlockHeaderHandle() {
        return this.blockHeaderHandle;
    }

    public void setBlockHeaderHandle(int blockHeaderHandle) {
        this.blockHeaderHandle = blockHeaderHandle;
    }

    public int getFirstAttribHandle() {
        return this.firstAttribHandle;
    }

    public void setFirstAttribHandle(int firstAttribHandle) {
        this.firstAttribHandle = firstAttribHandle;
    }

    public double[] getInsertionPoint() {
        return this.insertionPoint;
    }

    public void setInsertionPoint(double[] insertionPoint) {
        this.insertionPoint = insertionPoint;
    }

    public int getLastAttribHandle() {
        return this.lastAttribHandle;
    }

    public void setLastAttribHandle(int lastAttribHandle) {
        this.lastAttribHandle = lastAttribHandle;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public double[] getScale() {
        return this.scale;
    }

    public void setScale(double[] scale) {
        this.scale = scale;
    }

    public double[] getExtrusion() {
        return this.extrusion;
    }

    public void setExtrusion(double[] extrusion) {
        this.extrusion = extrusion;
    }

    public int getSeqendHandle() {
        return this.seqendHandle;
    }

    public void setSeqendHandle(int seqendHandle) {
        this.seqendHandle = seqendHandle;
    }

    public Object clone() {
        DwgInsert dwgInsert = new DwgInsert();
        dwgInsert.setType(this.type);
        dwgInsert.setHandle(this.handle);
        dwgInsert.setVersion(this.version);
        dwgInsert.setMode(this.mode);
        dwgInsert.setLayerHandle(this.layerHandle);
        dwgInsert.setColor(this.color);
        dwgInsert.setNumReactors(this.numReactors);
        dwgInsert.setNoLinks(this.noLinks);
        dwgInsert.setLinetypeFlags(this.linetypeFlags);
        dwgInsert.setPlotstyleFlags(this.plotstyleFlags);
        dwgInsert.setSizeInBits(this.sizeInBits);
        dwgInsert.setExtendedData(this.extendedData);
        dwgInsert.setGraphicData(this.graphicData);
        dwgInsert.setInsertionPoint(this.insertionPoint);
        dwgInsert.setScale(this.scale);
        dwgInsert.setRotation(this.rotation);
        dwgInsert.setExtrusion(this.extrusion);
        dwgInsert.setBlockHeaderHandle(this.blockHeaderHandle);
        dwgInsert.setFirstAttribHandle(this.firstAttribHandle);
        dwgInsert.setLastAttribHandle(this.lastAttribHandle);
        dwgInsert.setSeqendHandle(this.seqendHandle);
        return dwgInsert;
    }
}

