/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects;

import java.awt.geom.Point2D;
import java.util.Vector;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgObject;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgUtil;

public class DwgLwPolyline
extends DwgObject {
    private int flag;
    private double constWidth;
    private double elevation;
    private double thickness;
    private double[] normal;
    private Point2D[] vertices;
    private double[] bulges;
    private double[][] widths;

    public void readDwgLwPolylineV15(int[] data, int offset) throws Exception {
        int flag;
        int bitPos = offset;
        bitPos = this.readObjectHeaderV15(data, bitPos);
        Vector v = DwgUtil.getBitShort(data, bitPos);
        bitPos = (Integer)v.get(0);
        this.flag = flag = ((Integer)v.get(1)).intValue();
        if (flag >= 0) {
            double constWidth = 0.0;
            if ((flag & 4) > 0) {
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                constWidth = (Double)v.get(1);
            }
            this.constWidth = constWidth;
            double elev = 0.0;
            if ((flag & 8) > 0) {
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                elev = (Double)v.get(1);
            }
            this.elevation = elev;
            double thickness = 0.0;
            if ((flag & 2) > 0) {
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                thickness = (Double)v.get(1);
            }
            this.thickness = thickness;
            double nx = 0.0;
            double ny = 0.0;
            double nz = 0.0;
            if ((flag & 1) > 0) {
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                nx = (Double)v.get(1);
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                ny = (Double)v.get(1);
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                nz = (Double)v.get(1);
            }
            this.normal = new double[]{nx, ny, nz};
            v = DwgUtil.getBitLong(data, bitPos);
            bitPos = (Integer)v.get(0);
            int np = (Integer)v.get(1);
            if (np > 0 && np < 10000) {
                long nb = 0L;
                if ((flag & 0x10) > 0) {
                    v = DwgUtil.getBitLong(data, bitPos);
                    bitPos = (Integer)v.get(0);
                    nb = ((Integer)v.get(1)).intValue();
                }
                long nw = 0L;
                if ((flag & 0x20) > 0) {
                    v = DwgUtil.getBitLong(data, bitPos);
                    bitPos = (Integer)v.get(0);
                    nw = ((Integer)v.get(1)).intValue();
                }
                Point2D[] vertices = new Point2D[np];
                v = DwgUtil.getRawDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                double vx = (Double)v.get(1);
                v = DwgUtil.getRawDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                double vy = (Double)v.get(1);
                vertices[0] = new Point2D.Double(vx, vy);
                for (int i = 1; i < np; ++i) {
                    v = DwgUtil.getDefaultDouble(data, bitPos, vx);
                    bitPos = (Integer)v.get(0);
                    double x = (Double)v.get(1);
                    v = DwgUtil.getDefaultDouble(data, bitPos, vy);
                    bitPos = (Integer)v.get(0);
                    double y = (Double)v.get(1);
                    vertices[i] = new Point2D.Double(x, y);
                    vx = x;
                    vy = y;
                }
                this.vertices = vertices;
                double[] bulges = new double[]{};
                if (nb > 0L) {
                    bulges = new double[(int)nb];
                    int i = 0;
                    while ((long)i < nb) {
                        double bulge;
                        v = DwgUtil.getRawDouble(data, bitPos);
                        bitPos = (Integer)v.get(0);
                        bulges[i] = bulge = ((Double)v.get(1)).doubleValue();
                        ++i;
                    }
                } else if (nb == 0L) {
                    bulges = new double[np];
                    for (int i = 0; i < np; ++i) {
                        bulges[i] = 0.0;
                    }
                }
                this.bulges = bulges;
                if (nw > 0L) {
                    double[][] widths = new double[(int)nw][2];
                    int i = 0;
                    while ((long)i < nw) {
                        v = DwgUtil.getBitDouble(data, bitPos);
                        bitPos = (Integer)v.get(0);
                        double sw = (Double)v.get(1);
                        v = DwgUtil.getBitDouble(data, bitPos);
                        bitPos = (Integer)v.get(0);
                        double ew = (Double)v.get(1);
                        widths[i][0] = sw;
                        widths[i][1] = ew;
                        ++i;
                    }
                    this.widths = widths;
                }
                bitPos = this.readObjectTailV15(data, bitPos);
            }
        }
    }

    public double[] getBulges() {
        return this.bulges;
    }

    public void setBulges(double[] bulges) {
        this.bulges = bulges;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public Point2D[] getVertices() {
        return this.vertices;
    }

    public void setVertices(Point2D[] vertices) {
        this.vertices = vertices;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public double[] getNormal() {
        return this.normal;
    }

    public Object clone() {
        DwgLwPolyline dwgLwPolyline = new DwgLwPolyline();
        dwgLwPolyline.setType(this.type);
        dwgLwPolyline.setHandle(this.handle);
        dwgLwPolyline.setVersion(this.version);
        dwgLwPolyline.setMode(this.mode);
        dwgLwPolyline.setLayerHandle(this.layerHandle);
        dwgLwPolyline.setColor(this.color);
        dwgLwPolyline.setNumReactors(this.numReactors);
        dwgLwPolyline.setNoLinks(this.noLinks);
        dwgLwPolyline.setLinetypeFlags(this.linetypeFlags);
        dwgLwPolyline.setPlotstyleFlags(this.plotstyleFlags);
        dwgLwPolyline.setSizeInBits(this.sizeInBits);
        dwgLwPolyline.setExtendedData(this.extendedData);
        dwgLwPolyline.setGraphicData(this.graphicData);
        dwgLwPolyline.setFlag(this.flag);
        dwgLwPolyline.setElevation(this.elevation);
        dwgLwPolyline.setConstWidth(this.constWidth);
        dwgLwPolyline.setThickness(this.thickness);
        dwgLwPolyline.setNormal(this.normal);
        dwgLwPolyline.setVertices(this.vertices);
        dwgLwPolyline.setBulges(this.bulges);
        dwgLwPolyline.setWidths(this.widths);
        return dwgLwPolyline;
    }

    public double getConstWidth() {
        return this.constWidth;
    }

    public void setConstWidth(double constWidth) {
        this.constWidth = constWidth;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public double[][] getWidths() {
        return this.widths;
    }

    public void setWidths(double[][] widths) {
        this.widths = widths;
    }

    public void setNormal(double[] normal) {
        this.normal = normal;
    }
}

