/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs.dwg.objects;

import java.awt.geom.Point2D;
import java.util.Vector;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgObject;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.DwgUtil;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.utils.TextToUnicodeConverter;

public class DwgText
extends DwgObject {
    private int dataFlag;
    private double elevation;
    private Point2D insertionPoint;
    private Point2D alignmentPoint;
    private double[] extrusion;
    private double thickness;
    private double obliqueAngle;
    private double rotationAngle;
    private double height;
    private double widthFactor;
    private String text;
    private int generation;
    private int halign;
    private int valign;

    public void readDwgTextV15(int[] data, int offset) throws Exception {
        double height;
        double th;
        double z;
        double y;
        double x;
        int dflag;
        int bitPos = offset;
        bitPos = this.readObjectHeaderV15(data, bitPos);
        Vector v = DwgUtil.getRawChar(data, bitPos);
        bitPos = (Integer)v.get(0);
        this.dataFlag = dflag = ((Integer)v.get(1)).intValue();
        if ((dflag & 1) == 0) {
            double elev;
            v = DwgUtil.getRawDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.elevation = elev = ((Double)v.get(1)).doubleValue();
        }
        v = DwgUtil.getRawDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        double x1 = (Double)v.get(1);
        v = DwgUtil.getRawDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        double y1 = (Double)v.get(1);
        this.insertionPoint = new Point2D.Double(x1, y1);
        if ((dflag & 2) == 0) {
            v = DwgUtil.getDefaultDouble(data, bitPos, x1);
            bitPos = (Integer)v.get(0);
            double xa = (Double)v.get(1);
            v = DwgUtil.getDefaultDouble(data, bitPos, y1);
            bitPos = (Integer)v.get(0);
            double ya = (Double)v.get(1);
            this.alignmentPoint = new Point2D.Double(xa, ya);
        }
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        boolean flag = (Boolean)v.get(1);
        if (flag) {
            x = 0.0;
            y = 0.0;
            z = 1.0;
        } else {
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            x = (Double)v.get(1);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            y = (Double)v.get(1);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            z = (Double)v.get(1);
        }
        double[] coord = new double[]{x, y, z};
        this.extrusion = coord;
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        flag = (Boolean)v.get(1);
        if (flag) {
            th = 0.0;
        } else {
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            th = (Double)v.get(1);
        }
        this.thickness = th;
        if ((dflag & 4) == 0) {
            double oblique;
            v = DwgUtil.getRawDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.obliqueAngle = oblique = ((Double)v.get(1)).doubleValue();
        }
        if ((dflag & 8) == 0) {
            double rot;
            v = DwgUtil.getRawDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.rotationAngle = rot = ((Double)v.get(1)).doubleValue();
        }
        v = DwgUtil.getRawDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        this.height = height = ((Double)v.get(1)).doubleValue();
        if ((dflag & 0x10) == 0) {
            double width;
            v = DwgUtil.getRawDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.widthFactor = width = ((Double)v.get(1)).doubleValue();
        }
        v = DwgUtil.getTextString(data, bitPos);
        bitPos = (Integer)v.get(0);
        String text = (String)v.get(1);
        this.text = text = TextToUnicodeConverter.convertText(text);
        if ((dflag & 0x20) == 0) {
            int gen;
            v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.generation = gen = ((Integer)v.get(1)).intValue();
        }
        if ((dflag & 0x40) == 0) {
            int halign;
            v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.halign = halign = ((Integer)v.get(1)).intValue();
        }
        if ((dflag & 0x80) == 0) {
            int valign;
            v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            this.valign = valign = ((Integer)v.get(1)).intValue();
        }
        bitPos = this.readObjectTailV15(data, bitPos);
    }

    public int getDataFlag() {
        return this.dataFlag;
    }

    public void setDataFlag(int dataFlag) {
        this.dataFlag = dataFlag;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public Point2D getInsertionPoint() {
        return this.insertionPoint;
    }

    public void setInsertionPoint(Point2D insertionPoint) {
        this.insertionPoint = insertionPoint;
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(double rotationAngle) {
        this.rotationAngle = rotationAngle;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public double[] getExtrusion() {
        return this.extrusion;
    }

    public Object clone() {
        DwgText dwgText = new DwgText();
        dwgText.setType(this.type);
        dwgText.setHandle(this.handle);
        dwgText.setVersion(this.version);
        dwgText.setMode(this.mode);
        dwgText.setLayerHandle(this.layerHandle);
        dwgText.setColor(this.color);
        dwgText.setNumReactors(this.numReactors);
        dwgText.setNoLinks(this.noLinks);
        dwgText.setLinetypeFlags(this.linetypeFlags);
        dwgText.setPlotstyleFlags(this.plotstyleFlags);
        dwgText.setSizeInBits(this.sizeInBits);
        dwgText.setExtendedData(this.extendedData);
        dwgText.setGraphicData(this.graphicData);
        dwgText.setDataFlag(this.dataFlag);
        dwgText.setElevation(this.elevation);
        dwgText.setInsertionPoint(this.insertionPoint);
        dwgText.setAlignmentPoint(this.alignmentPoint);
        dwgText.setExtrusion(this.extrusion);
        dwgText.setThickness(this.thickness);
        dwgText.setObliqueAngle(this.obliqueAngle);
        dwgText.setRotationAngle(this.rotationAngle);
        dwgText.setHeight(this.height);
        dwgText.setWidthFactor(this.widthFactor);
        dwgText.setText(this.text);
        dwgText.setGeneration(this.generation);
        dwgText.setHalign(this.halign);
        dwgText.setValign(this.valign);
        return dwgText;
    }

    public Point2D getAlignmentPoint() {
        return this.alignmentPoint;
    }

    public void setAlignmentPoint(Point2D alignmentPoint) {
        this.alignmentPoint = alignmentPoint;
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public int getHalign() {
        return this.halign;
    }

    public void setHalign(int halign) {
        this.halign = halign;
    }

    public double getObliqueAngle() {
        return this.obliqueAngle;
    }

    public void setObliqueAngle(double obliqueAngle) {
        this.obliqueAngle = obliqueAngle;
    }

    public int getValign() {
        return this.valign;
    }

    public void setValign(int valign) {
        this.valign = valign;
    }

    public double getWidthFactor() {
        return this.widthFactor;
    }

    public void setWidthFactor(double widthFactor) {
        this.widthFactor = widthFactor;
    }

    public void setExtrusion(double[] extrusion) {
        this.extrusion = extrusion;
    }
}

