/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs.dwg.utils;

import java.awt.geom.Point2D;
import java.util.Vector;

public class ArcFromBulgeCalculator {
    private Point2D coord1;
    private Point2D coord2;
    private Point2D center;
    private double radio;
    private double empieza;
    private double acaba;
    private double bulge;
    private double d;
    private double dd;
    private double aci;
    private Point2D coordAux;

    public ArcFromBulgeCalculator(Point2D p1, Point2D p2, double bulge) {
        this.bulge = bulge;
        if (bulge < 0.0) {
            this.coord1 = p2;
            this.coord2 = p1;
        } else {
            this.coord1 = p1;
            this.coord2 = p2;
        }
        this.calParams();
    }

    private void calParams() {
        this.d = Math.sqrt((this.coord2.getX() - this.coord1.getX()) * (this.coord2.getX() - this.coord1.getX()) + (this.coord2.getY() - this.coord1.getY()) * (this.coord2.getY() - this.coord1.getY()));
        this.coordAux = new Point2D.Double((this.coord1.getX() + this.coord2.getX()) / 2.0, (this.coord1.getY() + this.coord2.getY()) / 2.0);
        double b = Math.abs(this.bulge);
        double beta = Math.atan(b);
        double alfa = beta * 4.0;
        double landa = alfa / 2.0;
        this.dd = this.d / 2.0 / Math.tan(landa);
        this.radio = this.d / 2.0 / Math.sin(landa);
        this.aci = Math.atan((this.coord2.getX() - this.coord1.getX()) / (this.coord2.getY() - this.coord1.getY()));
        double aciDegree = this.aci * 180.0 / Math.PI;
        if (this.coord2.getY() > this.coord1.getY()) {
            this.aci += Math.PI;
            aciDegree = this.aci * 180.0 / Math.PI;
        }
        this.center = new Point2D.Double(this.coordAux.getX() + this.dd * Math.sin(this.aci + 1.5707963267948966), this.coordAux.getY() + this.dd * Math.cos(this.aci + 1.5707963267948966));
        this.calEA(alfa);
    }

    private void calEA(double alfa) {
        this.empieza = Math.atan2(this.coord1.getY() - this.center.getY(), this.coord1.getX() - this.center.getX());
        this.acaba = this.empieza + alfa;
        this.empieza = this.empieza * 180.0 / Math.PI;
        this.acaba = this.acaba * 180.0 / Math.PI;
    }

    public Vector getPoints(double inc) {
        Vector arc = new Vector();
        int iempieza = (int)this.empieza + 1;
        int iacaba = (int)this.acaba;
        if (this.empieza <= this.acaba) {
            this.addNode(arc, this.empieza);
            for (double angulo = (double)iempieza; angulo <= (double)iacaba; angulo += inc) {
                this.addNode(arc, angulo);
            }
            this.addNode(arc, this.acaba);
        } else {
            double angulo;
            this.addNode(arc, this.empieza);
            for (angulo = (double)iempieza; angulo <= 360.0; angulo += inc) {
                this.addNode(arc, angulo);
            }
            for (angulo = 1.0; angulo <= (double)iacaba; angulo += inc) {
                this.addNode(arc, angulo);
            }
            this.addNode(arc, angulo);
        }
        Point2D aux = (Point2D)arc.get(arc.size() - 1);
        double aux1 = Math.abs(aux.getX() - this.coord2.getX());
        double aux2 = Math.abs(aux.getY() - this.coord2.getY());
        return arc;
    }

    public Vector getCentralPoint() {
        Vector arc = new Vector();
        if (this.empieza <= this.acaba) {
            this.addNode(arc, (this.empieza + this.acaba) / 2.0);
        } else {
            this.addNode(arc, this.empieza);
            double alfa = 360.0 - this.empieza;
            double beta = this.acaba;
            double an = alfa + beta;
            double mid = an / 2.0;
            if (mid <= alfa) {
                this.addNode(arc, this.empieza + mid);
            } else {
                this.addNode(arc, mid - alfa);
            }
        }
        return arc;
    }

    private void addNode(Vector arc, double angulo) {
        double yy = this.center.getY() + this.radio * Math.sin(angulo * Math.PI / 180.0);
        double xx = this.center.getX() + this.radio * Math.cos(angulo * Math.PI / 180.0);
        arc.add(new Point2D.Double(xx, yy));
    }
}

