/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs.dwg.utils;

import java.awt.geom.Point2D;
import java.util.Vector;
import org.hortonmachine.gears.io.dxfdwg.libs.dwg.utils.ArcFromBulgeCalculator;

public class GisModelCurveCalculator {
    public static Point2D[] calculateGisModelCircle(Point2D c, double r) {
        Point2D[] pts = new Point2D[360];
        int angulo = 0;
        for (angulo = 0; angulo < 360; ++angulo) {
            pts[angulo] = new Point2D.Double(c.getX(), c.getY());
            pts[angulo].setLocation(pts[angulo].getX() + r * Math.sin((double)angulo * Math.PI / 180.0), pts[angulo].getY() + r * Math.cos((double)angulo * Math.PI / 180.0));
        }
        return pts;
    }

    public static Point2D[] calculateGisModelEllipse(Point2D center, Point2D majorAxisVector, double axisRatio, double initAngle, double endAngle) {
        Point2D[] pts;
        Point2D.Double majorPoint = new Point2D.Double(center.getX() + majorAxisVector.getX(), center.getY() + majorAxisVector.getY());
        double orientation = Math.atan(majorAxisVector.getY() / majorAxisVector.getX());
        double semiMajorAxisLength = center.distance(majorPoint);
        double semiMinorAxisLength = semiMajorAxisLength * axisRatio;
        double eccentricity = Math.sqrt(1.0 - Math.pow(semiMinorAxisLength, 2.0) / Math.pow(semiMajorAxisLength, 2.0));
        int isa = (int)initAngle;
        int iea = (int)endAngle;
        if (initAngle <= endAngle) {
            pts = new Point2D[iea - isa + 2];
            double angulo = initAngle;
            double r = semiMinorAxisLength / Math.sqrt(1.0 - Math.pow(eccentricity, 2.0) * Math.pow(Math.cos(angulo * Math.PI / 180.0), 2.0));
            double x = r * Math.cos(angulo * Math.PI / 180.0);
            double y = r * Math.sin(angulo * Math.PI / 180.0);
            double xrot = x * Math.cos(orientation) - y * Math.sin(orientation);
            double yrot = x * Math.sin(orientation) + y * Math.cos(orientation);
            pts[0] = new Point2D.Double(center.getX() + xrot, center.getY() + yrot);
            for (int i = 1; i <= iea - isa + 1; ++i) {
                angulo = isa + i;
                r = semiMinorAxisLength / Math.sqrt(1.0 - Math.pow(eccentricity, 2.0) * Math.pow(Math.cos(angulo * Math.PI / 180.0), 2.0));
                x = r * Math.cos(angulo * Math.PI / 180.0);
                y = r * Math.sin(angulo * Math.PI / 180.0);
                xrot = x * Math.cos(orientation) - y * Math.sin(orientation);
                yrot = x * Math.sin(orientation) + y * Math.cos(orientation);
                pts[i] = new Point2D.Double(center.getX() + xrot, center.getY() + yrot);
            }
            angulo = endAngle;
            r = semiMinorAxisLength / Math.sqrt(1.0 - Math.pow(eccentricity, 2.0) * Math.pow(Math.cos(angulo * Math.PI / 180.0), 2.0));
            x = r * Math.cos(angulo * Math.PI / 180.0);
            y = r * Math.sin(angulo * Math.PI / 180.0);
            xrot = x * Math.cos(orientation) - y * Math.sin(orientation);
            yrot = x * Math.sin(orientation) + y * Math.cos(orientation);
            pts[iea - isa + 1] = new Point2D.Double(center.getX() + xrot, center.getY() + yrot);
        } else {
            int i;
            pts = new Point2D[360 - isa + iea + 2];
            double angulo = initAngle;
            double r = semiMinorAxisLength / Math.sqrt(1.0 - Math.pow(eccentricity, 2.0) * Math.pow(Math.cos(angulo * Math.PI / 180.0), 2.0));
            double x = r * Math.cos(angulo * Math.PI / 180.0);
            double y = r * Math.sin(angulo * Math.PI / 180.0);
            double xrot = x * Math.cos(orientation) - y * Math.sin(orientation);
            double yrot = x * Math.sin(orientation) + y * Math.cos(orientation);
            pts[0] = new Point2D.Double(center.getX() + r * Math.cos(angulo * Math.PI / 180.0), center.getY() + r * Math.sin(angulo * Math.PI / 180.0));
            for (i = 1; i <= 360 - isa; ++i) {
                angulo = isa + i;
                r = semiMinorAxisLength / Math.sqrt(1.0 - Math.pow(eccentricity, 2.0) * Math.pow(Math.cos(angulo * Math.PI / 180.0), 2.0));
                x = r * Math.cos(angulo * Math.PI / 180.0);
                y = r * Math.sin(angulo * Math.PI / 180.0);
                xrot = x * Math.cos(orientation) - y * Math.sin(orientation);
                yrot = x * Math.sin(orientation) + y * Math.cos(orientation);
                pts[i] = new Point2D.Double(center.getX() + xrot, center.getY() + yrot);
            }
            for (i = 360 - isa + 1; i <= 360 - isa + iea; ++i) {
                angulo = i - (360 - isa);
                r = semiMinorAxisLength / Math.sqrt(1.0 - Math.pow(eccentricity, 2.0) * Math.pow(Math.cos(angulo * Math.PI / 180.0), 2.0));
                x = r * Math.cos(angulo * Math.PI / 180.0);
                y = r * Math.sin(angulo * Math.PI / 180.0);
                xrot = x * Math.cos(orientation) - y * Math.sin(orientation);
                yrot = x * Math.sin(orientation) + y * Math.cos(orientation);
                pts[i] = new Point2D.Double(center.getX() + xrot, center.getY() + yrot);
            }
            angulo = endAngle;
            r = semiMinorAxisLength / Math.sqrt(1.0 - Math.pow(eccentricity, 2.0) * Math.pow(Math.cos(angulo * Math.PI / 180.0), 2.0));
            x = r * Math.cos(angulo * Math.PI / 180.0);
            y = r * Math.sin(angulo * Math.PI / 180.0);
            xrot = x * Math.cos(orientation) - y * Math.sin(orientation);
            yrot = x * Math.sin(orientation) + y * Math.cos(orientation);
            pts[360 - isa + iea + 1] = new Point2D.Double(center.getX() + xrot, center.getY() + yrot);
        }
        return pts;
    }

    public static Point2D[] calculateGisModelArc(Point2D c, double r, double sa, double ea) {
        Point2D[] pts;
        int isa = (int)sa;
        int iea = (int)ea;
        if (sa <= ea) {
            pts = new Point2D[iea - isa + 2];
            double angulo = sa;
            pts[0] = new Point2D.Double(c.getX() + r * Math.cos(angulo * Math.PI / 180.0), c.getY() + r * Math.sin(angulo * Math.PI / 180.0));
            for (int i = 1; i <= iea - isa + 1; ++i) {
                angulo = isa + i;
                pts[i] = new Point2D.Double(c.getX() + r * Math.cos(angulo * Math.PI / 180.0), c.getY() + r * Math.sin(angulo * Math.PI / 180.0));
            }
            angulo = ea;
            pts[iea - isa + 1] = new Point2D.Double(c.getX() + r * Math.cos(angulo * Math.PI / 180.0), c.getY() + r * Math.sin(angulo * Math.PI / 180.0));
        } else {
            int i;
            pts = new Point2D[360 - isa + iea + 2];
            double angulo = sa;
            pts[0] = new Point2D.Double(c.getX() + r * Math.cos(angulo * Math.PI / 180.0), c.getY() + r * Math.sin(angulo * Math.PI / 180.0));
            for (i = 1; i <= 360 - isa; ++i) {
                angulo = isa + i;
                pts[i] = new Point2D.Double(c.getX() + r * Math.cos(angulo * Math.PI / 180.0), c.getY() + r * Math.sin(angulo * Math.PI / 180.0));
            }
            for (i = 360 - isa + 1; i <= 360 - isa + iea; ++i) {
                angulo = i - (360 - isa);
                pts[i] = new Point2D.Double(c.getX() + r * Math.cos(angulo * Math.PI / 180.0), c.getY() + r * Math.sin(angulo * Math.PI / 180.0));
            }
            angulo = ea;
            pts[360 - isa + iea + 1] = new Point2D.Double(c.getX() + r * Math.cos(angulo * Math.PI / 180.0), c.getY() + r * Math.sin(angulo * Math.PI / 180.0));
        }
        return pts;
    }

    public static Point2D[] calculateGisModelBulge(Point2D[] newPts, double[] bulges) {
        Vector<Point2D> ptspol = new Vector<Point2D>();
        Point2D init = new Point2D.Double();
        Point2D end = new Point2D.Double();
        for (int j = 0; j < newPts.length; ++j) {
            int k;
            init = newPts[j];
            if (j != newPts.length - 1) {
                end = newPts[j + 1];
            }
            if (bulges[j] == 0.0 || j == newPts.length - 1 || init.getX() == end.getX() && init.getY() == end.getY()) {
                ptspol.add(init);
                continue;
            }
            ArcFromBulgeCalculator arcCalculator = new ArcFromBulgeCalculator(init, end, bulges[j]);
            Vector arc = arcCalculator.getPoints(1.0);
            if (bulges[j] < 0.0) {
                for (k = arc.size() - 1; k >= 0; --k) {
                    ptspol.add((Point2D)arc.get(k));
                }
                ptspol.remove(ptspol.size() - 1);
                continue;
            }
            for (k = 0; k < arc.size(); ++k) {
                ptspol.add((Point2D)arc.get(k));
            }
            ptspol.remove(ptspol.size() - 1);
        }
        Point2D[] points = new Point2D[ptspol.size()];
        for (int j = 0; j < ptspol.size(); ++j) {
            points[j] = (Point2D)ptspol.get(j);
        }
        return points;
    }
}

