/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs.dxf;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.geotools.feature.DefaultFeatureCollection;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfFile;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfGroup;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfLINE;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfPOINT;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfPOLYLINE;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfTEXT;

public class DxfBLOCKS {
    DefaultFeatureCollection pointEntities = new DefaultFeatureCollection();
    DefaultFeatureCollection lineEntities = new DefaultFeatureCollection();
    DefaultFeatureCollection polygonEntities = new DefaultFeatureCollection();

    public static DxfBLOCKS readBlocks(RandomAccessFile raf) throws IOException {
        DxfBLOCKS blocks = new DxfBLOCKS();
        DxfGroup group = null;
        while (null != (group = DxfGroup.readGroup(raf)) && !group.equals(DxfFile.ENDSEC)) {
        }
        return blocks;
    }

    public static DxfBLOCKS readEntities(RandomAccessFile raf) throws IOException {
        DxfBLOCKS dxfEntities = new DxfBLOCKS();
        DxfGroup group = new DxfGroup(2, "BLOCKS");
        while (!group.equals(DxfFile.ENDSEC)) {
            if (group.getCode() == 0) {
                if (group.getValue().equals("POINT")) {
                    group = DxfPOINT.readEntity(raf, dxfEntities.pointEntities);
                    continue;
                }
                if (group.getValue().equals("TEXT")) {
                    group = DxfTEXT.readEntity(raf, dxfEntities.pointEntities);
                    continue;
                }
                if (group.getValue().equals("LINE")) {
                    group = DxfLINE.readEntity(raf, dxfEntities.lineEntities);
                    continue;
                }
                if (group.getValue().equals("POLYLINE")) {
                    group = DxfPOLYLINE.readEntity(raf, dxfEntities.lineEntities);
                    continue;
                }
                if (group.getValue().equals("TEXT")) {
                    group = DxfTEXT.readEntity(raf, dxfEntities.pointEntities);
                    continue;
                }
                group = DxfGroup.readGroup(raf);
                continue;
            }
            System.out.println("Group " + group.getCode() + " " + group.getValue() + " UNKNOWN");
            group = DxfGroup.readGroup(raf);
        }
        return dxfEntities;
    }
}

