/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs.dxf;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfENTITY;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfFile;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfGroup;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.feature.simple.SimpleFeature;

public class DxfLINE
extends DxfENTITY {
    public DxfLINE() {
        super("DEFAULT");
    }

    public static DxfGroup readEntity(RandomAccessFile raf, DefaultFeatureCollection entities) throws IOException {
        DxfGroup group;
        double x1 = Double.NaN;
        double y1 = Double.NaN;
        double z1 = Double.NaN;
        double x2 = Double.NaN;
        double y2 = Double.NaN;
        double z2 = Double.NaN;
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(DxfFile.DXF_LINESCHEMA);
        String layer = "";
        String ltype = "";
        Double elevation = new Double(0.0);
        Double thickness = new Double(0.0);
        Integer color = new Integer(256);
        String text = "";
        Double text_height = new Double(0.0);
        String text_style = "";
        while (null != (group = DxfGroup.readGroup(raf)) && group.getCode() != 0) {
            if (group.getCode() == 8) {
                layer = group.getValue();
                continue;
            }
            if (group.getCode() == 6) {
                ltype = group.getValue();
                continue;
            }
            if (group.getCode() == 39) {
                thickness = new Double(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 62) {
                color = new Integer(group.getIntValue());
                continue;
            }
            if (group.getCode() == 10) {
                x1 = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 20) {
                y1 = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 30) {
                z1 = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 11) {
                x2 = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 21) {
                y2 = group.getDoubleValue();
                continue;
            }
            if (group.getCode() != 31) continue;
            z2 = group.getDoubleValue();
        }
        if (!(Double.isNaN(x1) || Double.isNaN(y1) || Double.isNaN(x2) || Double.isNaN(y2))) {
            Object[] values = new Object[]{gF.createLineString(new Coordinate[]{new Coordinate(x1, y1, z1), new Coordinate(x2, y2, z2)}), layer, ltype, elevation, thickness, color, text, text_height, text_style};
            builder.addAll(values);
            StringBuilder featureId = new StringBuilder();
            featureId.append(DxfFile.DXF_LINESCHEMA.getTypeName());
            featureId.append(".");
            featureId.append(DxfFile.getNextFid());
            SimpleFeature feature = builder.buildFeature(featureId.toString());
            entities.add(feature);
        }
        return group;
    }
}

