/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs.dxf;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfGroup;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfTABLE_ITEM;

public class DxfTABLE_LAYER_ITEM
extends DxfTABLE_ITEM {
    private int colorNumber;
    private String lineType;

    public DxfTABLE_LAYER_ITEM(String name, int flags) {
        super(name, flags);
        this.colorNumber = 0;
        this.lineType = "DEFAULT";
    }

    public DxfTABLE_LAYER_ITEM(String name, int flags, int colorNumber, String lineType) {
        super(name, flags);
        this.colorNumber = colorNumber;
        this.lineType = lineType;
    }

    public String getLineType() {
        return this.lineType;
    }

    public void setLineType(String lineType) {
        this.lineType = lineType;
    }

    public int getcolorNumber() {
        return this.colorNumber;
    }

    public void setColorNumber(int colorNumber) {
        this.colorNumber = colorNumber;
    }

    public static Map readTable(RandomAccessFile raf) throws IOException {
        DxfGroup group;
        DxfTABLE_LAYER_ITEM item = new DxfTABLE_LAYER_ITEM("DEFAULT", 0);
        LinkedHashMap<String, DxfTABLE_LAYER_ITEM> table = new LinkedHashMap<String, DxfTABLE_LAYER_ITEM>();
        while (null != (group = DxfGroup.readGroup(raf)) && !group.equals(ENDTAB)) {
            if (group.equals(LAYER)) {
                item = new DxfTABLE_LAYER_ITEM("DEFAULT", 0);
                continue;
            }
            if (group.getCode() == 2) {
                item.setName(group.getValue());
                table.put(item.getName(), item);
                continue;
            }
            if (group.getCode() == 5 || group.getCode() == 100) continue;
            if (group.getCode() == 70) {
                item.setFlags(group.getIntValue());
                continue;
            }
            if (group.getCode() == 62) {
                item.setColorNumber(group.getIntValue());
                continue;
            }
            if (group.getCode() != 6) continue;
            item.setLineType(group.getValue());
        }
        return table;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(DxfGroup.toString(62, this.colorNumber));
        sb.append(DxfGroup.toString(6, this.lineType));
        return sb.toString();
    }
}

