/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs.dxf;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfGroup;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfTABLE_ITEM;

public class DxfTABLE_LTYPE_ITEM
extends DxfTABLE_ITEM {
    private String description;
    private int alignment;
    private float patternLength;
    private float[] pattern;

    public DxfTABLE_LTYPE_ITEM(String name, int flags) {
        super(name, flags);
        this.description = "";
        this.alignment = 0;
        this.patternLength = 1.0f;
        this.pattern = new float[]{1.0f};
    }

    public DxfTABLE_LTYPE_ITEM(String name, int flags, String description, int alignment, float patternLength, float[] pattern) {
        super(name, flags);
        this.description = description;
        this.alignment = alignment;
        this.patternLength = patternLength;
        this.pattern = pattern;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public float getPatternLength() {
        return this.patternLength;
    }

    public void setPatternLength(float patternLength) {
        this.patternLength = patternLength;
    }

    public float[] getPattern() {
        return this.pattern;
    }

    public void setPattern(float[] pattern) {
        this.pattern = pattern;
    }

    public static Map readTable(RandomAccessFile raf) throws IOException {
        DxfGroup group;
        DxfTABLE_LTYPE_ITEM item = new DxfTABLE_LTYPE_ITEM("DEFAULT", 0);
        LinkedHashMap<String, DxfTABLE_LTYPE_ITEM> table = new LinkedHashMap<String, DxfTABLE_LTYPE_ITEM>();
        int patternDashCount = 0;
        while (null != (group = DxfGroup.readGroup(raf)) && !group.equals(ENDTAB)) {
            if (group.equals(LTYPE)) {
                item = new DxfTABLE_LTYPE_ITEM("DEFAULT", 0);
                continue;
            }
            if (group.getCode() == 2) {
                item.setName(group.getValue());
                table.put(item.getName(), item);
                continue;
            }
            if (group.getCode() == 5 || group.getCode() == 100) continue;
            if (group.getCode() == 70) {
                item.setFlags(group.getIntValue());
                continue;
            }
            if (group.getCode() == 3) {
                item.setDescription(group.getValue());
                continue;
            }
            if (group.getCode() == 72) {
                item.setAlignment(group.getIntValue());
                continue;
            }
            if (group.getCode() == 73) {
                item.setPattern(new float[group.getIntValue()]);
                continue;
            }
            if (group.getCode() == 40) {
                item.setPatternLength(group.getFloatValue());
                continue;
            }
            if (group.getCode() != 49 || patternDashCount >= item.getPattern().length) continue;
            item.getPattern()[patternDashCount++] = group.getFloatValue();
        }
        return table;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(DxfGroup.toString(3, this.description));
        sb.append(DxfGroup.toString(72, this.alignment));
        sb.append(DxfGroup.toString(73, this.pattern.length));
        sb.append(DxfGroup.toString(40, this.patternLength, 3));
        for (int i = 0; i < this.pattern.length; ++i) {
            sb.append(DxfGroup.toString(49, this.pattern[i], 3));
        }
        return sb.toString();
    }
}

