/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs.dxf;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfGroup;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfTABLE_ITEM;

public class DxfTABLE_STYLE_ITEM
extends DxfTABLE_ITEM {
    private float textHeight;
    private float widthFactor;
    private float obliquingAngle;
    private int textGenerationFlags;
    private float lastHeightUsed;
    private String primaryFontFileName;
    private String bigFontFileName;

    public DxfTABLE_STYLE_ITEM(String name, int flags) {
        super(name, flags);
        this.textHeight = 0.0f;
        this.widthFactor = 0.0f;
        this.obliquingAngle = 0.0f;
        this.textGenerationFlags = 0;
        this.lastHeightUsed = 0.0f;
        this.primaryFontFileName = "";
        this.bigFontFileName = "";
    }

    public DxfTABLE_STYLE_ITEM(String name, int flags, float textHeight, float widthFactor, float obliqingAngle, int textGenerationFlags, float lastHeightUsed, String primaryFontFileName, String bigFontFileName) {
        super(name, flags);
        this.textHeight = textHeight;
        this.widthFactor = widthFactor;
        this.obliquingAngle = obliqingAngle;
        this.textGenerationFlags = textGenerationFlags;
        this.lastHeightUsed = lastHeightUsed;
        this.primaryFontFileName = primaryFontFileName;
        this.bigFontFileName = bigFontFileName;
    }

    public float getTextHeight() {
        return this.textHeight;
    }

    public float getWidthFactor() {
        return this.widthFactor;
    }

    public float getObliquingAngle() {
        return this.obliquingAngle;
    }

    public int getTextGenerationFlags() {
        return this.textGenerationFlags;
    }

    public float getLastHeightUsed() {
        return this.lastHeightUsed;
    }

    public String getPrimaryFontFileName() {
        return this.primaryFontFileName;
    }

    public String getBigFontFileName() {
        return this.bigFontFileName;
    }

    public void setTextHeight(float textHeight) {
        this.textHeight = textHeight;
    }

    public void setWidthFactor(float widthFactor) {
        this.widthFactor = widthFactor;
    }

    public void setObliquingAngle(float obliquingAngle) {
        this.obliquingAngle = obliquingAngle;
    }

    public void setTextGenerationFlags(int textGenerationFlags) {
        this.textGenerationFlags = textGenerationFlags;
    }

    public void setLastHeightUsed(float lastHeightUsed) {
        this.lastHeightUsed = lastHeightUsed;
    }

    public void setPrimaryFontFileName(String primaryFontFileName) {
        this.primaryFontFileName = primaryFontFileName;
    }

    public void setBigFontFileName(String bigFontFileName) {
        this.bigFontFileName = bigFontFileName;
    }

    public static Map readTable(RandomAccessFile raf) throws IOException {
        DxfGroup group;
        DxfTABLE_STYLE_ITEM item = new DxfTABLE_STYLE_ITEM("DEFAULT", 0);
        LinkedHashMap<String, DxfTABLE_STYLE_ITEM> table = new LinkedHashMap<String, DxfTABLE_STYLE_ITEM>();
        while (null != (group = DxfGroup.readGroup(raf)) && !group.equals(ENDTAB)) {
            if (group.equals(STYLE)) {
                item = new DxfTABLE_STYLE_ITEM("DEFAULT", 0);
                continue;
            }
            if (group.getCode() == 2) {
                item.setName(group.getValue());
                table.put(item.getName(), item);
                continue;
            }
            if (group.getCode() == 5 || group.getCode() == 100) continue;
            if (group.getCode() == 70) {
                item.setFlags(group.getIntValue());
                continue;
            }
            if (group.getCode() == 40) {
                item.setTextHeight(group.getFloatValue());
                continue;
            }
            if (group.getCode() == 41) {
                item.setWidthFactor(group.getFloatValue());
                continue;
            }
            if (group.getCode() == 50) {
                item.setObliquingAngle(group.getFloatValue());
                continue;
            }
            if (group.getCode() == 71) {
                item.setTextGenerationFlags(group.getIntValue());
                continue;
            }
            if (group.getCode() == 42) {
                item.setLastHeightUsed(group.getFloatValue());
                continue;
            }
            if (group.getCode() == 3) {
                item.setPrimaryFontFileName(group.getValue());
                continue;
            }
            if (group.getCode() != 4) continue;
            item.setBigFontFileName(group.getValue());
        }
        return table;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(DxfGroup.toString(40, this.textHeight, 3));
        sb.append(DxfGroup.toString(41, this.widthFactor, 3));
        sb.append(DxfGroup.toString(50, this.obliquingAngle, 3));
        sb.append(DxfGroup.toString(71, this.textGenerationFlags));
        sb.append(DxfGroup.toString(42, this.lastHeightUsed, 3));
        sb.append(DxfGroup.toString(3, this.primaryFontFileName));
        sb.append(DxfGroup.toString(4, this.bigFontFileName));
        return sb.toString();
    }
}

