/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs.dxf;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfGroup;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfTABLE_ITEM;

public class DxfTABLE_VIEW_ITEM
extends DxfTABLE_ITEM {
    private float viewHeight;
    private float viewWidth;
    private double viewCenterPointX;
    private double viewCenterPointY;
    private double[] viewDirectionFromTarget;
    private double[] targetPoint;
    private float lensLength;
    private double frontClippingPlaneOffset;
    private double backClippingPlaneOffset;
    private float twistAngle;
    private int viewMode;

    public DxfTABLE_VIEW_ITEM(String name, int flags) {
        super(name, flags);
        this.viewHeight = 0.0f;
        this.viewWidth = 0.0f;
        this.viewCenterPointX = 0.0;
        this.viewCenterPointY = 0.0;
        this.viewDirectionFromTarget = new double[3];
        this.targetPoint = new double[3];
        this.lensLength = 0.0f;
        this.frontClippingPlaneOffset = 0.0;
        this.backClippingPlaneOffset = 0.0;
        this.twistAngle = 0.0f;
        this.viewMode = 0;
    }

    public DxfTABLE_VIEW_ITEM(String name, int flags, float viewHeight, float viewWidth, double viewCenterPointX, double viewCenterPointY, double[] viewDirectionFromTarget, double[] targetPoint, float lensLength, double frontClippingPlaneOffset, double backClippingPlaneOffset, float twistAngle, int viewMode) {
        super(name, flags);
        this.viewHeight = viewHeight;
        this.viewWidth = viewWidth;
        this.viewCenterPointX = viewCenterPointX;
        this.viewCenterPointY = viewCenterPointY;
        this.viewDirectionFromTarget = viewDirectionFromTarget;
        this.targetPoint = targetPoint;
        this.lensLength = lensLength;
        this.frontClippingPlaneOffset = frontClippingPlaneOffset;
        this.backClippingPlaneOffset = backClippingPlaneOffset;
        this.twistAngle = twistAngle;
        this.viewMode = viewMode;
    }

    public float getViewHeight() {
        return this.viewHeight;
    }

    public float getViewWidth() {
        return this.viewWidth;
    }

    public double getViewCenterPointX() {
        return this.viewCenterPointX;
    }

    public double getViewCenterPointY() {
        return this.viewCenterPointY;
    }

    public double[] getViewDirectionFromTarget() {
        return this.viewDirectionFromTarget;
    }

    public double[] getTargetPoint() {
        return this.targetPoint;
    }

    public float getLensLength() {
        return this.lensLength;
    }

    public double getFrontClippingPlaneOffset() {
        return this.frontClippingPlaneOffset;
    }

    public double getBackClippingPlaneOffset() {
        return this.backClippingPlaneOffset;
    }

    public float getTwistAngle() {
        return this.twistAngle;
    }

    public int getViewMode() {
        return this.viewMode;
    }

    public void setViewHeight(float viewHeight) {
        this.viewHeight = viewHeight;
    }

    public void setViewWidth(float viewWidth) {
        this.viewWidth = viewWidth;
    }

    public void setViewCenterPointX(double viewCenterPointX) {
        this.viewCenterPointX = viewCenterPointX;
    }

    public void setViewCenterPointY(double viewCenterPointY) {
        this.viewCenterPointY = viewCenterPointY;
    }

    public void setViewDirectionFromTarget(double[] viewDirectionFromTarget) {
        this.viewDirectionFromTarget = viewDirectionFromTarget;
    }

    public void setTargetPoint(double[] targetPoint) {
        this.targetPoint = targetPoint;
    }

    public void setLensLength(float lensLength) {
        this.lensLength = lensLength;
    }

    public void setFrontClippingPlaneOffset(double frontClippingPlaneOffset) {
        this.frontClippingPlaneOffset = frontClippingPlaneOffset;
    }

    public void setBackClippingPlaneOffset(double backClippingPlaneOffset) {
        this.backClippingPlaneOffset = backClippingPlaneOffset;
    }

    public void setTwistAngle(float twistAngle) {
        this.twistAngle = twistAngle;
    }

    public void setViewMode(int viewMode) {
        this.viewMode = viewMode;
    }

    public static Map readTable(RandomAccessFile raf) throws IOException {
        DxfGroup group;
        DxfTABLE_VIEW_ITEM item = new DxfTABLE_VIEW_ITEM("DEFAULT", 0);
        LinkedHashMap<String, DxfTABLE_VIEW_ITEM> table = new LinkedHashMap<String, DxfTABLE_VIEW_ITEM>();
        while (null != (group = DxfGroup.readGroup(raf)) && !group.equals(ENDTAB)) {
            if (group.equals(VIEW)) {
                item = new DxfTABLE_VIEW_ITEM("DEFAULT", 0);
                continue;
            }
            if (group.getCode() == 2) {
                item.setName(group.getValue());
                table.put(item.getName(), item);
                continue;
            }
            if (group.getCode() == 5 || group.getCode() == 100) continue;
            if (group.getCode() == 70) {
                item.setFlags(group.getIntValue());
                continue;
            }
            if (group.getCode() == 40) {
                item.setViewHeight(group.getFloatValue());
                continue;
            }
            if (group.getCode() == 41) {
                item.setViewWidth(group.getFloatValue());
                continue;
            }
            if (group.getCode() == 10) {
                item.setViewCenterPointX(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 20) {
                item.setViewCenterPointY(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 11) {
                item.getViewDirectionFromTarget()[0] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 21) {
                item.getViewDirectionFromTarget()[1] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 31) {
                item.getViewDirectionFromTarget()[2] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 12) {
                item.getTargetPoint()[0] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 22) {
                item.getTargetPoint()[1] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 32) {
                item.getTargetPoint()[2] = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 42) {
                item.setLensLength(group.getFloatValue());
                continue;
            }
            if (group.getCode() == 43) {
                item.setFrontClippingPlaneOffset(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 44) {
                item.setBackClippingPlaneOffset(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 50) {
                item.setTwistAngle(group.getFloatValue());
                continue;
            }
            if (group.getCode() != 71) continue;
            item.setViewMode(group.getIntValue());
        }
        return table;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(DxfGroup.toString(40, this.viewHeight, 6));
        sb.append(DxfGroup.toString(41, this.viewWidth, 6));
        sb.append(DxfGroup.toString(10, this.viewCenterPointX, 6));
        sb.append(DxfGroup.toString(20, this.viewCenterPointY, 6));
        sb.append(DxfGroup.toString(11, this.viewDirectionFromTarget[0], 6));
        sb.append(DxfGroup.toString(21, this.viewDirectionFromTarget[1], 6));
        sb.append(DxfGroup.toString(31, this.viewDirectionFromTarget[2], 6));
        sb.append(DxfGroup.toString(12, this.targetPoint[0], 6));
        sb.append(DxfGroup.toString(22, this.targetPoint[1], 6));
        sb.append(DxfGroup.toString(32, this.targetPoint[2], 6));
        sb.append(DxfGroup.toString(42, this.lensLength, 6));
        sb.append(DxfGroup.toString(43, this.frontClippingPlaneOffset, 6));
        sb.append(DxfGroup.toString(44, this.backClippingPlaneOffset, 6));
        sb.append(DxfGroup.toString(50, this.twistAngle, 6));
        sb.append(DxfGroup.toString(71, this.viewMode));
        return sb.toString();
    }
}

