/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.dxfdwg.libs.dxf;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfENTITY;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfFile;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfGroup;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.feature.simple.SimpleFeature;

public class DxfTEXT
extends DxfENTITY {
    public DxfTEXT() {
        super("DEFAULT");
    }

    public static DxfGroup readEntity(RandomAccessFile raf, DefaultFeatureCollection entities) throws IOException {
        DxfGroup group;
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(DxfFile.DXF_POINTSCHEMA);
        String layer = "";
        String ltype = "";
        Double elevation = new Double(0.0);
        Double thickness = new Double(0.0);
        Integer color = new Integer(256);
        String text = "";
        Double text_height = new Double(0.0);
        String text_style = "";
        double x = Double.NaN;
        double y = Double.NaN;
        double z = Double.NaN;
        while (null != (group = DxfGroup.readGroup(raf)) && group.getCode() != 0) {
            if (group.getCode() == 8) {
                layer = group.getValue();
                continue;
            }
            if (group.getCode() == 6) {
                ltype = group.getValue();
                continue;
            }
            if (group.getCode() == 38) {
                elevation = new Double(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 39) {
                thickness = new Double(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 62) {
                color = new Integer(group.getIntValue());
                continue;
            }
            if (group.getCode() == 10) {
                x = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 20) {
                y = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 30) {
                z = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 1) {
                text = group.getValue();
                continue;
            }
            if (group.getCode() == 40) {
                text_height = new Double(group.getDoubleValue());
                continue;
            }
            if (group.getCode() != 7) continue;
            text_style = group.getValue();
        }
        if (!Double.isNaN(x) && !Double.isNaN(y)) {
            Object[] values = new Object[]{gF.createPoint(new Coordinate(x, y, z)), layer, ltype, elevation, thickness, color, text, text_height, text_style};
            builder.addAll(values);
            StringBuilder featureId = new StringBuilder();
            featureId.append(DxfFile.DXF_POINTSCHEMA.getTypeName());
            featureId.append(".");
            featureId.append(DxfFile.getNextFid());
            SimpleFeature feature = builder.buildFeature(featureId.toString());
            entities.add(feature);
        }
        return group;
    }
}

