/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.eicalculator;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.io.eicalculator.EIAreas;
import org.hortonmachine.gears.libs.modules.HMModel;

@Description(value="Utility class for writing area data (for EICalculator) to csv files.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Writing")
@Label(value="List Data Writer")
@Name(value="eiareaswriter")
@Status(value=40)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsEIAreasWriter
extends HMModel {
    @Description(value="The data to write.")
    @In
    public List<EIAreas> inAreas;
    @Description(value="The csv file to write to.")
    @UI(value="outfile")
    @In
    public String file = null;
    @Description(value="The csv separator.")
    @In
    public String pSeparator = ",";
    private BufferedWriter csvWriter;

    private void ensureOpen() throws IOException {
        if (this.csvWriter == null) {
            this.csvWriter = new BufferedWriter(new FileWriter(this.file));
        }
    }

    @Finalize
    public void close() throws IOException {
        this.csvWriter.close();
    }

    @Execute
    public void write() throws IOException {
        this.ensureOpen();
        this.csvWriter.write("# EIAreas writer output\n");
        for (EIAreas areas : this.inAreas) {
            StringBuilder sb = new StringBuilder();
            sb.append(areas.basinId);
            sb.append(this.pSeparator);
            sb.append(areas.altimetricBandId);
            sb.append(this.pSeparator);
            sb.append(areas.energyBandId);
            sb.append(this.pSeparator);
            sb.append(areas.areaValue);
            sb.append("\n");
            this.csvWriter.write(sb.toString());
        }
    }
}

