/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.generic;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;

@Description(value="Utility class for writing data to csv file that have the form: id1 value1[] id2 value2[] ... idn valuen[].")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Writing")
@Label(value="HashMap Data Writer")
@Name(value="id2valuearraywriter")
@Status(value=40)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
@UI(value="hide")
public class OmsId2ValueArrayWriter
extends HMModel {
    @Description(value="The csv file to write to.")
    @UI(value="infile_csv")
    @In
    public String file = null;
    @Description(value="The csv separator.")
    @In
    public String pSeparator = ",";
    @Description(value="The file novalue.")
    @In
    public String fileNovalue = "-9999.0";
    @Description(value="The map of ids and values arrays to write.")
    @In
    public HashMap<Integer, double[]> data;
    private BufferedWriter csvWriter;
    private double novalue = -9999.0;

    private void ensureOpen() throws IOException {
        if (this.csvWriter == null) {
            this.csvWriter = new BufferedWriter(new FileWriter(this.file));
        }
    }

    @Execute
    public void writeNextLine() throws IOException {
        this.ensureOpen();
        this.novalue = Double.parseDouble(this.fileNovalue);
        Set<Map.Entry<Integer, double[]>> entrySet = this.data.entrySet();
        for (Map.Entry<Integer, double[]> entry : entrySet) {
            Integer id = entry.getKey();
            double[] values = entry.getValue();
            this.csvWriter.write(id.toString());
            this.csvWriter.write(this.pSeparator);
            for (int i = 0; i < values.length; ++i) {
                double value = values[i];
                if (HMConstants.isNovalue(value)) {
                    value = this.novalue;
                }
                this.csvWriter.write(String.valueOf(value));
                this.csvWriter.write(this.pSeparator);
            }
        }
        this.csvWriter.write("\n");
    }

    @Finalize
    public void close() throws IOException {
        this.csvWriter.close();
    }
}

