/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.generic;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;

@Description(value="Utility class for reading data from csv file that have the form: id1 value1 id2 value2 ... idn valuen.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Reading")
@Label(value="HashMap Data Reader")
@Name(value="plainid2valuereader")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
@UI(value="hide")
public class OmsPlainId2ValueReader
extends HMModel {
    @Description(value="The csv file to read from.")
    @UI(value="infile_csv")
    @In
    public String file = null;
    @Description(value="The csv separator.")
    @In
    public String pSeparator = ",";
    @Description(value="The file novalue.")
    @In
    public String fileNovalue = "-9999.0";
    @Description(value="The novalue wanted in the coverage.")
    @In
    public double novalue = -9999.0;
    @Description(value="The read map of ids and values.")
    @Out
    public HashMap<Integer, double[]> data;
    protected BufferedReader csvReader;

    private void ensureOpen() throws IOException {
        if (this.csvReader == null) {
            this.csvReader = new BufferedReader(new FileReader(this.file));
        }
    }

    @Execute
    public void readNextLine() throws IOException {
        this.ensureOpen();
        this.data = new HashMap();
        String line = null;
        line = this.csvReader.readLine();
        if (line != null) {
            String[] lineSplit = line.split(this.pSeparator);
            for (int i = 0; i < lineSplit.length; i += 2) {
                int id = (int)Double.parseDouble(lineSplit[i].trim());
                double value = Double.parseDouble(lineSplit[i + 1].trim());
                if (this.fileNovalue != null && lineSplit[i + 1].trim().equals(this.fileNovalue)) {
                    value = this.novalue;
                }
                this.data.put(id, new double[]{value});
            }
        }
    }

    @Finalize
    public void close() throws IOException {
        this.csvReader.close();
    }
}

