/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.geopaparazzi;

import java.io.File;
import java.io.FilenameFilter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hortonmachine.dbs.compat.IHMConnection;
import org.hortonmachine.dbs.compat.IHMResultSet;
import org.hortonmachine.dbs.compat.IHMStatement;
import org.hortonmachine.dbs.spatialite.hm.SqliteDb;
import org.hortonmachine.gears.io.geopaparazzi.forms.Utilities;
import org.hortonmachine.gears.io.geopaparazzi.geopap4.ETimeUtilities;
import org.hortonmachine.gears.io.geopaparazzi.geopap4.TableDescriptions;
import org.json.JSONArray;
import org.json.JSONObject;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeopaparazziUtilities {
    public static final String PROJECT_NAME = "name";
    public static final String PROJECT_CREATION_USER = "creationuser";
    public static final String PROJECT_CREATION_TS = "creationts";
    public static final String PROJECT_DESCRIPTION = "description";
    public static final String GPAP_EXTENSION = "gpap";
    public static final String GPS_LOGS = "GPS logs";
    public static final String MEDIA_NOTES = "Media Notes";
    public static final String SIMPLE_NOTES = "Simple Notes";
    public static final String TAG_KEY = "key";
    public static final String TAG_VALUE = "value";
    public static final String TAG_TYPE = "type";
    public static final String NOTES_tsFN = TableDescriptions.NotesTableFields.COLUMN_TS.getFieldName();
    public static final String NOTES_altimFN = TableDescriptions.NotesTableFields.COLUMN_ALTIM.getFieldName();
    public static final String NOTES_dirtyFN = TableDescriptions.NotesTableFields.COLUMN_ISDIRTY.getFieldName();
    public static final String NOTES_textFN = TableDescriptions.NotesTableFields.COLUMN_TEXT.getFieldName();
    public static final String NOTES_descFN = TableDescriptions.NotesTableFields.COLUMN_DESCRIPTION.getFieldName();
    public static final String NOTES_formFN = TableDescriptions.NotesTableFields.COLUMN_FORM.getFieldName();
    public static final String GPSLOG_descrFN = "DESCR";
    public static final String GPSLOG_enddateFN = "ENDDATE";
    public static final String GPSLOG_startdateFN = "STARTDATE";
    public static final String IMAGES_altimFN = TableDescriptions.ImageTableFields.COLUMN_ALTIM.getFieldName();
    public static final String IMAGES_tsFN = TableDescriptions.ImageTableFields.COLUMN_TS.getFieldName();
    public static final String IMAGES_azimFN = TableDescriptions.ImageTableFields.COLUMN_AZIM.getFieldName();
    public static final String IMAGES_imageidFN = "imageid";

    public static List<HashMap<String, String>> readProjectMetadata(File[] projectFiles) throws Exception {
        ArrayList<HashMap<String, String>> infoList = new ArrayList<HashMap<String, String>>();
        for (File geopapDatabaseFile : projectFiles) {
            try (SqliteDb db = new SqliteDb();){
                db.open(geopapDatabaseFile.getAbsolutePath());
                HashMap projectInfo = (HashMap)db.execOnConnection(connection -> GeopaparazziUtilities.getProjectMetadata(connection));
                infoList.add(projectInfo);
            }
        }
        return infoList;
    }

    public static File[] getGeopaparazziFiles(File geopaparazziFolder) {
        File[] projectFiles = geopaparazziFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(GeopaparazziUtilities.GPAP_EXTENSION);
            }
        });
        Arrays.sort(projectFiles, Collections.reverseOrder());
        return projectFiles;
    }

    public static LinkedHashMap<String, String> getProjectMetadata(IHMConnection connection) throws Exception {
        LinkedHashMap<String, String> metadataMap = new LinkedHashMap<String, String>();
        try (IHMStatement statement = connection.createStatement();){
            statement.setQueryTimeout(30);
            String sql = "select " + TableDescriptions.MetadataTableFields.COLUMN_KEY.getFieldName() + ", " + TableDescriptions.MetadataTableFields.COLUMN_VALUE.getFieldName() + " from metadata";
            IHMResultSet rs = statement.executeQuery(sql);
            while (rs.next()) {
                String key = rs.getString(TableDescriptions.MetadataTableFields.COLUMN_KEY.getFieldName());
                String value = rs.getString(TableDescriptions.MetadataTableFields.COLUMN_VALUE.getFieldName());
                if (!key.endsWith("ts")) {
                    metadataMap.put(key, value);
                    continue;
                }
                try {
                    long ts = Long.parseLong(value);
                    String dateTimeString = ETimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(ts));
                    metadataMap.put(key, dateTimeString);
                }
                catch (Exception e) {
                    metadataMap.put(key, value);
                }
            }
        }
        return metadataMap;
    }

    public static List<String> getLayerNamesList(IHMConnection connection) throws Exception {
        String formFN = TableDescriptions.NotesTableFields.COLUMN_FORM.getFieldName();
        String textFN = TableDescriptions.NotesTableFields.COLUMN_TEXT.getFieldName();
        ArrayList<String> layerNames = new ArrayList<String>();
        Object sql = "select count(*) from notes where " + formFN + " is null or " + formFN + " = ''";
        int count = GeopaparazziUtilities.countRows(connection, (String)sql);
        if (count > 0) {
            layerNames.add(SIMPLE_NOTES);
        }
        if ((count = GeopaparazziUtilities.countRows(connection, (String)(sql = "select count(*) from images"))) > 0) {
            layerNames.add(MEDIA_NOTES);
        }
        if ((count = GeopaparazziUtilities.countRows(connection, (String)(sql = "select count(*) from gpslogs"))) > 0) {
            layerNames.add(GPS_LOGS);
        }
        sql = "select distinct " + textFN + " from notes where " + formFN + " is not null and " + formFN + "<>''";
        try (IHMStatement statement = connection.createStatement();
             IHMResultSet rs = statement.executeQuery((String)sql);){
            statement.setQueryTimeout(30);
            while (rs.next()) {
                String formName = rs.getString(1);
                layerNames.add(formName);
            }
        }
        return layerNames;
    }

    private static int countRows(IHMConnection connection, String sql) throws Exception {
        try (IHMStatement statement = connection.createStatement();
             IHMResultSet rs = statement.executeQuery(sql);){
            if (rs.next()) {
                int notesCount;
                int n = notesCount = rs.getInt(1);
                return n;
            }
        }
        return 0;
    }

    public static String getProjectInfo(IHMConnection connection, boolean doHtml) throws Exception {
        StringBuilder sb = new StringBuilder();
        String sql = "select " + TableDescriptions.MetadataTableFields.COLUMN_KEY.getFieldName() + ", " + TableDescriptions.MetadataTableFields.COLUMN_VALUE.getFieldName() + " from metadata";
        try (IHMStatement statement = connection.createStatement();
             IHMResultSet rs = statement.executeQuery(sql);){
            statement.setQueryTimeout(30);
            while (rs.next()) {
                String key = rs.getString(TableDescriptions.MetadataTableFields.COLUMN_KEY.getFieldName());
                String value = rs.getString(TableDescriptions.MetadataTableFields.COLUMN_VALUE.getFieldName());
                String openBold = "<b>";
                String closeBold = "</b>";
                String nl = "<br/>";
                if (!doHtml) {
                    openBold = "";
                    closeBold = "";
                    nl = "\n";
                }
                if (!key.endsWith("ts")) {
                    sb.append(openBold).append(key).append(":" + closeBold + " ").append(GeopaparazziUtilities.escapeHTML(value)).append(nl);
                    continue;
                }
                try {
                    long ts = Long.parseLong(value);
                    String dateTimeString = ETimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(ts));
                    sb.append(openBold).append(key).append(":" + closeBold + " ").append(dateTimeString).append(nl);
                }
                catch (Exception e) {
                    sb.append(openBold).append(key).append(":" + closeBold + " ").append(GeopaparazziUtilities.escapeHTML(value)).append(nl);
                }
            }
        }
        return sb.toString();
    }

    public static List<String[]> getNotesText(Connection connection) throws Exception {
        String textFN = TableDescriptions.NotesTableFields.COLUMN_TEXT.getFieldName();
        String descFN = TableDescriptions.NotesTableFields.COLUMN_DESCRIPTION.getFieldName();
        String tsFN = TableDescriptions.NotesTableFields.COLUMN_TS.getFieldName();
        String altimFN = TableDescriptions.NotesTableFields.COLUMN_ALTIM.getFieldName();
        String latFN = TableDescriptions.NotesTableFields.COLUMN_LAT.getFieldName();
        String lonFN = TableDescriptions.NotesTableFields.COLUMN_LON.getFieldName();
        String sql = "select " + latFN + "," + lonFN + "," + altimFN + "," + tsFN + "," + textFN + "," + descFN + " from notes";
        ArrayList<String[]> notesDescriptionList = new ArrayList<String[]>();
        try (Statement statement = connection.createStatement();){
            statement.setQueryTimeout(30);
            ResultSet rs = statement.executeQuery(sql);
            while (rs.next()) {
                double lat = rs.getDouble(latFN);
                double lon = rs.getDouble(lonFN);
                double altim = rs.getDouble(altimFN);
                long ts = rs.getLong(tsFN);
                String dateTimeString = ETimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(ts));
                String text = rs.getString(textFN);
                String descr = rs.getString(descFN);
                if (descr == null) {
                    descr = "";
                }
                if (lat == 0.0 || lon == 0.0) continue;
                notesDescriptionList.add(new String[]{String.valueOf(lon), String.valueOf(lat), String.valueOf(altim), dateTimeString, text, descr});
            }
        }
        return notesDescriptionList;
    }

    public static String escapeHTML(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(Math.max(16, s.length()));
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f' || c == '\"' || c == '<' || c == '>' || c == '&') {
                out.append("&#");
                out.append((int)c);
                out.append(';');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String loadProjectsList(File gpapProjectsFolder) {
        try {
            File[] geopaparazziProjectFiles = GeopaparazziUtilities.getGeopaparazziFiles(gpapProjectsFolder);
            List<HashMap<String, String>> projectMetadataList = GeopaparazziUtilities.readProjectMetadata(geopaparazziProjectFiles);
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append("\"projects\": [");
            for (int i = 0; i < projectMetadataList.size(); ++i) {
                HashMap<String, String> metadataMap = projectMetadataList.get(i);
                long fileSize = geopaparazziProjectFiles[i].length();
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("{");
                sb.append("    \"id\": \"" + geopaparazziProjectFiles[i].getName() + "\",");
                sb.append("    \"title\": \"" + metadataMap.get(PROJECT_DESCRIPTION) + "\",");
                sb.append("    \"date\": \"" + metadataMap.get(PROJECT_CREATION_TS) + "\",");
                sb.append("    \"author\": \"" + metadataMap.get(PROJECT_CREATION_USER) + "\",");
                sb.append("    \"name\": \"" + metadataMap.get(PROJECT_NAME) + "\",");
                sb.append("    \"size\": \"" + fileSize + "\"");
                sb.append("}");
            }
            sb.append("]");
            sb.append("}");
            return sb.toString();
        }
        catch (Exception e) {
            return "An error occurred: " + e.getMessage();
        }
    }

    public static SimpleFeatureType getSimpleNotesfeatureType() {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("gpsimplenotes");
        b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        b.add("the_geom", Point.class);
        b.add(NOTES_textFN, String.class);
        b.add(NOTES_descFN, String.class);
        b.add(NOTES_tsFN, String.class);
        b.add(NOTES_altimFN, Double.class);
        b.add(NOTES_dirtyFN, Integer.class);
        SimpleFeatureType featureType = b.buildFeatureType();
        return featureType;
    }

    public static SimpleFeatureType getGpsLogLinesFeatureType() {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("geopaparazzilogs");
        b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        b.add("the_geom", MultiLineString.class);
        b.add(GPSLOG_startdateFN, String.class);
        b.add(GPSLOG_enddateFN, String.class);
        b.add(GPSLOG_descrFN, String.class);
        SimpleFeatureType featureType = b.buildFeatureType();
        return featureType;
    }

    public static SimpleFeatureType getMediaFeaturetype() {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("geopaparazzimediapoints");
        b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        b.add("the_geom", Point.class);
        b.add(IMAGES_altimFN, String.class);
        b.add(IMAGES_tsFN, String.class);
        b.add(IMAGES_azimFN, Double.class);
        b.add(IMAGES_imageidFN, Long.class);
        SimpleFeatureType featureType = b.buildFeatureType();
        return featureType;
    }

    public static SimpleFeatureType getComplexNotefeatureType(String noteName, IHMConnection connection) throws Exception {
        String sql = "select " + NOTES_formFN + " from notes where " + NOTES_textFN + "='" + noteName + "'";
        try (IHMStatement statement = connection.createStatement();){
            SimpleFeatureType simpleFeatureType;
            block20: {
                SimpleFeatureType simpleFeatureType2;
                IHMResultSet rs = statement.executeQuery(sql);
                try {
                    while (rs.next()) {
                        SimpleFeatureType featureType;
                        JSONObject sectionObject;
                        String sectionName;
                        String formString = rs.getString(NOTES_formFN);
                        if (formString == null || formString.trim().length() == 0 || !(sectionName = (sectionObject = new JSONObject(formString)).getString("sectionname")).equals(noteName)) continue;
                        sectionName = sectionName.replaceAll("\\s+", "_");
                        LinkedHashMap<String, String> valuesMap = new LinkedHashMap<String, String>();
                        LinkedHashMap<String, String> typesMap = new LinkedHashMap<String, String>();
                        List<String> formNames4Section = Utilities.getFormNames4Section(sectionObject);
                        GeopaparazziUtilities.extractValues(sectionObject, formNames4Section, valuesMap, typesMap);
                        Set<Map.Entry<String, String>> entrySet = valuesMap.entrySet();
                        TreeMap<String, Integer> namesMap = new TreeMap<String, Integer>();
                        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
                        b.setName(sectionName);
                        b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                        b.add("the_geom", Point.class);
                        b.add(NOTES_tsFN, String.class);
                        b.add(NOTES_altimFN, Double.class);
                        b.add(NOTES_dirtyFN, Integer.class);
                        for (Map.Entry<String, String> entry : entrySet) {
                            Integer nCount;
                            Object key = entry.getKey();
                            if (((String)(key = ((String)key).replaceAll("\\s+", "_"))).length() > 10) {
                                key = ((String)key).substring(0, 10);
                            }
                            if ((nCount = (Integer)namesMap.get(key)) == null) {
                                nCount = 1;
                                namesMap.put((String)key, 1);
                            } else {
                                Integer n = nCount;
                                Integer n2 = nCount = Integer.valueOf(nCount + 1);
                                namesMap.put((String)key, nCount);
                                key = nCount < 10 ? ((String)key).substring(0, ((String)key).length() - 1) + nCount : ((String)key).substring(0, ((String)key).length() - 2) + nCount;
                            }
                            b.add((String)key, String.class);
                        }
                        simpleFeatureType2 = featureType = b.buildFeatureType();
                        if (rs == null) break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                {
                    block19: {
                        rs.close();
                    }
                    return simpleFeatureType2;
                }
                simpleFeatureType = null;
                if (rs == null) break block20;
                rs.close();
            }
            return simpleFeatureType;
        }
    }

    public static void extractValues(JSONObject sectionObject, List<String> formNames4Section, LinkedHashMap<String, String> valuesMap, LinkedHashMap<String, String> typesMap) {
        for (String formName : formNames4Section) {
            JSONObject form4Name = Utilities.getForm4Name(formName, sectionObject);
            JSONArray formItems = Utilities.getFormItems(form4Name);
            int length = formItems.length();
            for (int i = 0; i < length; ++i) {
                JSONObject jsonObject = formItems.getJSONObject(i);
                if (!jsonObject.has(TAG_KEY)) continue;
                String key = jsonObject.getString(TAG_KEY).trim();
                String value = null;
                if (jsonObject.has(TAG_VALUE)) {
                    value = jsonObject.get(TAG_VALUE).toString().trim();
                }
                String type = null;
                if (jsonObject.has(TAG_TYPE)) {
                    type = jsonObject.getString(TAG_TYPE).trim();
                }
                if (value == null) continue;
                valuesMap.put(key, value);
                typesMap.put(key, type);
            }
        }
    }
}

