/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.geopaparazzi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hortonmachine.gears.io.geopaparazzi.forms.Utilities;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.exceptions.ModelsRuntimeException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.json.JSONArray;
import org.json.JSONObject;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Converts a geopaparazzi 3 project folder into shapefiles.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="geopaparazzi, vector")
@Label(value="Mobile")
@Name(value="_geopapconvert_v3")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsGeopaparazzi3Converter
extends HMModel {
    @Description(value="The geopaparazzi folder")
    @UI(value="infolder")
    @In
    public String inGeopaparazzi = null;
    @Description(value="Flag to create notes")
    @In
    public boolean doNotes = true;
    @Description(value="Flag to create log lines")
    @In
    public boolean doLoglines = true;
    @Description(value="Flag to create log points")
    @In
    public boolean doLogpoints = false;
    @Description(value="Flag to create media points")
    @In
    public boolean doMedia = true;
    @Description(value="The output folder")
    @UI(value="outfolder")
    @In
    public String outData = null;
    public static final String DESCRIPTION = "Converts a geopaparazzi 3 project folder into shapefiles.";
    public static final String OMSGEOPAPARAZZICONVERTER_LABEL = "Vector Processing";
    public static final String OMSGEOPAPARAZZICONVERTER_TAGS = "geopaparazzi, vector";
    public static final String OMSGEOPAPARAZZICONVERTER_NAME = "geopapconvert";
    public static final String OMSGEOPAPARAZZICONVERTER_OUT_DATA_DESCRIPTION = "The output folder";
    public static final String OMSGEOPAPARAZZICONVERTER_DO_BOOKMARKS_DESCRIPTION = "Flag to create bookmarks points";
    public static final String OMSGEOPAPARAZZICONVERTER_DO_MEDIA_DESCRIPTION = "Flag to create media points";
    public static final String OMSGEOPAPARAZZICONVERTER_DO_LOG_POINTS_DESCRIPTION = "Flag to create log points";
    public static final String OMSGEOPAPARAZZICONVERTER_DO_LOG_LINES_DESCRIPTION = "Flag to create log lines";
    public static final String OMSGEOPAPARAZZICONVERTER_DO_NOTES_DESCRIPTION = "Flag to create notes";
    public static final String OMSGEOPAPARAZZICONVERTER_IN_GEOPAPARAZZI_DESCRIPTION = "The geopaparazzi folder";
    private static final String TAG_KEY = "key";
    private static final String TAG_VALUE = "value";
    private final DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
    private static boolean hasDriver = false;

    @Execute
    public void process() throws IOException {
        this.checkNull(this.inGeopaparazzi);
        if (!hasDriver) {
            throw new ModelsIllegalargumentException("Can't find any sqlite driver. Check your settings.", this, this.pm);
        }
        File geopapFolderFile = new File(this.inGeopaparazzi);
        File geopapDatabaseFile = new File(geopapFolderFile, "geopaparazzi.db");
        if (!geopapDatabaseFile.exists() && !(geopapDatabaseFile = new File(geopapFolderFile, "geopaparazzi3.db")).exists()) {
            throw new ModelsIllegalargumentException("The geopaparazzi database file (geopaparazzi.db) is missing. Check the inserted path.", this, this.pm);
        }
        File outputFolderFile = new File(this.outData);
        try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + geopapDatabaseFile.getAbsolutePath());){
            if (geopapDatabaseFile.exists()) {
                if (this.doNotes) {
                    this.simpleNotesToShapefile(connection, outputFolderFile, this.pm);
                    this.complexNotesToShapefile(connection, outputFolderFile, this.pm);
                }
                this.gpsLogToShapefiles(connection, outputFolderFile, this.pm);
            }
            this.mediaToShapeFile(geopapFolderFile, outputFolderFile, this.pm);
        }
        catch (Exception e) {
            throw new ModelsRuntimeException("An error occurred while importing from geopaparazzi: " + e.getLocalizedMessage(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simpleNotesToShapefile(Connection connection, File outputFolderFile, IHMProgressMonitor pm) throws Exception {
        File outputShapeFile = new File(outputFolderFile, "simplenotes.shp");
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("gpsimplenotes");
        b.setCRS((CoordinateReferenceSystem)this.crs);
        b.add("the_geom", Point.class);
        b.add("DESCR", String.class);
        b.add("TIMESTAMP", String.class);
        b.add("ALTIM", Double.class);
        SimpleFeatureType featureType = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
        pm.beginTask("Import simple notes...", -1);
        DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
        try (Statement statement = connection.createStatement();){
            statement.setQueryTimeout(30);
            ResultSet rs = statement.executeQuery("select lat, lon, altim, ts, text, form from notes");
            while (rs.next()) {
                String form = rs.getString("form");
                if (form != null && form.trim().length() != 0) continue;
                double lat = rs.getDouble("lat");
                double lon = rs.getDouble("lon");
                double altim = rs.getDouble("altim");
                String dateTimeString = rs.getString("ts");
                String text = rs.getString("text");
                if (lat == 0.0 || lon == 0.0) continue;
                Coordinate c = new Coordinate(lon, lat);
                Point point = this.gf.createPoint(c);
                Object[] values = new Object[]{point, text, dateTimeString, altim};
                builder.addAll(values);
                SimpleFeature feature = builder.buildFeature(null);
                newCollection.add(feature);
            }
        }
        finally {
            pm.done();
        }
        this.dumpVector((SimpleFeatureCollection)newCollection, outputShapeFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void complexNotesToShapefile(Connection connection, File outputFolderFile, IHMProgressMonitor pm) throws Exception {
        pm.beginTask("Import complex notes...", -1);
        HashMap<String, BuilderAndCollectionPair> forms2PropertiesMap = new HashMap<String, BuilderAndCollectionPair>();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.setQueryTimeout(30);
            ResultSet rs = statement.executeQuery("select lat, lon, altim, ts, text, form from notes");
            while (rs.next()) {
                String formString = rs.getString("form");
                if (formString == null || formString.trim().length() == 0) continue;
                double lat = rs.getDouble("lat");
                double lon = rs.getDouble("lon");
                double altim = rs.getDouble("altim");
                String dateTimeString = rs.getString("ts");
                if (lat == 0.0 || lon == 0.0) continue;
                Coordinate c = new Coordinate(lon, lat);
                Point point = this.gf.createPoint(c);
                JSONObject sectionObject = new JSONObject(formString);
                String sectionName = sectionObject.getString("sectionname");
                sectionName = sectionName.replaceAll("\\s+", "_");
                List<String> formNames4Section = Utilities.getFormNames4Section(sectionObject);
                LinkedHashMap<String, String> valuesMap = new LinkedHashMap<String, String>();
                for (String formName : formNames4Section) {
                    JSONObject form4Name = Utilities.getForm4Name(formName, sectionObject);
                    JSONArray formItems = Utilities.getFormItems(form4Name);
                    int n = formItems.length();
                    for (int i = 0; i < n; ++i) {
                        JSONObject jsonObject = formItems.getJSONObject(i);
                        if (!jsonObject.has(TAG_KEY)) continue;
                        String key = jsonObject.getString(TAG_KEY).trim();
                        String value = null;
                        if (jsonObject.has(TAG_VALUE)) {
                            value = jsonObject.getString(TAG_VALUE).trim();
                        }
                        if (value == null) continue;
                        valuesMap.put(key, value);
                    }
                }
                Set entrySet = valuesMap.entrySet();
                BuilderAndCollectionPair builderAndCollectionPair = (BuilderAndCollectionPair)forms2PropertiesMap.get(sectionName);
                if (builderAndCollectionPair == null) {
                    SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
                    b.setName(sectionName);
                    b.setCRS((CoordinateReferenceSystem)this.crs);
                    b.add("the_geom", Point.class);
                    b.add("ts", String.class);
                    b.add("altim", String.class);
                    for (Map.Entry entry : entrySet) {
                        String key = (String)entry.getKey();
                        if ((key = key.replaceAll("\\s+", "_")).length() > 10) {
                            pm.errorMessage("Need to trim key: " + key);
                            key = key.substring(0, 10);
                        }
                        b.add(key, String.class);
                    }
                    SimpleFeatureType featureType = b.buildFeatureType();
                    SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(featureType);
                    DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
                    builderAndCollectionPair = new BuilderAndCollectionPair();
                    builderAndCollectionPair.builder = simpleFeatureBuilder;
                    builderAndCollectionPair.collection = newCollection;
                    forms2PropertiesMap.put(sectionName, builderAndCollectionPair);
                }
                int size = entrySet.size();
                Object[] values = new Object[size + 3];
                values[0] = point;
                values[1] = dateTimeString;
                values[2] = "" + altim;
                int n = 3;
                for (Map.Entry entry : entrySet) {
                    void var25_26;
                    String value = (String)entry.getValue();
                    if (value.toLowerCase().endsWith(".jpg") || value.toLowerCase().endsWith(".png")) {
                        int lastIndexOf = value.lastIndexOf("media");
                        value = value.substring(lastIndexOf);
                    }
                    if (value.length() > 253) {
                        pm.errorMessage("Need to trim value: " + value);
                        value = value.substring(0, 252);
                    }
                    values[var25_26] = value;
                    ++var25_26;
                }
                builderAndCollectionPair.builder.addAll(values);
                SimpleFeature feature = builderAndCollectionPair.builder.buildFeature(null);
                builderAndCollectionPair.collection.add(feature);
            }
            Set entrySet = forms2PropertiesMap.entrySet();
            for (Map.Entry entry : entrySet) {
                String name = (String)entry.getKey();
                DefaultFeatureCollection collection = ((BuilderAndCollectionPair)entry.getValue()).collection;
                File outFile = new File(outputFolderFile, name + ".shp");
                this.dumpVector((SimpleFeatureCollection)collection, outFile.getAbsolutePath());
            }
        }
        finally {
            pm.done();
            if (statement != null) {
                statement.close();
            }
        }
    }

    private void gpsLogToShapefiles(Connection connection, File outputFolderFile, IHMProgressMonitor pm) throws Exception {
        SimpleFeatureBuilder builder;
        SimpleFeatureType featureType;
        SimpleFeatureTypeBuilder b;
        Statement statement = connection.createStatement();
        statement.setQueryTimeout(30);
        ArrayList<GpsLog> logsList = new ArrayList<GpsLog>();
        ResultSet rs = statement.executeQuery("select _id, startts, endts, text from gpslogs");
        while (rs.next()) {
            long id = rs.getLong("_id");
            String startDateTimeString = rs.getString("startts");
            String endDateTimeString = rs.getString("endts");
            String string = rs.getString("text");
            GpsLog log = new GpsLog();
            log.id = id;
            log.startTime = startDateTimeString;
            log.endTime = endDateTimeString;
            log.text = string;
            logsList.add(log);
        }
        statement.close();
        try {
            for (GpsLog log : logsList) {
                long logId = log.id;
                String string = "select lat, lon, altim, ts from gpslog_data where logid = " + logId + " order by ts";
                Statement newStatement = connection.createStatement();
                newStatement.setQueryTimeout(30);
                ResultSet result = newStatement.executeQuery(string);
                while (result.next()) {
                    double lat = result.getDouble("lat");
                    double lon = result.getDouble("lon");
                    double altim = result.getDouble("altim");
                    String dateTimeString = result.getString("ts");
                    GpsPoint gPoint = new GpsPoint();
                    gPoint.lon = lon;
                    gPoint.lat = lat;
                    gPoint.altim = altim;
                    gPoint.utctime = dateTimeString;
                    log.points.add(gPoint);
                }
                newStatement.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ModelsRuntimeException("An error occurred while reading the gps logs.", this);
        }
        if (this.doLoglines) {
            b = new SimpleFeatureTypeBuilder();
            b.setName("geopaparazzinotes");
            b.setCRS((CoordinateReferenceSystem)this.crs);
            b.add("the_geom", MultiLineString.class);
            b.add("STARTDATE", String.class);
            b.add("ENDDATE", String.class);
            b.add("DESCR", String.class);
            featureType = b.buildFeatureType();
            pm.beginTask("Import gps to lines...", logsList.size());
            DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
            for (GpsLog gpsLog : logsList) {
                List<GpsPoint> points = gpsLog.points;
                ArrayList<Coordinate> coordList = new ArrayList<Coordinate>();
                String startDate = gpsLog.startTime;
                String endDate = gpsLog.endTime;
                for (GpsPoint gpsPoint : points) {
                    Coordinate c = new Coordinate(gpsPoint.lon, gpsPoint.lat);
                    coordList.add(c);
                }
                Coordinate[] coordArray = coordList.toArray(new Coordinate[coordList.size()]);
                if (coordArray.length < 2) continue;
                LineString lineString = this.gf.createLineString(coordArray);
                MultiLineString multiLineString = this.gf.createMultiLineString(new LineString[]{lineString});
                builder = new SimpleFeatureBuilder(featureType);
                Object[] values = new Object[]{multiLineString, startDate, endDate, gpsLog.text};
                builder.addAll(values);
                SimpleFeature feature = builder.buildFeature(null);
                newCollection.add(feature);
                pm.worked(1);
            }
            pm.done();
            File outputLinesShapeFile = new File(outputFolderFile, "gpslines.shp");
            this.dumpVector((SimpleFeatureCollection)newCollection, outputLinesShapeFile.getAbsolutePath());
        }
        if (this.doLogpoints) {
            b = new SimpleFeatureTypeBuilder();
            b.setName("geopaparazzinotes");
            b.setCRS((CoordinateReferenceSystem)this.crs);
            b.add("the_geom", Point.class);
            b.add("ALTIMETRY", String.class);
            b.add("DATE", String.class);
            featureType = b.buildFeatureType();
            pm.beginTask("Import gps to points...", logsList.size());
            DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
            int index = 0;
            for (GpsLog log : logsList) {
                List<GpsPoint> gpsPointList = log.points;
                for (GpsPoint gpsPoint : gpsPointList) {
                    Coordinate c = new Coordinate(gpsPoint.lon, gpsPoint.lat);
                    Point point = this.gf.createPoint(c);
                    Object[] values = new Object[]{point, String.valueOf(gpsPoint.altim), gpsPoint.utctime};
                    builder = new SimpleFeatureBuilder(featureType);
                    builder.addAll(values);
                    SimpleFeature feature = builder.buildFeature(featureType.getTypeName() + "." + index++);
                    newCollection.add(feature);
                }
                pm.worked(1);
            }
            pm.done();
            File file = new File(outputFolderFile, "gpspoints.shp");
            this.dumpVector((SimpleFeatureCollection)newCollection, file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mediaToShapeFile(File geopapFolderFile, File outputFolderFile, IHMProgressMonitor pm) throws Exception {
        File folder = new File(geopapFolderFile, "media");
        if (!folder.exists() && !(folder = new File(geopapFolderFile, "pictures")).exists()) {
            return;
        }
        String imageFolderName = "media";
        File[] listFiles = folder.listFiles();
        if (listFiles == null) {
            listFiles = new File[]{};
        }
        ArrayList<String> nonTakenFilesList = new ArrayList<String>();
        pm.beginTask("Importing media...", listFiles.length);
        try {
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName("geopaparazzinotes");
            b.setCRS((CoordinateReferenceSystem)this.crs);
            b.add("the_geom", Point.class);
            b.add("ALTIMETRY", String.class);
            b.add("DATE", String.class);
            b.add("AZIMUTH", Double.class);
            b.add("IMAGE", String.class);
            SimpleFeatureType featureType = b.buildFeatureType();
            DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
            for (File imageFile : listFiles) {
                String name = imageFile.getName();
                if (name.endsWith("jpg") || imageFile.getName().endsWith("JPG") || imageFile.getName().endsWith("png") || imageFile.getName().endsWith("PNG") || imageFile.getName().endsWith("3gp")) {
                    double lon;
                    double lat;
                    int lastDot;
                    String[] nameSplit = name.split("[_//|.]");
                    String dateString = nameSplit[1];
                    String timeString = nameSplit[2];
                    Properties locationProperties = new Properties();
                    String mediaPath = imageFile.getAbsolutePath();
                    String nameNoExt = mediaPath.substring(0, lastDot = mediaPath.lastIndexOf("."));
                    String infoPath = nameNoExt + ".properties";
                    File infoFile = new File(infoPath);
                    if (!infoFile.exists()) {
                        nonTakenFilesList.add(mediaPath);
                        continue;
                    }
                    locationProperties.load(new FileInputStream(infoFile));
                    String azimuthString = locationProperties.getProperty("azimuth");
                    String latString = locationProperties.getProperty("latitude");
                    String lonString = locationProperties.getProperty("longitude");
                    String altimString = locationProperties.getProperty("altim");
                    Double azimuth = -9999.0;
                    if (azimuthString != null) {
                        azimuth = Double.parseDouble(azimuthString);
                    }
                    if (latString.contains("/")) {
                        lat = OmsGeopaparazzi3Converter.exifFormat2degreeDecimal(latString);
                        lon = OmsGeopaparazzi3Converter.exifFormat2degreeDecimal(lonString);
                    } else {
                        lat = Double.parseDouble(latString);
                        lon = Double.parseDouble(lonString);
                    }
                    double altim = Double.parseDouble(altimString);
                    Coordinate c = new Coordinate(lon, lat);
                    Point point = this.gf.createPoint(c);
                    String imageRelativePath = imageFolderName + "/" + imageFile.getName();
                    File newImageFile = new File(outputFolderFile, imageRelativePath);
                    if (!newImageFile.getParentFile().exists()) {
                        newImageFile.getParentFile().mkdir();
                    }
                    if (!newImageFile.exists()) {
                        FileUtilities.copyFile(imageFile, newImageFile);
                    }
                    String dateTime = dateString + timeString;
                    Object[] values = new Object[]{point, String.valueOf(altim), dateTime, azimuth, imageRelativePath};
                    SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
                    builder.addAll(values);
                    SimpleFeature feature = builder.buildFeature(null);
                    newCollection.add(feature);
                }
                pm.worked(1);
            }
            File outputPointsShapeFile = new File(outputFolderFile, "mediapoints.shp");
            this.dumpVector((SimpleFeatureCollection)newCollection, outputPointsShapeFile.getAbsolutePath());
        }
        finally {
            pm.done();
        }
        if (nonTakenFilesList.size() > 0) {
            StringBuilder sB = new StringBuilder();
            sB.append("For the following media no *.properties file could be found:/n");
            for (String p : nonTakenFilesList) {
                sB.append(p).append("/n");
            }
            pm.errorMessage(sB.toString());
        } else {
            pm.message("All media were successfully imported.");
        }
    }

    public static double exifFormat2degreeDecimal(String exifFormat) {
        String[] exifSplit = exifFormat.trim().split(",");
        String[] value = exifSplit[0].split("/");
        double tmp1 = Double.parseDouble(value[0]);
        double tmp2 = Double.parseDouble(value[1]);
        double degree = tmp1 / tmp2;
        value = exifSplit[1].split("/");
        tmp1 = Double.parseDouble(value[0]);
        tmp2 = Double.parseDouble(value[1]);
        double minutes = tmp1 / tmp2;
        value = exifSplit[2].split("/");
        tmp1 = Double.parseDouble(value[0]);
        tmp2 = Double.parseDouble(value[1]);
        double seconds = tmp1 / tmp2;
        double result = degree + minutes / 60.0 + seconds / 3600.0;
        return result;
    }

    static {
        try {
            Class.forName("org.sqlite.JDBC");
            hasDriver = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class GpsLog {
        public long id;
        public String startTime;
        public String endTime;
        public String text;
        public List<GpsPoint> points = new ArrayList<GpsPoint>();

        private GpsLog() {
        }
    }

    private static class GpsPoint {
        public double lat;
        public double lon;
        public double altim;
        public String utctime;

        private GpsPoint() {
        }
    }

    private static class BuilderAndCollectionPair {
        SimpleFeatureBuilder builder;
        DefaultFeatureCollection collection;

        private BuilderAndCollectionPair() {
        }
    }
}

