/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.geopaparazzi;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hortonmachine.dbs.compat.IHMConnection;
import org.hortonmachine.dbs.compat.IHMResultSet;
import org.hortonmachine.dbs.compat.IHMStatement;
import org.hortonmachine.dbs.spatialite.hm.SqliteDb;
import org.hortonmachine.gears.io.geopaparazzi.GeopaparazziUtilities;
import org.hortonmachine.gears.io.geopaparazzi.forms.Utilities;
import org.hortonmachine.gears.io.geopaparazzi.geopap4.DaoGpsLog;
import org.hortonmachine.gears.io.geopaparazzi.geopap4.DaoImages;
import org.hortonmachine.gears.io.geopaparazzi.geopap4.ETimeUtilities;
import org.hortonmachine.gears.io.geopaparazzi.geopap4.Image;
import org.hortonmachine.gears.io.geopaparazzi.geopap4.TableDescriptions;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.exceptions.ModelsRuntimeException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.utils.StringUtilities;
import org.hortonmachine.gears.utils.chart.Scatter;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.json.JSONObject;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Converts a geopaparazzi 4 project database into shapefiles.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="geopaparazzi, vector")
@Label(value="Mobile")
@Name(value="_geopapconvert_v4")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsGeopaparazzi4Converter
extends HMModel {
    @Description(value="The geopaparazzi database file (*.gpap).")
    @UI(value="infile_gpap")
    @In
    public String inGeopaparazzi = null;
    @Description(value="Flag to create notes")
    @In
    public boolean doNotes = true;
    @Description(value="Flag to create log lines")
    @In
    public boolean doLoglines = true;
    @Description(value="Flag to create log points")
    @In
    public boolean doLogpoints = false;
    @Description(value="Flag to create media points")
    @In
    public boolean doMedia = true;
    @Description(value="The output folder")
    @UI(value="outfolder")
    @In
    public String outFolder = null;
    public static final String THE_GEOPAPARAZZI_DATABASE_FILE = "The geopaparazzi database file (*.gpap).";
    public static final String DESCRIPTION = "Converts a geopaparazzi 4 project database into shapefiles.";
    public static final String OMSGEOPAPARAZZICONVERTER_LABEL = "Vector Processing";
    public static final String OMSGEOPAPARAZZICONVERTER_TAGS = "geopaparazzi, vector";
    public static final String OMSGEOPAPARAZZICONVERTER_NAME = "geopapconvert";
    public static final String OMSGEOPAPARAZZICONVERTER_OUT_DATA_DESCRIPTION = "The output folder";
    public static final String OMSGEOPAPARAZZICONVERTER_DO_BOOKMARKS_DESCRIPTION = "Flag to create bookmarks points";
    public static final String OMSGEOPAPARAZZICONVERTER_DO_MEDIA_DESCRIPTION = "Flag to create media points";
    public static final String OMSGEOPAPARAZZICONVERTER_DO_LOG_POINTS_DESCRIPTION = "Flag to create log points";
    public static final String OMSGEOPAPARAZZICONVERTER_DO_LOG_LINES_DESCRIPTION = "Flag to create log lines";
    public static final String OMSGEOPAPARAZZICONVERTER_DO_NOTES_DESCRIPTION = "Flag to create notes";
    public static final String OMSGEOPAPARAZZICONVERTER_IN_GEOPAPARAZZI_DESCRIPTION = "The geopaparazzi folder";
    public static final String EMPTY_STRING = " - ";
    public static final String MEDIA_FOLDER_NAME = "media";
    public static final String CHARTS_FOLDER_NAME = "charts";
    private File chartsFolderFile;
    private static final GeometryFactory gf = GeometryUtilities.gf();
    private static final String idFN = TableDescriptions.NotesTableFields.COLUMN_ID.getFieldName();
    private static final String tsFN = TableDescriptions.NotesTableFields.COLUMN_TS.getFieldName();
    private static final String altimFN = TableDescriptions.NotesTableFields.COLUMN_ALTIM.getFieldName();
    private static final String dirtyFN = TableDescriptions.NotesTableFields.COLUMN_ISDIRTY.getFieldName();
    private static final String formFN = TableDescriptions.NotesTableFields.COLUMN_FORM.getFieldName();
    private static final String latFN = TableDescriptions.NotesTableFields.COLUMN_LAT.getFieldName();
    private static final String lonFN = TableDescriptions.NotesTableFields.COLUMN_LON.getFieldName();
    private static final String textFN = TableDescriptions.NotesTableFields.COLUMN_TEXT.getFieldName();
    private static final String descFN = TableDescriptions.NotesTableFields.COLUMN_DESCRIPTION.getFieldName();

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inGeopaparazzi);
        File geopapDatabaseFile = new File(this.inGeopaparazzi);
        if (!geopapDatabaseFile.exists()) {
            throw new ModelsIllegalargumentException("The geopaparazzi database file (*.gpap) is missing. Check the inserted path.", this, this.pm);
        }
        File outputFolderFile = new File(this.outFolder);
        if (!outputFolderFile.exists()) {
            outputFolderFile.mkdirs();
        }
        File mediaFolderFile = new File(outputFolderFile, MEDIA_FOLDER_NAME);
        mediaFolderFile.mkdir();
        this.chartsFolderFile = new File(outputFolderFile, CHARTS_FOLDER_NAME);
        this.chartsFolderFile.mkdir();
        try (SqliteDb db = new SqliteDb();){
            db.open(geopapDatabaseFile.getAbsolutePath());
            boolean hasMetadata = db.hasTable("metadata");
            db.execOnConnection(connection -> {
                if (hasMetadata) {
                    this.projectInfo(connection, outputFolderFile);
                }
                if (this.doNotes) {
                    this.simpleNotesToShapefile(connection, outputFolderFile, this.pm);
                    this.complexNotesToShapefile(connection, outputFolderFile, this.pm);
                }
                this.gpsLogToShapefiles(connection, outputFolderFile, this.pm);
                this.mediaToShapeFile(connection, mediaFolderFile, this.pm);
                return null;
            });
        }
    }

    private void projectInfo(IHMConnection connection, File outputFolderFile) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("PROJECT INFO\n");
        sb.append("----------------------\n\n");
        LinkedHashMap<String, String> metadataMap = GeopaparazziUtilities.getProjectMetadata(connection);
        if (metadataMap == null || metadataMap.size() == 0) {
            return;
        }
        for (Map.Entry<String, String> entry : metadataMap.entrySet()) {
            sb.append(entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
        }
        FileUtilities.writeFile(sb.toString(), new File(outputFolderFile, "project_info.txt"));
    }

    private void simpleNotesToShapefile(IHMConnection connection, File outputFolderFile, IHMProgressMonitor pm) throws Exception {
        File outputShapeFile = new File(outputFolderFile, "notes_simple.shp");
        SimpleFeatureCollection newCollection = OmsGeopaparazzi4Converter.simpleNotes2featurecollection(connection, pm);
        this.dumpVector(newCollection, outputShapeFile.getAbsolutePath());
    }

    private void complexNotesToShapefile(IHMConnection connection, File outputFolderFile, IHMProgressMonitor pm) throws Exception {
        HashMap<String, SimpleFeatureCollection> name2CollectionMap = OmsGeopaparazzi4Converter.complexNotes2featurecollections(connection, pm);
        pm.beginTask("Writing layers to shapefile...", name2CollectionMap.size());
        Set<Map.Entry<String, SimpleFeatureCollection>> entrySet2 = name2CollectionMap.entrySet();
        for (Map.Entry<String, SimpleFeatureCollection> entry : entrySet2) {
            String name = entry.getKey();
            int lastUnderscore = name.lastIndexOf(95);
            name = name.substring(0, lastUnderscore);
            SimpleFeatureCollection collection = entry.getValue();
            Object fileName = "notes_" + name + ".shp";
            File outFile = new File(outputFolderFile, (String)(fileName = FileUtilities.getSafeFileName((String)fileName)));
            if (outFile.exists()) {
                File[] listFiles = outputFolderFile.listFiles();
                ArrayList<String> fileNames = new ArrayList<String>();
                for (File file : listFiles) {
                    fileNames.add(FileUtilities.getNameWithoutExtention(file));
                }
                String shpName = FileUtilities.getNameWithoutExtention(outFile);
                String safeShpName = StringUtilities.checkSameName(fileNames, shpName);
                outFile = new File(outputFolderFile, safeShpName + ".shp");
            }
            this.dumpVector(collection, outFile.getAbsolutePath());
            pm.worked(1);
        }
        pm.done();
    }

    public static SimpleFeatureCollection simpleNotes2featurecollection(IHMConnection connection, IHMProgressMonitor pm) throws Exception {
        SimpleFeatureType featureType = GeopaparazziUtilities.getSimpleNotesfeatureType();
        String sql = "select " + latFN + "," + lonFN + "," + altimFN + "," + tsFN + "," + textFN + "," + descFN + "," + dirtyFN + "," + formFN + " from notes where " + formFN + " is null or " + formFN + " = ''";
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
        pm.beginTask("Processing notes...", -1);
        DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
        try (IHMStatement statement = connection.createStatement();
             IHMResultSet rs = statement.executeQuery(sql);){
            while (rs.next()) {
                String form = rs.getString(formFN);
                if (form != null && form.trim().length() != 0) continue;
                double lat = rs.getDouble(latFN);
                double lon = rs.getDouble(lonFN);
                double altim = rs.getDouble(altimFN);
                long ts = rs.getLong(tsFN);
                String dateTimeString = ETimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(ts));
                String text = rs.getString(textFN);
                String descr = rs.getString(descFN);
                if (descr == null) {
                    descr = EMPTY_STRING;
                }
                int isDirty = rs.getInt(dirtyFN);
                if (lat == 0.0 || lon == 0.0) continue;
                Coordinate c = new Coordinate(lon, lat);
                Point point = gf.createPoint(c);
                Object[] values = new Object[]{point, text, descr, dateTimeString, altim, isDirty};
                builder.addAll(values);
                SimpleFeature feature = builder.buildFeature(null);
                newCollection.add(feature);
            }
        }
        return newCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, SimpleFeatureCollection> complexNotes2featurecollections(IHMConnection connection, IHMProgressMonitor pm) throws Exception {
        pm.beginTask("Import complex notes...", -1);
        HashMap<String, BuilderAndCollectionPair> forms2PropertiesMap = new HashMap<String, BuilderAndCollectionPair>();
        HashMap<String, SimpleFeatureCollection> name2CollectionMap = new HashMap<String, SimpleFeatureCollection>();
        String sql = "select " + idFN + "," + latFN + "," + lonFN + "," + altimFN + "," + tsFN + "," + dirtyFN + "," + formFN + " from notes where " + formFN + " is not null and " + formFN + " != ''";
        try (IHMStatement statement = connection.createStatement();
             IHMResultSet rs = statement.executeQuery(sql);){
            statement.setQueryTimeout(30);
            while (rs.next()) {
                String idString = rs.getString(idFN);
                System.out.println(idString);
                String formString = rs.getString(formFN);
                if (formString == null || formString.trim().length() == 0) continue;
                double lat = rs.getDouble(latFN);
                double lon = rs.getDouble(lonFN);
                double altim = rs.getDouble(altimFN);
                long ts = rs.getLong(tsFN);
                String dateTimeString = ETimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(ts));
                int isDirty = rs.getInt(dirtyFN);
                if (lat == 0.0 || lon == 0.0) continue;
                Coordinate c = new Coordinate(lon, lat);
                Point point = gf.createPoint(c);
                JSONObject sectionObject = new JSONObject(formString);
                String sectionName = sectionObject.getString("sectionname");
                sectionName = sectionName.replaceAll("\\s+", "_");
                List<String> formNames4Section = Utilities.getFormNames4Section(sectionObject);
                LinkedHashMap<String, String> valuesMap = new LinkedHashMap<String, String>();
                LinkedHashMap<String, String> typesMap = new LinkedHashMap<String, String>();
                GeopaparazziUtilities.extractValues(sectionObject, formNames4Section, valuesMap, typesMap);
                Set<Map.Entry<String, String>> entrySet = valuesMap.entrySet();
                TreeMap<String, Integer> namesMap = new TreeMap<String, Integer>();
                String uniqueSectionName = sectionName + "_" + entrySet.size();
                BuilderAndCollectionPair builderAndCollectionPair = OmsGeopaparazzi4Converter.getBuilderAndCollectionPair(pm, forms2PropertiesMap, sectionName, entrySet, typesMap, namesMap, uniqueSectionName);
                int size = entrySet.size();
                Object[] values = new Object[size + 4];
                values[0] = point;
                values[1] = dateTimeString;
                values[2] = altim;
                values[3] = isDirty;
                int i = 4;
                for (Map.Entry<String, String> entry : entrySet) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    String type = typesMap.get(key);
                    if (Utilities.isMediaType(type)) {
                        String[] imageSplit = value.split(";");
                        StringBuilder sb = new StringBuilder();
                        for (String image : imageSplit) {
                            if ((image = image.trim()).length() == 0) continue;
                            long imageId = Long.parseLong(image);
                            String imageName = DaoImages.getImageName(connection, imageId);
                            sb.append(";");
                            sb.append("media/").append(imageName);
                        }
                        value = sb.length() > 0 ? sb.substring(1) : "";
                    }
                    if (value.length() > 253) {
                        pm.errorMessage("Need to trim value: " + value);
                        value = value.substring(0, 252);
                    }
                    values[i] = value;
                    ++i;
                }
                try {
                    builderAndCollectionPair.builder.addAll(values);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SimpleFeature feature = builderAndCollectionPair.builder.buildFeature(null);
                builderAndCollectionPair.collection.add(feature);
            }
            Set entrySet = forms2PropertiesMap.entrySet();
            for (Map.Entry entry : entrySet) {
                String name = (String)entry.getKey();
                DefaultFeatureCollection collection = ((BuilderAndCollectionPair)entry.getValue()).collection;
                name2CollectionMap.put(name, (SimpleFeatureCollection)collection);
            }
        }
        finally {
            pm.done();
        }
        return name2CollectionMap;
    }

    private static BuilderAndCollectionPair getBuilderAndCollectionPair(IHMProgressMonitor pm, HashMap<String, BuilderAndCollectionPair> forms2PropertiesMap, String sectionName, Set<Map.Entry<String, String>> entrySet, LinkedHashMap<String, String> typesMap, TreeMap<String, Integer> namesMap, String uniqueSectionName) {
        BuilderAndCollectionPair builderAndCollectionPair = forms2PropertiesMap.get(uniqueSectionName);
        if (builderAndCollectionPair == null) {
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName(sectionName);
            b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            b.add("the_geom", Point.class);
            b.add(tsFN, String.class);
            b.add(altimFN, Double.class);
            b.add(dirtyFN, Integer.class);
            for (Map.Entry<String, String> entry : entrySet) {
                Integer nCount;
                Object key = entry.getKey();
                String typeStr = typesMap.get(key);
                if (((String)(key = ((String)key).replaceAll("\\s+", "_"))).length() > 10) {
                    pm.errorMessage("Need to trim key: " + (String)key);
                    key = ((String)key).substring(0, 10);
                }
                if ((nCount = namesMap.get(key)) == null) {
                    nCount = 1;
                    namesMap.put((String)key, 1);
                } else {
                    Integer n = nCount;
                    Integer n2 = nCount = Integer.valueOf(nCount + 1);
                    namesMap.put((String)key, nCount);
                    key = nCount < 10 ? ((String)key).substring(0, ((String)key).length() - 1) + nCount : ((String)key).substring(0, ((String)key).length() - 2) + nCount;
                }
                Class clazz = String.class;
                if (Utilities.isStringType(typeStr)) {
                    clazz = String.class;
                } else if (Utilities.isIntegerType(typeStr)) {
                    clazz = Integer.class;
                } else if (Utilities.isDoubleType(typeStr)) {
                    clazz = Double.class;
                }
                b.add((String)key, clazz);
            }
            SimpleFeatureType featureType = b.buildFeatureType();
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
            DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
            builderAndCollectionPair = new BuilderAndCollectionPair();
            builderAndCollectionPair.builder = builder;
            builderAndCollectionPair.collection = newCollection;
            forms2PropertiesMap.put(uniqueSectionName, builderAndCollectionPair);
        }
        return builderAndCollectionPair;
    }

    /*
     * Exception decompiling
     */
    public static SimpleFeatureCollection complexNote2featurecollection(String noteName, IHMConnection connection, IHMProgressMonitor pm) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<DaoGpsLog.GpsLog> getGpsLogsList(IHMConnection connection) throws Exception {
        List<DaoGpsLog.GpsLog> logsList = DaoGpsLog.getLogsList(connection);
        try {
            for (DaoGpsLog.GpsLog log : logsList) {
                DaoGpsLog.collectDataForLog(connection, log);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ModelsRuntimeException("An error occurred while reading the gps logs.", OmsGeopaparazzi4Converter.class.getSimpleName());
        }
        return logsList;
    }

    public static DefaultFeatureCollection getLogLinesFeatureCollection(IHMProgressMonitor pm, List<DaoGpsLog.GpsLog> logsList) {
        GeometryFactory gf = GeometryUtilities.gf();
        SimpleFeatureType featureType = GeopaparazziUtilities.getGpsLogLinesFeatureType();
        pm.beginTask("Import gps to lines...", logsList.size());
        DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
        for (DaoGpsLog.GpsLog log : logsList) {
            List<DaoGpsLog.GpsPoint> points = log.points;
            ArrayList<Coordinate> coordList = new ArrayList<Coordinate>();
            String startDate = ETimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(log.startTime));
            String endDate = ETimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(log.endTime));
            for (DaoGpsLog.GpsPoint gpsPoint : points) {
                Coordinate c = new Coordinate(gpsPoint.lon, gpsPoint.lat);
                coordList.add(c);
            }
            Coordinate[] coordArray = coordList.toArray(new Coordinate[coordList.size()]);
            if (coordArray.length < 2) continue;
            LineString lineString = gf.createLineString(coordArray);
            MultiLineString multiLineString = gf.createMultiLineString(new LineString[]{lineString});
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
            Object[] values = new Object[]{multiLineString, startDate, endDate, log.text};
            builder.addAll(values);
            SimpleFeature feature = builder.buildFeature(null);
            newCollection.add(feature);
            pm.worked(1);
        }
        pm.done();
        return newCollection;
    }

    public static void populateProfilesForSingleLog(DaoGpsLog.GpsLog log, int size, double[] xProfile, double[] yProfile, double[] xPlanim, double[] yPlanim, long[] timestampArray) {
        GeodeticCalculator gc = new GeodeticCalculator((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        double runningDistance = 0.0;
        for (int i = 0; i < size - 1; ++i) {
            DaoGpsLog.GpsPoint p1 = log.points.get(i);
            DaoGpsLog.GpsPoint p2 = log.points.get(i + 1);
            double lon1 = p1.lon;
            double lat1 = p1.lat;
            double altim1 = p1.altim;
            long utc1 = p1.utctime;
            double lon2 = p2.lon;
            double lat2 = p2.lat;
            double altim2 = p2.altim;
            long utc2 = p2.utctime;
            gc.setStartingGeographicPoint(lon1, lat1);
            gc.setDestinationGeographicPoint(lon2, lat2);
            double distance = gc.getOrthodromicDistance();
            runningDistance += distance;
            if (i == 0) {
                xProfile[i] = 0.0;
                yProfile[i] = altim1;
                xPlanim[i] = lon1;
                yPlanim[i] = lat1;
                timestampArray[i] = utc1;
            }
            xProfile[i + 1] = runningDistance;
            yProfile[i + 1] = altim2;
            xPlanim[i + 1] = lon2;
            yPlanim[i + 1] = lat2;
            timestampArray[i + 1] = utc2;
        }
    }

    private void gpsLogToShapefiles(IHMConnection connection, File outputFolderFile, IHMProgressMonitor pm) throws Exception {
        DefaultFeatureCollection newCollection;
        List<DaoGpsLog.GpsLog> logsList = OmsGeopaparazzi4Converter.getGpsLogsList(connection);
        if (this.doLoglines) {
            newCollection = OmsGeopaparazzi4Converter.getLogLinesFeatureCollection(pm, logsList);
            File outputLinesShapeFile = new File(outputFolderFile, "gpslines.shp");
            this.dumpVector((SimpleFeatureCollection)newCollection, outputLinesShapeFile.getAbsolutePath());
        }
        if (this.doLogpoints) {
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName("geopaparazzinotes");
            b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            b.add("the_geom", Point.class);
            b.add("ALTIMETRY", Double.class);
            b.add("DATE", String.class);
            SimpleFeatureType featureType = b.buildFeatureType();
            pm.beginTask("Import gps to points...", logsList.size());
            newCollection = new DefaultFeatureCollection();
            int index = 0;
            for (DaoGpsLog.GpsLog log : logsList) {
                List<DaoGpsLog.GpsPoint> gpsPointList = log.points;
                for (DaoGpsLog.GpsPoint gpsPoint : gpsPointList) {
                    Coordinate c = new Coordinate(gpsPoint.lon, gpsPoint.lat);
                    Point point = gf.createPoint(c);
                    String ts = ETimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(gpsPoint.utctime));
                    Object[] values = new Object[]{point, gpsPoint.altim, ts};
                    SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
                    builder.addAll(values);
                    SimpleFeature feature = builder.buildFeature(featureType.getTypeName() + "." + index++);
                    newCollection.add(feature);
                }
                pm.worked(1);
            }
            pm.done();
            File outputPointsShapeFile = new File(outputFolderFile, "gpspoints.shp");
            this.dumpVector((SimpleFeatureCollection)newCollection, outputPointsShapeFile.getAbsolutePath());
        }
        if (this.doLoglines) {
            pm.beginTask("Create log charts...", logsList.size());
            for (DaoGpsLog.GpsLog log : logsList) {
                String logName = log.text;
                int size = log.points.size();
                pm.message("Processing log: " + logName + " with " + size + " points.");
                String fileName = FileUtilities.getSafeFileName(logName);
                File profileFile = new File(this.chartsFolderFile, fileName + "_profile.png");
                File planimetricFile = new File(this.chartsFolderFile, fileName + "_planimetric.png");
                File csvFile = new File(this.chartsFolderFile, fileName + ".csv");
                double[] xProfile = new double[size];
                double[] yProfile = new double[size];
                double[] xPlanim = new double[size];
                double[] yPlanim = new double[size];
                long[] timestampArray = new long[size];
                OmsGeopaparazzi4Converter.populateProfilesForSingleLog(log, size, xProfile, yProfile, xPlanim, yPlanim, timestampArray);
                Scatter scatterProfile = new Scatter("Profile " + logName);
                scatterProfile.addSeries("profile", xProfile, yProfile);
                scatterProfile.setShowLines(Arrays.asList(true));
                scatterProfile.setXLabel("progressive distance [m]");
                scatterProfile.setYLabel("elevation [m]");
                BufferedImage imageProfile = scatterProfile.getImage(1000, 800);
                ImageIO.write((RenderedImage)imageProfile, "png", profileFile);
                Scatter scatterPlanim = new Scatter("Planimetry " + logName);
                scatterPlanim.addSeries("planimetry", xPlanim, yPlanim);
                scatterPlanim.setShowLines(Arrays.asList(false));
                scatterPlanim.setXLabel("longitude");
                scatterPlanim.setYLabel("latitude");
                BufferedImage imagePlanim = scatterPlanim.getImage(1000, 800);
                ImageIO.write((RenderedImage)imagePlanim, "png", planimetricFile);
                StringBuilder csvBuilder = new StringBuilder();
                csvBuilder.append("#x,y,progressive,elevation,utctimestamp\n");
                for (int j = 0; j < timestampArray.length; ++j) {
                    Object line = String.valueOf(xPlanim[j]).replace(',', '.');
                    line = (String)line + "," + String.valueOf(yPlanim[j]).replace(',', '.');
                    line = (String)line + "," + String.valueOf(xProfile[j]).replace(',', '.');
                    line = (String)line + "," + String.valueOf(yProfile[j]).replace(',', '.');
                    line = (String)line + "," + timestampArray[j] + "\n";
                    csvBuilder.append((String)line);
                }
                FileUtilities.writeFile(csvBuilder.toString(), csvFile);
                pm.worked(1);
            }
            pm.done();
        }
    }

    private void mediaToShapeFile(IHMConnection connection, File mediaFolderFile, IHMProgressMonitor pm) throws Exception {
        SimpleFeatureCollection newCollection = OmsGeopaparazzi4Converter.media2FeatureCollection(connection, mediaFolderFile, pm);
        File outputPointsShapeFile = new File(mediaFolderFile.getParentFile(), "mediapoints.shp");
        this.dumpVector(newCollection, outputPointsShapeFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleFeatureCollection media2FeatureCollection(IHMConnection connection, File mediaFolderFile, IHMProgressMonitor pm) throws Exception, IOException, FileNotFoundException {
        DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
        try {
            GeometryFactory gf = GeometryUtilities.gf();
            newCollection = new DefaultFeatureCollection();
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName("geopaparazzimediapoints");
            b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            b.add("the_geom", Point.class);
            String altimFN = TableDescriptions.ImageTableFields.COLUMN_ALTIM.getFieldName();
            String tsFN = TableDescriptions.ImageTableFields.COLUMN_TS.getFieldName();
            String azimFN = TableDescriptions.ImageTableFields.COLUMN_AZIM.getFieldName();
            String imageNameFN = TableDescriptions.ImageTableFields.COLUMN_TEXT.getFieldName();
            b.add(altimFN, String.class);
            b.add(tsFN, String.class);
            b.add(azimFN, Double.class);
            b.add(imageNameFN, String.class);
            SimpleFeatureType featureType = b.buildFeatureType();
            List<Image> imagesList = DaoImages.getImagesList(connection);
            pm.beginTask("Importing media...", imagesList.size());
            for (Image image : imagesList) {
                File newImageFile = new File(mediaFolderFile, image.getName());
                byte[] imageData = DaoImages.getImageData(connection, image.getImageDataId());
                try (FileOutputStream outStream = new FileOutputStream(newImageFile);){
                    ((OutputStream)outStream).write(imageData);
                }
                Point point = gf.createPoint(new Coordinate(image.getLon(), image.getLat()));
                long ts = image.getTs();
                String dateTimeString = ETimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(ts));
                String imageRelativePath = mediaFolderFile.getName() + "/" + image.getName();
                Object[] values = new Object[]{point, image.getAltim(), dateTimeString, image.getAzim(), imageRelativePath};
                SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
                builder.addAll(values);
                SimpleFeature feature = builder.buildFeature(null);
                newCollection.add(feature);
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
        return newCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleFeatureCollection media2IdBasedFeatureCollection(IHMConnection connection, IHMProgressMonitor pm) throws Exception, IOException, FileNotFoundException {
        try {
            GeometryFactory gf = GeometryUtilities.gf();
            DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
            SimpleFeatureType featureType = GeopaparazziUtilities.getMediaFeaturetype();
            List<Image> imagesList = DaoImages.getImagesList(connection);
            pm.beginTask("Importing media...", imagesList.size());
            for (Image image : imagesList) {
                Point point = gf.createPoint(new Coordinate(image.getLon(), image.getLat()));
                long ts = image.getTs();
                String dateTimeString = ETimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(ts));
                Object[] values = new Object[]{point, image.getAltim(), dateTimeString, image.getAzim(), image.getImageDataId()};
                SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
                builder.addAll(values);
                SimpleFeature feature = builder.buildFeature(null);
                newCollection.add(feature);
                pm.worked(1);
            }
            DefaultFeatureCollection defaultFeatureCollection = newCollection;
            return defaultFeatureCollection;
        }
        finally {
            pm.done();
        }
    }

    public static void writeImageFromId(IHMConnection connection, long imageId, File newImageFile) throws Exception {
        byte[] imageData = DaoImages.getImageData(connection, imageId);
        try (FileOutputStream outStream = new FileOutputStream(newImageFile);){
            ((OutputStream)outStream).write(imageData);
        }
    }

    private static class BuilderAndCollectionPair {
        SimpleFeatureBuilder builder;
        DefaultFeatureCollection collection;

        private BuilderAndCollectionPair() {
        }
    }
}

