/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.geopaparazzi.forms;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.hortonmachine.gears.io.geopaparazzi.forms.Form;
import org.hortonmachine.gears.io.geopaparazzi.forms.MainFrame;
import org.hortonmachine.gears.io.geopaparazzi.forms.Section;
import org.hortonmachine.gears.io.geopaparazzi.forms.items.Item;
import org.hortonmachine.gears.io.geopaparazzi.forms.items.ItemBoolean;
import org.hortonmachine.gears.io.geopaparazzi.forms.items.ItemCombo;
import org.hortonmachine.gears.io.geopaparazzi.forms.items.ItemLabel;
import org.hortonmachine.gears.io.geopaparazzi.forms.items.ItemText;
import org.hortonmachine.gears.io.geopaparazzi.forms.items.ItemTextArea;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Utilities {
    public static final String ATTR_SECTIONNAME = "sectionname";
    public static final String ATTR_SECTIONOBJECTSTR = "sectionobjectstr";
    public static final String ATTR_FORMS = "forms";
    public static final String ATTR_FORMNAME = "formname";
    public static final String TAG_LONGNAME = "longname";
    public static final String TAG_SHORTNAME = "shortname";
    public static final String TAG_FORMS = "forms";
    public static final String TAG_FORMITEMS = "formitems";
    public static final String TAG_KEY = "key";
    public static final String TAG_VALUE = "value";
    public static final String TAG_VALUES = "values";
    public static final String TAG_ITEMS = "items";
    public static final String TAG_ITEM = "item";
    public static final String TAG_TYPE = "type";
    public static final String TAG_READONLY = "readonly";
    public static final String TAG_SIZE = "size";
    public static final String TAG_URL = "url";
    public static final String TAG_LABEL = "label";
    public static final String TAG_ISLABEL = "islabel";
    public static final String TAG_ISMANDATORY = "mandatory";
    public static final String TAG_RANGE = "range";
    public static final String IMAGES_SEPARATOR = ";";
    public static final String TYPE_PICTURES = "pictures";
    public static final String TYPE_SKETCH = "sketch";
    public static final String TYPE_IMAGELIB = "imagelib";
    public static final String TYPE_MAP = "map";
    public static final String[] ITEM_NAMES = new String[]{"label", "labelwithline", "boolean", "stringcombo", "multistringcombo", "date", "time", "integer", "double", "dynamicstring", "pictures", "imagelib", "sketch", "map", "string", "connectedstringcombo", "onetomanystringcombo"};

    public static boolean isStringType(String type) {
        boolean isString = false;
        if (type.equals(TYPE_MAP) || type.equals(TYPE_SKETCH) || type.equals(TYPE_PICTURES) || type.equals(TYPE_IMAGELIB) || type.equals("stringcombo") || type.equals("multistringcombo") || type.equals("date") || type.equals("time") || type.equals("dynamicstring") || type.equals("string") || type.equals("connectedstringcombo") || type.equals("onetomanystringcombo")) {
            isString = true;
        }
        return isString;
    }

    public static boolean isIntegerType(String type) {
        boolean isInteger = false;
        if (type.equals("integer")) {
            isInteger = true;
        }
        return isInteger;
    }

    public static boolean isDoubleType(String type) {
        boolean isDouble = false;
        if (type.equals("double")) {
            isDouble = true;
        }
        return isDouble;
    }

    public static boolean isMediaType(String type) {
        boolean isMedia = false;
        if (type.equals(TYPE_MAP) || type.equals(TYPE_SKETCH) || type.equals(TYPE_PICTURES) || type.equals(TYPE_IMAGELIB)) {
            isMedia = true;
        }
        return isMedia;
    }

    public static LinkedHashMap<String, JSONObject> getSectionFromFile(String formPath) throws IOException {
        String formString = FileUtilities.readFile(formPath);
        return Utilities.getSectionsFromJsonString(formString);
    }

    public static LinkedHashMap<String, JSONObject> getSectionsFromJsonString(String formJsonString) {
        LinkedHashMap<String, JSONObject> map = new LinkedHashMap<String, JSONObject>();
        JSONArray mainArray = new JSONArray(formJsonString);
        for (int i = 0; i < mainArray.length(); ++i) {
            JSONObject sectionObject = mainArray.getJSONObject(i);
            String sectionName = sectionObject.getString(ATTR_SECTIONNAME);
            map.put(sectionName, sectionObject);
        }
        return map;
    }

    public static void properties2Mainframe(MainFrame mainFrame, File templateFile) throws Exception {
        List<String> templateLinesList = FileUtilities.readFileToLinesList(templateFile);
        String name = FileUtilities.getNameWithoutExtention(templateFile);
        Section currentSection = new Section(name);
        mainFrame.addSection(currentSection);
        Form currentForm = null;
        for (int i = 0; i < templateLinesList.size(); ++i) {
            Item item;
            String value;
            String mandatory;
            String field;
            String line = templateLinesList.get(i).trim();
            if (line.length() == 0) continue;
            if (line.startsWith("#")) {
                String title = line.substring(1).trim();
                currentForm = new Form(title);
                currentSection.addForms(currentForm);
                continue;
            }
            String[] split = line.split("\\|");
            String type = split[0].trim();
            if (type.equals("text")) {
                field = split[1].trim();
                mandatory = split[2].trim();
                value = "";
                if (split.length == 4) {
                    value = split[3].trim();
                }
                item = new ItemText(null, field, value, Boolean.parseBoolean(mandatory), false);
                currentForm.addItem(item);
                continue;
            }
            if (type.startsWith("textarea")) {
                field = split[1].trim();
                mandatory = split[2].trim();
                value = "";
                if (split.length == 4) {
                    value = split[3].trim();
                }
                item = new ItemTextArea(null, field, value, Boolean.parseBoolean(mandatory), false);
                currentForm.addItem(item);
                continue;
            }
            if (type.startsWith("combo")) {
                field = split[1].trim();
                mandatory = split[2].trim();
                value = "";
                if (split.length == 4) {
                    value = split[3].trim();
                }
                String comboItems = type.replaceFirst("combo:", "");
                String[] itemsSplit = comboItems.split(",");
                for (int j = 0; j < itemsSplit.length; ++j) {
                    itemsSplit[j] = itemsSplit[j].trim();
                }
                ItemCombo combo = new ItemCombo(null, field, itemsSplit, value, false, Boolean.parseBoolean(mandatory));
                currentForm.addItem(combo);
                continue;
            }
            if (type.equals("checkbox")) {
                field = split[1].trim();
                mandatory = split[2].trim();
                value = "false";
                if (split.length == 4) {
                    value = split[3].trim();
                }
                ItemBoolean checkbox = new ItemBoolean(null, field, value, Boolean.parseBoolean(mandatory));
                currentForm.addItem(checkbox);
                continue;
            }
            if (!type.equals(TAG_LABEL)) continue;
            String label = "";
            if (split.length > 1) {
                label = split[1].trim();
            }
            ItemLabel labelItem = new ItemLabel(label, 20, false);
            currentForm.addItem(labelItem);
        }
    }

    public static List<String> getFormNames4Section(JSONObject section) throws JSONException {
        ArrayList<String> names = new ArrayList<String>();
        JSONArray jsonArray = section.getJSONArray("forms");
        if (jsonArray != null && jsonArray.length() > 0) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (!jsonObject.has(ATTR_FORMNAME)) continue;
                String formName = jsonObject.getString(ATTR_FORMNAME);
                names.add(formName);
            }
        }
        return names;
    }

    public static JSONObject getForm4Name(String formName, JSONObject section) throws JSONException {
        JSONArray jsonArray = section.getJSONArray("forms");
        if (jsonArray != null && jsonArray.length() > 0) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                String tmpFormName;
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (!jsonObject.has(ATTR_FORMNAME) || !(tmpFormName = jsonObject.getString(ATTR_FORMNAME)).equals(formName)) continue;
                return jsonObject;
            }
        }
        return null;
    }

    public static void removeFormFromSection(String formName, JSONObject section) throws JSONException {
        JSONArray jsonArray = section.getJSONArray("forms");
        if (jsonArray != null && jsonArray.length() > 0) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                String tmpFormName;
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (!jsonObject.has(ATTR_FORMNAME) || !(tmpFormName = jsonObject.getString(ATTR_FORMNAME)).equals(formName)) continue;
                jsonArray.remove(i);
                return;
            }
        }
    }

    public static JSONArray getFormItems(JSONObject formObj) throws JSONException {
        if (formObj.has(TAG_FORMITEMS)) {
            JSONArray formItemsArray = formObj.getJSONArray(TAG_FORMITEMS);
            return formItemsArray;
        }
        return null;
    }

    public static List<String> getImageIds(String formString) throws Exception {
        ArrayList<String> imageIds = new ArrayList<String>();
        if (formString != null && formString.length() > 0) {
            JSONObject sectionObject = new JSONObject(formString);
            List<String> formsNames = Utilities.getFormNames4Section(sectionObject);
            for (String formName : formsNames) {
                JSONObject form4Name = Utilities.getForm4Name(formName, sectionObject);
                JSONArray formItems = Utilities.getFormItems(form4Name);
                for (int i = 0; i < formItems.length(); ++i) {
                    String[] imageSplit;
                    JSONObject formItem = formItems.getJSONObject(i);
                    if (!formItem.has(TAG_KEY)) continue;
                    String type = formItem.getString(TAG_TYPE);
                    String value = "";
                    if (formItem.has(TAG_VALUE)) {
                        value = formItem.getString(TAG_VALUE);
                    }
                    if (type.equals(TYPE_PICTURES) || type.equals(TYPE_IMAGELIB)) {
                        if (value.trim().length() == 0) continue;
                        imageSplit = value.split(IMAGES_SEPARATOR);
                        Collections.addAll(imageIds, imageSplit);
                        continue;
                    }
                    if (type.equals(TYPE_MAP)) {
                        if (value.trim().length() == 0) continue;
                        String image = value.trim();
                        imageIds.add(image);
                        continue;
                    }
                    if (!type.equals(TYPE_SKETCH) || value.trim().length() == 0) continue;
                    imageSplit = value.split(IMAGES_SEPARATOR);
                    Collections.addAll(imageIds, imageSplit);
                }
            }
        }
        return imageIds;
    }

    public static JSONArray formsRootFromSectionsMap(HashMap<String, JSONObject> sectionsMap) {
        JSONArray rootArray = new JSONArray();
        Collection<JSONObject> objects = sectionsMap.values();
        for (JSONObject jsonObject : objects) {
            rootArray.put((Object)jsonObject);
        }
        return rootArray;
    }
}

