/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.geopaparazzi.forms.items;

import org.hortonmachine.gears.io.geopaparazzi.forms.items.Item;

public class ItemBoolean
implements Item {
    public static final String TYPE = "boolean";
    private String description;
    private String defaultValue;
    private boolean isMandatory;
    private String key;

    public ItemBoolean(String key, String description, String defaultValue, boolean isMandatory) {
        this.key = key;
        this.isMandatory = isMandatory;
        if (defaultValue == null) {
            defaultValue = "false";
        }
        this.description = description;
        this.defaultValue = defaultValue;
        this.checkBoolean(this.defaultValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("        {\n");
        if (this.key != null && this.key.trim().length() > 0) {
            sb.append("             \"key\": \"").append(this.key).append("\",\n");
            sb.append("             \"label\": \"").append(this.description).append("\",\n");
        } else {
            sb.append("             \"key\": \"").append(this.description).append("\",\n");
        }
        sb.append("             \"value\": \"").append(this.defaultValue).append("\",\n");
        sb.append("             \"type\": \"").append(TYPE).append("\",\n");
        sb.append("             \"mandatory\": \"").append(this.isMandatory ? "yes" : "no").append("\"\n");
        sb.append("        }\n");
        return sb.toString();
    }

    @Override
    public String getKey() {
        return this.description;
    }

    @Override
    public void setValue(String value) {
        this.checkBoolean(value);
        this.defaultValue = value;
    }

    private void checkBoolean(String value) {
        if (!value.equals("false") && !value.equals("true")) {
            throw new IllegalArgumentException("Value has to be false or true.");
        }
    }

    @Override
    public String getValue() {
        return this.defaultValue;
    }
}

