/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.geopaparazzi.forms.items;

import org.hortonmachine.gears.io.geopaparazzi.forms.items.Item;

public class ItemCombo
implements Item {
    public static final String TYPE = "stringcombo";
    public static final String MULTI_TYPE = "multistringcombo";
    private String description;
    private boolean isMandatory;
    private String defaultValue;
    private String[] items;
    private String key;
    private boolean isMulti;

    public ItemCombo(String key, String description, String[] items, String defaultValue, boolean isMulti, boolean isMandatory) {
        this.key = key;
        this.items = items;
        this.isMulti = isMulti;
        if (defaultValue == null) {
            defaultValue = "";
        }
        this.description = description;
        this.defaultValue = defaultValue;
        this.isMandatory = isMandatory;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("        {\n");
        if (this.key != null && this.key.trim().length() > 0) {
            sb.append("             \"key\": \"").append(this.key).append("\",\n");
            sb.append("             \"label\": \"").append(this.description).append("\",\n");
        } else {
            sb.append("             \"key\": \"").append(this.description).append("\",\n");
        }
        sb.append("             \"values\": {\n");
        sb.append("                 \"items\": [\n");
        sb.append("                     {\"item\": \"\"},\n");
        StringBuilder tmp = new StringBuilder();
        for (String itemString : this.items) {
            tmp.append("                     {\"item\": \"" + itemString + "\"},\n");
        }
        String tmpStr = tmp.toString();
        int lastIndexOf = tmpStr.lastIndexOf(44);
        String substring = tmp.substring(0, lastIndexOf);
        sb.append(substring);
        sb.append("                 ]\n");
        sb.append("             },\n");
        sb.append("             \"value\": \"").append(this.defaultValue).append("\",\n");
        sb.append("             \"type\": \"").append(this.isMulti ? MULTI_TYPE : TYPE).append("\",\n");
        sb.append("             \"mandatory\": \"").append(this.isMandatory ? "yes" : "no").append("\"\n");
        sb.append("        }\n");
        return sb.toString();
    }

    @Override
    public String getKey() {
        return this.description;
    }

    @Override
    public void setValue(String value) {
        this.defaultValue = value;
    }

    @Override
    public String getValue() {
        return this.defaultValue;
    }
}

