/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.geopaparazzi.forms.items;

import org.hortonmachine.gears.io.geopaparazzi.forms.items.Item;

public class ItemDouble
implements Item {
    public static final String TYPE = "double";
    private String description;
    private boolean isMandatory;
    private String defaultValueStr;
    private boolean isLabel;
    private String key;
    private double[] range;
    private boolean[] rangeInclusiveness;

    public ItemDouble(String key, String description, Double defaultValue, boolean isMandatory, boolean isLabel, double[] range, boolean[] rangeInclusiveness) {
        this.key = key;
        this.isLabel = isLabel;
        this.range = range;
        this.rangeInclusiveness = rangeInclusiveness;
        this.defaultValueStr = defaultValue == null ? "" : defaultValue.toString();
        this.description = description;
        this.isMandatory = isMandatory;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("        {\n");
        if (this.key != null && this.key.trim().length() > 0) {
            sb.append("             \"key\": \"").append(this.key).append("\",\n");
            sb.append("             \"label\": \"").append(this.description).append("\",\n");
        } else {
            sb.append("             \"key\": \"").append(this.description).append("\",\n");
        }
        sb.append("             \"value\": \"").append(this.defaultValueStr).append("\",\n");
        if (this.isLabel) {
            sb.append("             \"islabel\": \"").append("true").append("\",\n");
        }
        sb.append("             \"type\": \"").append(TYPE).append("\",\n");
        if (this.range != null && this.rangeInclusiveness != null) {
            String rangeString = this.getRangeString(this.range, this.rangeInclusiveness);
            sb.append("             " + rangeString + ",\n");
        }
        sb.append("             \"mandatory\": \"").append(this.isMandatory ? "yes" : "no").append("\"\n");
        sb.append("        }\n");
        return sb.toString();
    }

    @Override
    public String getKey() {
        return this.description;
    }

    @Override
    public void setValue(String value) {
        this.defaultValueStr = value;
    }

    @Override
    public String getValue() {
        return this.defaultValueStr;
    }
}

