/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.geopaparazzi.forms.items;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hortonmachine.gears.io.geopaparazzi.forms.items.Item;
import org.hortonmachine.gears.io.geopaparazzi.forms.items.NamedList;
import org.hortonmachine.gears.utils.StringUtilities;

public class ItemOneToManyConnectedCombo
implements Item {
    public static final String TYPE = "onetomanystringcombo";
    private String description;
    private boolean isMandatory;
    private String defaultValue;
    private LinkedHashMap<String, List<NamedList<String>>> dataMap;
    private String key;

    public ItemOneToManyConnectedCombo(String key, String description, LinkedHashMap<String, List<NamedList<String>>> dataMap, String[] defaultValues, boolean isMandatory) {
        this.key = key;
        this.dataMap = dataMap;
        this.defaultValue = defaultValues == null ? "" : StringUtilities.joinStrings("#", defaultValues);
        this.description = description;
        this.isMandatory = isMandatory;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("        {\n");
        if (this.key != null && this.key.trim().length() > 0) {
            sb.append("             \"key\": \"").append(this.key).append("\",\n");
            sb.append("             \"label\": \"").append(this.description).append("\",\n");
        } else {
            sb.append("             \"key\": \"").append(this.description).append("\",\n");
        }
        sb.append("             \"values\": {\n");
        StringBuilder tmp = new StringBuilder();
        Set<Map.Entry<String, List<NamedList<String>>>> entrySet = this.dataMap.entrySet();
        for (Map.Entry<String, List<NamedList<String>>> entry : entrySet) {
            String itemName = entry.getKey();
            List<NamedList<String>> namedLists = entry.getValue();
            tmp.append("                 \"" + itemName + "\": [\n");
            StringBuilder tmp2 = new StringBuilder();
            for (NamedList<String> namedList : namedLists) {
                tmp2.append("                 {\n");
                tmp2.append("                   \"itemname\": \"" + namedList.name + "\",\n");
                tmp2.append("                   \"items\":[\n");
                StringBuilder tmp3 = new StringBuilder();
                for (String itemString : namedList.items) {
                    tmp3.append("                     {\"item\": \"" + itemString + "\"},\n");
                }
                String substring = this.removeLastComma(tmp3);
                tmp2.append(substring);
                tmp2.append("                   ]\n");
                tmp2.append("                 },\n");
            }
            String substring = this.removeLastComma(tmp2);
            tmp.append(substring).append("\n");
            tmp.append("                 ],\n");
        }
        String substring = this.removeLastComma(tmp);
        sb.append(substring).append("\n");
        sb.append("             },\n");
        sb.append("             \"value\": \"").append(this.defaultValue).append("\",\n");
        sb.append("             \"type\": \"").append(TYPE).append("\",\n");
        sb.append("             \"mandatory\": \"").append(this.isMandatory ? "yes" : "no").append("\"\n");
        sb.append("        }\n");
        return sb.toString();
    }

    private String removeLastComma(StringBuilder tmp) {
        String tmpStr = tmp.toString();
        int lastIndexOf = tmpStr.lastIndexOf(44);
        String substring = tmp.substring(0, lastIndexOf);
        return substring;
    }

    @Override
    public String getKey() {
        return this.description;
    }

    @Override
    public void setValue(String value) {
        this.defaultValue = value;
    }

    @Override
    public String getValue() {
        return this.defaultValue;
    }
}

