/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.geopaparazzi.geopap4;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hortonmachine.dbs.compat.IHMConnection;
import org.hortonmachine.dbs.compat.IHMResultSet;
import org.hortonmachine.dbs.compat.IHMStatement;
import org.hortonmachine.gears.io.geopaparazzi.geopap4.Image;
import org.hortonmachine.gears.io.geopaparazzi.geopap4.TableDescriptions;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DaoImages {
    public static void createTables(Connection connection) throws IOException, SQLException {
        StringBuilder sB = new StringBuilder();
        sB.append("CREATE TABLE ");
        sB.append("images");
        sB.append(" (");
        sB.append(TableDescriptions.ImageTableFields.COLUMN_ID.getFieldName());
        sB.append(" INTEGER PRIMARY KEY, ");
        sB.append(TableDescriptions.ImageTableFields.COLUMN_LON.getFieldName()).append(" REAL NOT NULL, ");
        sB.append(TableDescriptions.ImageTableFields.COLUMN_LAT.getFieldName()).append(" REAL NOT NULL,");
        sB.append(TableDescriptions.ImageTableFields.COLUMN_ALTIM.getFieldName()).append(" REAL NOT NULL,");
        sB.append(TableDescriptions.ImageTableFields.COLUMN_AZIM.getFieldName()).append(" REAL NOT NULL,");
        sB.append(TableDescriptions.ImageTableFields.COLUMN_IMAGEDATA_ID.getFieldName());
        sB.append(" INTEGER NOT NULL ");
        sB.append("CONSTRAINT " + TableDescriptions.ImageTableFields.COLUMN_IMAGEDATA_ID.getFieldName() + " REFERENCES ");
        sB.append("imagedata");
        sB.append("(");
        sB.append((Object)TableDescriptions.ImageDataTableFields.COLUMN_ID);
        sB.append(") ON DELETE CASCADE,");
        sB.append(TableDescriptions.ImageTableFields.COLUMN_TS.getFieldName()).append(" DATE NOT NULL,");
        sB.append(TableDescriptions.ImageTableFields.COLUMN_TEXT.getFieldName()).append(" TEXT NOT NULL,");
        sB.append(TableDescriptions.ImageTableFields.COLUMN_NOTE_ID.getFieldName()).append(" INTEGER,");
        sB.append(TableDescriptions.ImageTableFields.COLUMN_ISDIRTY.getFieldName()).append(" INTEGER NOT NULL");
        sB.append(");");
        String CREATE_TABLE_IMAGES = sB.toString();
        sB = new StringBuilder();
        sB.append("CREATE INDEX images_ts_idx ON ");
        sB.append("images");
        sB.append(" ( ");
        sB.append(TableDescriptions.ImageTableFields.COLUMN_TS.getFieldName());
        sB.append(" );");
        String CREATE_INDEX_IMAGES_TS = sB.toString();
        sB = new StringBuilder();
        sB.append("CREATE INDEX images_x_by_y_idx ON ");
        sB.append("images");
        sB.append(" ( ");
        sB.append(TableDescriptions.ImageTableFields.COLUMN_LON.getFieldName());
        sB.append(", ");
        sB.append(TableDescriptions.ImageTableFields.COLUMN_LAT.getFieldName());
        sB.append(" );");
        String CREATE_INDEX_IMAGES_X_BY_Y = sB.toString();
        sB = new StringBuilder();
        sB.append("CREATE INDEX images_noteid_idx ON ");
        sB.append("images");
        sB.append(" ( ");
        sB.append(TableDescriptions.ImageTableFields.COLUMN_NOTE_ID.getFieldName());
        sB.append(" );");
        String CREATE_INDEX_IMAGES_NOTEID = sB.toString();
        sB = new StringBuilder();
        sB.append("CREATE INDEX images_isdirty_idx ON ");
        sB.append("images");
        sB.append(" ( ");
        sB.append(TableDescriptions.ImageTableFields.COLUMN_ISDIRTY.getFieldName());
        sB.append(" );");
        String CREATE_INDEX_IMAGES_ISDIRTY = sB.toString();
        sB = new StringBuilder();
        sB.append("CREATE TABLE ");
        sB.append("imagedata");
        sB.append(" (");
        sB.append(TableDescriptions.ImageDataTableFields.COLUMN_ID.getFieldName());
        sB.append(" INTEGER PRIMARY KEY, ");
        sB.append(TableDescriptions.ImageDataTableFields.COLUMN_IMAGE.getFieldName()).append(" BLOB NOT NULL,");
        sB.append(TableDescriptions.ImageDataTableFields.COLUMN_THUMBNAIL.getFieldName()).append(" BLOB NOT NULL");
        sB.append(");");
        String CREATE_TABLE_IMAGEDATA = sB.toString();
        try (Statement statement = connection.createStatement();){
            statement.setQueryTimeout(30);
            statement.executeUpdate(CREATE_TABLE_IMAGES);
            statement.executeUpdate(CREATE_INDEX_IMAGES_TS);
            statement.executeUpdate(CREATE_INDEX_IMAGES_X_BY_Y);
            statement.executeUpdate(CREATE_INDEX_IMAGES_NOTEID);
            statement.executeUpdate(CREATE_INDEX_IMAGES_ISDIRTY);
            statement.executeUpdate(CREATE_TABLE_IMAGEDATA);
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public static void addImage(Connection connection, long id, double lon, double lat, double altim, double azim, long timestamp, String text, byte[] image, byte[] thumb, long noteId) throws IOException, SQLException {
        String insertSQL1 = "INSERT INTO imagedata(" + TableDescriptions.ImageDataTableFields.COLUMN_ID.getFieldName() + ", " + TableDescriptions.ImageDataTableFields.COLUMN_IMAGE.getFieldName() + ", " + TableDescriptions.ImageDataTableFields.COLUMN_THUMBNAIL.getFieldName() + ") VALUES(?,?,?)";
        try (PreparedStatement writeImageDataStatement = connection.prepareStatement(insertSQL1);){
            writeImageDataStatement.setLong(1, id);
            writeImageDataStatement.setBytes(2, image);
            writeImageDataStatement.setBytes(3, thumb);
            writeImageDataStatement.executeUpdate();
        }
        String insertSQL2 = "INSERT INTO images(" + TableDescriptions.ImageTableFields.COLUMN_ID.getFieldName() + ", " + TableDescriptions.ImageTableFields.COLUMN_LON.getFieldName() + ", " + TableDescriptions.ImageTableFields.COLUMN_LAT.getFieldName() + ", " + TableDescriptions.ImageTableFields.COLUMN_ALTIM.getFieldName() + ", " + TableDescriptions.ImageTableFields.COLUMN_TS.getFieldName() + ", " + TableDescriptions.ImageTableFields.COLUMN_AZIM.getFieldName() + ", " + TableDescriptions.ImageTableFields.COLUMN_TEXT.getFieldName() + ", " + TableDescriptions.ImageTableFields.COLUMN_ISDIRTY.getFieldName() + ", " + TableDescriptions.ImageTableFields.COLUMN_NOTE_ID.getFieldName() + ", " + TableDescriptions.ImageTableFields.COLUMN_IMAGEDATA_ID.getFieldName() + ") VALUES(?,?,?,?,?,?,?,?,?,?)";
        try (PreparedStatement writeImageStatement = connection.prepareStatement(insertSQL2);){
            writeImageStatement.setLong(1, id);
            writeImageStatement.setDouble(2, lon);
            writeImageStatement.setDouble(3, lat);
            writeImageStatement.setDouble(4, altim);
            writeImageStatement.setLong(5, timestamp);
            writeImageStatement.setDouble(6, azim);
            writeImageStatement.setString(7, text);
            writeImageStatement.setInt(8, 1);
            writeImageStatement.setLong(9, noteId);
            writeImageStatement.setLong(10, id);
            writeImageStatement.executeUpdate();
        }
    }

    public static String getImageName(IHMConnection connection, long imageId) throws Exception {
        String sql = "select " + TableDescriptions.ImageTableFields.COLUMN_TEXT.getFieldName() + " from images where " + TableDescriptions.ImageTableFields.COLUMN_ID.getFieldName() + " = " + imageId;
        try (IHMStatement statement = connection.createStatement();){
            String string;
            block16: {
                IHMResultSet rs;
                block14: {
                    String string2;
                    block15: {
                        rs = statement.executeQuery(sql);
                        try {
                            String text;
                            statement.setQueryTimeout(30);
                            if (!rs.next() || (text = rs.getString(TableDescriptions.ImageTableFields.COLUMN_TEXT.getFieldName())) == null || text.trim().length() == 0) break block14;
                            string2 = text;
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return string2;
                }
                string = null;
                if (rs == null) break block16;
                rs.close();
            }
            return string;
        }
    }

    public static List<Image> getImagesList(IHMConnection connection) throws Exception {
        ArrayList<Image> images = new ArrayList<Image>();
        String sql = "select " + TableDescriptions.ImageTableFields.COLUMN_ID.getFieldName() + "," + TableDescriptions.ImageTableFields.COLUMN_LON.getFieldName() + "," + TableDescriptions.ImageTableFields.COLUMN_LAT.getFieldName() + "," + TableDescriptions.ImageTableFields.COLUMN_ALTIM.getFieldName() + "," + TableDescriptions.ImageTableFields.COLUMN_TS.getFieldName() + "," + TableDescriptions.ImageTableFields.COLUMN_AZIM.getFieldName() + "," + TableDescriptions.ImageTableFields.COLUMN_TEXT.getFieldName() + "," + TableDescriptions.ImageTableFields.COLUMN_NOTE_ID.getFieldName() + "," + TableDescriptions.ImageTableFields.COLUMN_IMAGEDATA_ID.getFieldName() + " from images";
        try (IHMStatement statement = connection.createStatement();
             IHMResultSet rs = statement.executeQuery(sql);){
            statement.setQueryTimeout(30);
            while (rs.next()) {
                long id = rs.getLong(1);
                double lon = rs.getDouble(2);
                double lat = rs.getDouble(3);
                double altim = rs.getDouble(4);
                long ts = rs.getLong(5);
                double azim = rs.getDouble(6);
                String text = rs.getString(7);
                long noteId = rs.getLong(8);
                long imageDataId = rs.getLong(9);
                Image image = new Image(id, text, lon, lat, altim, azim, imageDataId, noteId, ts);
                images.add(image);
            }
        }
        return images;
    }

    public static byte[] getImageData(IHMConnection connection, long imageDataId) throws Exception {
        String sql = "select " + TableDescriptions.ImageDataTableFields.COLUMN_IMAGE.getFieldName() + " from imagedata where " + TableDescriptions.ImageDataTableFields.COLUMN_ID.getFieldName() + " = " + imageDataId;
        try (IHMStatement statement = connection.createStatement();
             IHMResultSet rs = statement.executeQuery(sql);){
            statement.setQueryTimeout(30);
            if (rs.next()) {
                byte[] bytes;
                byte[] byArray = bytes = rs.getBytes(1);
                return byArray;
            }
        }
        return null;
    }

    public static ReferencedEnvelope getEnvelope(IHMConnection connection) throws Exception {
        String query = "SELECT min(" + TableDescriptions.ImageTableFields.COLUMN_LON.getFieldName() + "), max(" + TableDescriptions.ImageTableFields.COLUMN_LON.getFieldName() + "), min(" + TableDescriptions.ImageTableFields.COLUMN_LAT.getFieldName() + "), max(" + TableDescriptions.ImageTableFields.COLUMN_LAT.getFieldName() + ")  FROM images";
        try (IHMStatement statement = connection.createStatement();
             IHMResultSet rs = statement.executeQuery(query);){
            if (rs.next()) {
                ReferencedEnvelope env;
                double minX = rs.getDouble(1);
                double maxX = rs.getDouble(2);
                double minY = rs.getDouble(3);
                double maxY = rs.getDouble(4);
                ReferencedEnvelope referencedEnvelope = env = new ReferencedEnvelope(minX, maxX, minY, maxY, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                return referencedEnvelope;
            }
        }
        return null;
    }
}

