/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.geopaparazzi.geopap4;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hortonmachine.dbs.compat.IHMConnection;
import org.hortonmachine.dbs.compat.IHMResultSet;
import org.hortonmachine.dbs.compat.IHMStatement;
import org.hortonmachine.gears.io.geopaparazzi.geopap4.Note;
import org.hortonmachine.gears.io.geopaparazzi.geopap4.TableDescriptions;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DaoNotes {
    public static void createTables(Connection connection) throws IOException, SQLException {
        StringBuilder sB = new StringBuilder();
        sB.append("CREATE TABLE ");
        sB.append("notes");
        sB.append(" (");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_ID.getFieldName());
        sB.append(" INTEGER PRIMARY KEY, ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_LON.getFieldName()).append(" REAL NOT NULL, ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_LAT.getFieldName()).append(" REAL NOT NULL,");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_ALTIM.getFieldName()).append(" REAL NOT NULL,");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_TS.getFieldName()).append(" DATE NOT NULL,");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_DESCRIPTION.getFieldName()).append(" TEXT, ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_TEXT.getFieldName()).append(" TEXT NOT NULL, ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_FORM.getFieldName()).append(" CLOB, ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_STYLE.getFieldName()).append(" TEXT,");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_ISDIRTY.getFieldName()).append(" INTEGER");
        sB.append(");");
        String CREATE_TABLE_NOTES = sB.toString();
        sB = new StringBuilder();
        sB.append("CREATE INDEX notes_ts_idx ON ");
        sB.append("notes");
        sB.append(" ( ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_TS.getFieldName());
        sB.append(" );");
        String CREATE_INDEX_NOTES_TS = sB.toString();
        sB = new StringBuilder();
        sB.append("CREATE INDEX notes_x_by_y_idx ON ");
        sB.append("notes");
        sB.append(" ( ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_LON.getFieldName());
        sB.append(", ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_LAT.getFieldName());
        sB.append(" );");
        String CREATE_INDEX_NOTES_X_BY_Y = sB.toString();
        sB = new StringBuilder();
        sB.append("CREATE INDEX notes_isdirty_idx ON ");
        sB.append("notes");
        sB.append(" ( ");
        sB.append(TableDescriptions.NotesTableFields.COLUMN_ISDIRTY.getFieldName());
        sB.append(" );");
        String CREATE_INDEX_NOTES_ISDIRTY = sB.toString();
        try (Statement statement = connection.createStatement();){
            statement.setQueryTimeout(30);
            statement.executeUpdate(CREATE_TABLE_NOTES);
            statement.executeUpdate(CREATE_INDEX_NOTES_TS);
            statement.executeUpdate(CREATE_INDEX_NOTES_X_BY_Y);
            statement.executeUpdate(CREATE_INDEX_NOTES_ISDIRTY);
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public static void addNote(Connection connection, long id, double lon, double lat, double altim, long timestamp, String text, String form) throws Exception {
        String insertSQL = "INSERT INTO notes(" + TableDescriptions.NotesTableFields.COLUMN_ID.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_LAT.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_LON.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_ALTIM.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_TS.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_TEXT.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_FORM.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_ISDIRTY.getFieldName() + ") VALUES(?,?,?,?,?,?,?,?)";
        try (PreparedStatement writeStatement = connection.prepareStatement(insertSQL);){
            writeStatement.setLong(1, id);
            writeStatement.setDouble(2, lat);
            writeStatement.setDouble(3, lon);
            writeStatement.setDouble(4, altim);
            writeStatement.setLong(5, timestamp);
            writeStatement.setString(6, text);
            writeStatement.setString(7, form);
            writeStatement.setInt(8, 1);
            writeStatement.executeUpdate();
        }
    }

    public static List<Note> getNotesList(IHMConnection connection, float[] nswe) throws Exception {
        Object query = "SELECT " + TableDescriptions.NotesTableFields.COLUMN_ID.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_LON.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_LAT.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_ALTIM.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_TEXT.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_TS.getFieldName() + ", " + TableDescriptions.NotesTableFields.COLUMN_DESCRIPTION.getFieldName() + " FROM notes";
        if (nswe != null) {
            query = (String)query + " WHERE (lon BETWEEN XXX AND XXX) AND (lat BETWEEN XXX AND XXX)";
            query = ((String)query).replaceFirst("XXX", String.valueOf(nswe[2]));
            query = ((String)query).replaceFirst("XXX", String.valueOf(nswe[3]));
            query = ((String)query).replaceFirst("XXX", String.valueOf(nswe[1]));
            query = ((String)query).replaceFirst("XXX", String.valueOf(nswe[0]));
        }
        ArrayList<Note> notes = new ArrayList<Note>();
        try (IHMStatement statement = connection.createStatement();
             IHMResultSet rs = statement.executeQuery((String)query);){
            statement.setQueryTimeout(30);
            while (rs.next()) {
                Note note = new Note();
                note.id = rs.getLong(1);
                note.lon = rs.getDouble(2);
                note.lat = rs.getDouble(3);
                note.altim = rs.getDouble(4);
                note.simpleText = rs.getString(5);
                note.timeStamp = rs.getLong(6);
                note.description = rs.getString(7);
                notes.add(note);
            }
        }
        return notes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ReferencedEnvelope getEnvelope(IHMConnection connection, String noteTypeName) throws Exception {
        String query = "SELECT min(" + TableDescriptions.NotesTableFields.COLUMN_LON.getFieldName() + "), max(" + TableDescriptions.NotesTableFields.COLUMN_LON.getFieldName() + "), min(" + TableDescriptions.NotesTableFields.COLUMN_LAT.getFieldName() + "), max(" + TableDescriptions.NotesTableFields.COLUMN_LAT.getFieldName() + ")  FROM notes";
        if (noteTypeName != null) {
            query = query + " where " + TableDescriptions.NotesTableFields.COLUMN_TEXT.getFieldName() + "='" + noteTypeName + "'";
        } else {
            String formFN = TableDescriptions.NotesTableFields.COLUMN_FORM.getFieldName();
            query = query + " where " + formFN + " is null OR " + formFN + "=''";
        }
        try (IHMStatement statement = connection.createStatement();
             IHMResultSet rs = statement.executeQuery(query);){
            ReferencedEnvelope env;
            if (!rs.next()) return null;
            double minX = rs.getDouble(1);
            double maxX = rs.getDouble(2);
            double minY = rs.getDouble(3);
            double maxY = rs.getDouble(4);
            ReferencedEnvelope referencedEnvelope = env = new ReferencedEnvelope(minX, maxX, minY, maxY, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            return referencedEnvelope;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

