/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.geopaparazzi.styles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hortonmachine.dbs.compat.ASpatialDb;
import org.hortonmachine.dbs.utils.BasicStyle;
import org.hortonmachine.gears.io.geopaparazzi.styles.ISpatialiteTableAndFieldsNames;

public class GeopaparazziDatabaseProperties
implements ISpatialiteTableAndFieldsNames {
    public static List<String> PROPERTIESTABLE_FIELDS_LIST;

    public static void createPropertiesTable(ASpatialDb database) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append("dataproperties");
        sb.append(" (");
        sb.append("_id");
        sb.append(" INTEGER PRIMARY KEY AUTOINCREMENT, ");
        sb.append("name").append(" TEXT, ");
        sb.append("size").append(" REAL, ");
        sb.append("fillcolor").append(" TEXT, ");
        sb.append("strokecolor").append(" TEXT, ");
        sb.append("fillalpha").append(" REAL, ");
        sb.append("strokealpha").append(" REAL, ");
        sb.append("shape").append(" TEXT, ");
        sb.append("width").append(" REAL, ");
        sb.append("labelsize").append(" REAL, ");
        sb.append("labelfield").append(" TEXT, ");
        sb.append("labelvisible").append(" INTEGER, ");
        sb.append("enabled").append(" INTEGER, ");
        sb.append("layerorder").append(" INTEGER,");
        sb.append("dashpattern").append(" TEXT,");
        sb.append("minzoom").append(" INTEGER,");
        sb.append("maxzoom").append(" INTEGER,");
        sb.append("decimationfactor").append(" REAL,");
        sb.append("theme").append(" TEXT");
        sb.append(" );");
        String query = sb.toString();
        database.executeInsertUpdateDeleteSql(query);
    }

    public static BasicStyle createDefaultPropertiesForTable(ASpatialDb database, String spatialTableUniqueName, String spatialTableLabelField) throws Exception {
        StringBuilder sbIn = new StringBuilder();
        sbIn.append("insert into ").append("dataproperties");
        sbIn.append(" ( ");
        sbIn.append("name").append(" , ");
        sbIn.append("size").append(" , ");
        sbIn.append("fillcolor").append(" , ");
        sbIn.append("strokecolor").append(" , ");
        sbIn.append("fillalpha").append(" , ");
        sbIn.append("strokealpha").append(" , ");
        sbIn.append("shape").append(" , ");
        sbIn.append("width").append(" , ");
        sbIn.append("labelsize").append(" , ");
        sbIn.append("labelfield").append(" , ");
        sbIn.append("labelvisible").append(" , ");
        sbIn.append("enabled").append(" , ");
        sbIn.append("layerorder").append(" , ");
        sbIn.append("dashpattern").append(" ,");
        sbIn.append("minzoom").append(" ,");
        sbIn.append("maxzoom").append(" ,");
        sbIn.append("decimationfactor");
        sbIn.append(" ) ");
        sbIn.append(" values ");
        sbIn.append(" ( ");
        BasicStyle style = new BasicStyle();
        style.name = spatialTableUniqueName;
        style.labelfield = spatialTableLabelField;
        if (spatialTableLabelField != null && spatialTableLabelField.trim().length() > 0) {
            style.labelvisible = 1;
        }
        sbIn.append(style.insertValuesString());
        sbIn.append(" );");
        if (database != null) {
            String insertQuery = sbIn.toString();
            database.executeInsertUpdateDeleteSql(insertQuery);
        }
        return style;
    }

    public static void updateStyle(ASpatialDb database, BasicStyle style) throws Exception {
        StringBuilder sbIn = new StringBuilder();
        sbIn.append("update ").append("dataproperties");
        sbIn.append(" set ");
        sbIn.append("size").append("=?,");
        sbIn.append("fillcolor").append("=?,");
        sbIn.append("strokecolor").append("=?,");
        sbIn.append("fillalpha").append("=?,");
        sbIn.append("strokealpha").append("=?,");
        sbIn.append("shape").append("=?,");
        sbIn.append("width").append("=?,");
        sbIn.append("labelsize").append("=?,");
        sbIn.append("labelfield").append("=?,");
        sbIn.append("labelvisible").append("=?,");
        sbIn.append("enabled").append("=?,");
        sbIn.append("layerorder").append("=?,");
        sbIn.append("dashpattern").append("=?,");
        sbIn.append("minzoom").append("=?,");
        sbIn.append("maxzoom").append("=?,");
        sbIn.append("decimationfactor").append("=?,");
        sbIn.append("theme").append("=?");
        sbIn.append(" where ");
        sbIn.append("name");
        sbIn.append("='");
        sbIn.append(style.name);
        sbIn.append("';");
        Object[] objects = new Object[]{style.size, style.fillcolor, style.strokecolor, style.fillalpha, style.strokealpha, style.shape, style.width, style.labelsize, style.labelfield, style.labelvisible, style.enabled, style.order, style.dashPattern, style.minZoom, style.maxZoom, style.decimationFactor, style.getTheme()};
        String updateQuery = sbIn.toString();
        database.executeInsertUpdateDeletePreparedSql(updateQuery, objects);
    }

    static {
        ArrayList<String> fieldsList = new ArrayList<String>();
        fieldsList.add("_id");
        fieldsList.add("name");
        fieldsList.add("size");
        fieldsList.add("fillcolor");
        fieldsList.add("strokecolor");
        fieldsList.add("fillalpha");
        fieldsList.add("strokealpha");
        fieldsList.add("shape");
        fieldsList.add("width");
        fieldsList.add("labelsize");
        fieldsList.add("labelfield");
        fieldsList.add("labelvisible");
        fieldsList.add("enabled");
        fieldsList.add("layerorder");
        fieldsList.add("dashpattern");
        fieldsList.add("minzoom");
        fieldsList.add("maxzoom");
        fieldsList.add("decimationfactor");
        fieldsList.add("theme");
        PROPERTIESTABLE_FIELDS_LIST = Collections.unmodifiableList(fieldsList);
    }
}

