/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.grasslegacy.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.hortonmachine.gears.i18n.GearsMessageHandler;
import org.hortonmachine.gears.io.grasslegacy.io.MapReader;
import org.hortonmachine.gears.io.grasslegacy.io.RasterReadingFailureException;
import org.hortonmachine.gears.io.grasslegacy.map.attribute.AttributeTable;
import org.hortonmachine.gears.io.grasslegacy.map.color.ColorMapBuffer;
import org.hortonmachine.gears.io.grasslegacy.utils.FileUtilities;
import org.hortonmachine.gears.io.grasslegacy.utils.JlsTokenizer;
import org.hortonmachine.gears.io.grasslegacy.utils.Window;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;

public class GrassRasterReader
extends MapReader {
    private int rasterMapType = -9999;
    private int numberOfBytesPerValue = -9999;
    private int compressed = -9999;
    private Object novalue = new Double(Double.NaN);
    private int matrixType = 0;
    private RandomAccessFile cellFile = null;
    private RandomAccessFile nullFile = null;
    private String filename = null;
    private String locationPath = null;
    private String mapsetPath = null;
    private String reclassPath = null;
    private Vector<Object> reclassTable = null;
    private long[] addressesofrows = null;
    private boolean moreData = false;
    private boolean hasChanged = true;
    private boolean isOldIntegerMap = false;
    private int rowCacheRow = -1;
    private int firstDataRow = -1;
    private final double[] range = new double[]{1000000.0, -1000000.0};
    private final double[] dataRange = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
    private AttributeTable attTable = null;
    private AttributeTable legendAttribTable = null;
    private double[][] outputData;

    public GrassRasterReader() {
        super(1);
    }

    @Override
    public boolean open(String mapPath) {
        File file = new File(mapPath);
        if (!file.exists()) {
            return false;
        }
        File mapsetFile = file.getParentFile().getParentFile();
        File locationFile = mapsetFile.getParentFile();
        return this.open(file.getName(), locationFile.getAbsolutePath(), mapsetFile.getName());
    }

    @Override
    public boolean open(String fileName, String locationPath, String mapsetName) {
        this.nullFile = null;
        this.cellFile = null;
        this.filename = fileName;
        this.locationPath = locationPath;
        this.mapsetPath = locationPath + File.separator + mapsetName;
        if (this.hasChanged) {
            if (this.rasterMapType == -9999 && !this.getRasterMapTypes(this.filename, this.mapsetPath)) {
                return false;
            }
            if (this.compressed == 1) {
                try {
                    this.addressesofrows = this.getRowAddressesFromHeader(this.readHeader(this.cellFile));
                }
                catch (IOException e) {
                    return false;
                }
            }
            this.moreData = true;
        }
        this.hasChanged(false);
        return true;
    }

    @Override
    public void close() {
        try {
            this.cellFile.close();
            if (this.nullFile != null) {
                this.nullFile.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.hasChanged(true);
        this.moreData = true;
    }

    public AttributeTable loadAttributeTable(String themapsetPath, String thefilename) {
        File ds1 = null;
        try {
            String line;
            ds1 = new File(themapsetPath + File.separator + "cats" + File.separator + thefilename);
            if (!ds1.exists()) {
                return null;
            }
            BufferedReader rdr = new BufferedReader(new FileReader(ds1));
            this.attTable = new AttributeTable();
            rdr.readLine();
            rdr.readLine();
            rdr.readLine();
            rdr.readLine();
            while ((line = rdr.readLine()) != null) {
                if (line.indexOf("0:no data") != -1) continue;
                JlsTokenizer tk = new JlsTokenizer(line, ":");
                if (tk.countTokens() == 2) {
                    float f = Float.parseFloat(tk.nextToken());
                    String att = tk.nextToken().trim();
                    this.attTable.addAttribute(f, att);
                    continue;
                }
                if (tk.countTokens() != 3) continue;
                float f0 = Float.parseFloat(tk.nextToken());
                float f1 = Float.parseFloat(tk.nextToken());
                String att = tk.nextToken().trim();
                this.attTable.addAttribute(f0, f1, att);
            }
            return this.attTable;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean hasMoreData(IHMProgressMonitor monitor) throws Exception {
        block15: {
            try {
                if (this.dataWindow == null || !this.moreData) break block15;
                this.outputData = new double[this.dataWindow.getRows()][this.dataWindow.getCols()];
                int bufferSize = this.dataWindow.getRows() * this.dataWindow.getCols() * this.numberOfBytesPerValue;
                try {
                    byte[] nullRow = null;
                    byte[] rowDataCache = new byte[this.dataWindow.getCols() * this.numberOfBytesPerValue];
                    byte[] rowColorDataCache = new byte[this.dataWindow.getCols() * 4];
                    this.rowCacheRow = -1;
                    this.firstDataRow = -1;
                    int rowindex = -1;
                    int filerows = this.fileWindow.getRows();
                    double filenorth = this.fileWindow.getNorth();
                    double filensres = this.fileWindow.getNSResolution();
                    double datanorth = this.dataWindow.getNorth();
                    double datansres = this.dataWindow.getNSResolution();
                    monitor.beginTask(GearsMessageHandler.getInstance().message("grass.legacy.reading") + this.filename, this.dataWindow.getRows());
                    int stepRowsForPercentage = this.dataWindow.getRows() / 100;
                    for (double row = 0.0; row < (double)this.dataWindow.getRows(); row += 1.0) {
                        int col;
                        ByteBuffer wrap;
                        if (row % (double)stepRowsForPercentage == 0.0) {
                            monitor.worked(stepRowsForPercentage);
                        }
                        double filerow = (filenorth - (datanorth - row * datansres)) / filensres;
                        if ((filerow = Math.floor(filerow)) < 0.0 || filerow >= (double)filerows) {
                            if (this.firstDataRow == -1) {
                                ++rowindex;
                            }
                            if (nullRow == null) {
                                nullRow = this.initNullRow();
                            }
                            wrap = ByteBuffer.wrap(nullRow);
                            for (col = 0; col < this.dataWindow.getCols(); ++col) {
                                this.outputData[(int)row][col] = wrap.getDouble();
                            }
                            continue;
                        }
                        if (this.firstDataRow == -1) {
                            this.firstDataRow = rowindex + 1;
                        }
                        if (filerow == (double)this.rowCacheRow) {
                            wrap = ByteBuffer.wrap(rowDataCache);
                            for (col = 0; col < this.dataWindow.getCols(); ++col) {
                                this.outputData[(int)row][col] = wrap.getDouble();
                            }
                            continue;
                        }
                        this.readRasterRow((int)filerow, rowDataCache, rowColorDataCache);
                        this.rowCacheRow = (int)filerow;
                        wrap = ByteBuffer.wrap(rowDataCache);
                        for (col = 0; col < this.dataWindow.getCols(); ++col) {
                            this.outputData[(int)row][col] = wrap.getDouble();
                        }
                    }
                    monitor.done();
                    rowDataCache = null;
                    rowColorDataCache = null;
                    this.rowCacheRow = -1;
                    nullRow = null;
                    System.gc();
                }
                catch (IOException e) {
                    this.moreData = false;
                }
                catch (DataFormatException e) {
                    this.moreData = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RasterReadingFailureException("Problems reading raster: " + e.getLocalizedMessage());
            }
        }
        return this.moreData;
    }

    @Override
    public Object getNextData() {
        this.moreData = false;
        if (this.dataObject instanceof double[][]) {
            return this.outputData;
        }
        throw new RuntimeException();
    }

    @Override
    public ColorMapBuffer getNextDataColor(int attColor) {
        return null;
    }

    @Override
    public String getLegendString() throws IOException {
        return null;
    }

    public void hasChanged(boolean _haschanged) {
    }

    @Override
    public void setParameter(String key, Object obj) {
        if (key.equals("novalue")) {
            this.novalue = obj;
        } else if (key.equals("matrixtype")) {
            Integer dmtype = (Integer)obj;
            this.matrixType = dmtype;
        }
    }

    @Override
    public void setOutputDataObject(Object _dataObject) {
        super.setOutputDataObject(_dataObject);
    }

    public String getMapPath() {
        return "cell";
    }

    private ByteBuffer readHeader(RandomAccessFile ds) throws IOException {
        int first = ds.read();
        ByteBuffer fileHeader = ByteBuffer.allocate(1 + first * this.fileWindow.getRows() + first);
        ds.seek(0L);
        ds.read(fileHeader.array());
        return fileHeader;
    }

    private long[] getRowAddressesFromHeader(ByteBuffer header) {
        long[] adrows;
        block3: {
            byte firstbyte;
            block2: {
                firstbyte = header.get();
                adrows = new long[this.fileWindow.getRows() + 1];
                if (firstbyte != 4) break block2;
                for (int i = 0; i <= this.fileWindow.getRows(); ++i) {
                    adrows[i] = header.getInt();
                }
                break block3;
            }
            if (firstbyte != 8) break block3;
            for (int i = 0; i <= this.fileWindow.getRows(); ++i) {
                adrows[i] = header.getLong();
            }
        }
        return adrows;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getRasterMapTypes(String fname, String mapsetPath) {
        LinkedHashMap<String, String> fileMapHeader = new LinkedHashMap<String, String>();
        String reclassFile = null;
        String reclassMapset = null;
        this.reclassTable = null;
        try {
            File ds4 = new File(mapsetPath + File.separator + "cellhd" + File.separator + fname);
            BufferedReader cellhead = new BufferedReader(new FileReader(ds4));
            cellhead.mark(128);
            String line = cellhead.readLine();
            if (line == null) {
                return false;
            }
            if (line.trim().equalsIgnoreCase("reclass")) {
                for (int i = 0; i < 2; ++i) {
                    line = cellhead.readLine();
                    if (line == null) {
                        return false;
                    }
                    JlsTokenizer tk = new JlsTokenizer(line, ":");
                    if (tk.countTokens() != 2) continue;
                    String s = tk.nextToken();
                    if (s.equalsIgnoreCase("name")) {
                        reclassFile = tk.nextToken().trim();
                        continue;
                    }
                    if (!s.equalsIgnoreCase("mapset")) continue;
                    reclassMapset = tk.nextToken().trim();
                }
                this.reclassTable = new Vector();
                line = cellhead.readLine();
                if (line == null) {
                    return false;
                }
                if (line.charAt(0) == '#') {
                    int reclassFirstCategory = Integer.parseInt(line.trim().substring(1));
                    for (int i = 0; i < reclassFirstCategory; ++i) {
                        this.reclassTable.addElement("");
                    }
                } else {
                    this.reclassTable.addElement("");
                }
                while ((line = cellhead.readLine()) != null) {
                    this.reclassTable.addElement(new Integer(line));
                }
                this.reclassPath = this.locationPath + File.separator + reclassMapset + File.separator;
                ds4 = new File(this.reclassPath + "cellhd" + File.separator + reclassFile);
                if (!ds4.exists()) {
                    return false;
                }
                cellhead = new BufferedReader(new FileReader(ds4));
            } else {
                cellhead.reset();
            }
            while ((line = cellhead.readLine()) != null) {
                StringTokenizer tok = new StringTokenizer(line = line.replaceFirst(":", "@@@@"), "@@@@");
                if (tok.countTokens() != 2) continue;
                String key = tok.nextToken().trim();
                String value = tok.nextToken().trim();
                if (key.indexOf("resol") != -1) {
                    fileMapHeader.put(key.replaceAll("resol", "res"), value);
                    continue;
                }
                fileMapHeader.put(key, value);
            }
            this.fileWindow = null;
            if (fileMapHeader.containsKey("n-s res")) {
                this.fileWindow = new Window((String)fileMapHeader.get("west"), (String)fileMapHeader.get("east"), (String)fileMapHeader.get("south"), (String)fileMapHeader.get("north"), (String)fileMapHeader.get("e-w res"), (String)fileMapHeader.get("n-s res"));
            } else {
                if (!fileMapHeader.containsKey("cols")) throw new IllegalArgumentException("Missing infor in the header file. Row/cols or resolution info have to be available.");
                this.fileWindow = new Window((String)fileMapHeader.get("west"), (String)fileMapHeader.get("east"), (String)fileMapHeader.get("south"), (String)fileMapHeader.get("north"), Integer.parseInt((String)fileMapHeader.get("rows")), Integer.parseInt((String)fileMapHeader.get("cols")));
            }
            if (((String)fileMapHeader.get("format")).equals("")) return false;
            this.rasterMapType = new Integer((String)fileMapHeader.get("format"));
            if (this.rasterMapType > -1) {
                ++this.rasterMapType;
                this.numberOfBytesPerValue = 4;
                File ds = null;
                ds = this.reclassPath == null ? new File(mapsetPath + File.separator + "cell" + File.separator + fname) : new File(this.reclassPath + "cell" + File.separator + reclassFile);
                if (!ds.exists()) return false;
                this.cellFile = new RandomAccessFile(ds, "r");
                if (this.cellFile == null) {
                    return false;
                }
                this.nullFile = null;
                ds = this.reclassPath == null ? new File(mapsetPath + File.separator + "cell_misc" + File.separator + this.filename + File.separator + "null") : new File(this.reclassPath + "cell_misc" + File.separator + reclassFile + File.separator + "null");
                if (ds.exists()) {
                    this.nullFile = new RandomAccessFile(ds, "r");
                    this.isOldIntegerMap = this.nullFile != null;
                }
            } else if (this.rasterMapType < 0) {
                File ds5 = null;
                ds5 = this.reclassPath == null ? new File(mapsetPath + File.separator + "cell_misc" + File.separator + fname + File.separator + "f_format") : new File(this.reclassPath + "cell_misc" + File.separator + reclassFile + File.separator + "f_format");
                if (!ds5.exists()) return false;
                BufferedReader cellmiscformat = new BufferedReader(new FileReader(ds5));
                while ((line = cellmiscformat.readLine()) != null) {
                    StringTokenizer tokk = new StringTokenizer(line, ":");
                    if (tokk.countTokens() != 2) continue;
                    String key = tokk.nextToken().trim();
                    String value = tokk.nextToken().trim();
                    fileMapHeader.put(key, value);
                }
                if (((String)fileMapHeader.get("type")).equals("")) return false;
                if (((String)fileMapHeader.get("type")).equalsIgnoreCase("double")) {
                    this.rasterMapType = -2;
                    this.numberOfBytesPerValue = 8;
                } else {
                    if (!((String)fileMapHeader.get("type")).equalsIgnoreCase("float")) return false;
                    this.rasterMapType = -1;
                    this.numberOfBytesPerValue = 4;
                }
                cellmiscformat.close();
                this.isOldIntegerMap = false;
                ds5 = this.reclassPath == null ? new File(mapsetPath + File.separator + "fcell" + File.separator + fname) : new File(this.reclassPath + "fcell" + File.separator + reclassFile);
                if (!ds5.exists()) return false;
                this.cellFile = new RandomAccessFile(ds5, "r");
                if (this.cellFile == null) {
                    return false;
                }
                this.nullFile = null;
                ds5 = this.reclassPath == null ? new File(mapsetPath + File.separator + "cell_misc" + File.separator + this.filename + File.separator + "null") : new File(this.reclassPath + "cell_misc" + File.separator + reclassFile + File.separator + "null");
                if (ds5.exists()) {
                    this.nullFile = new RandomAccessFile(ds5, "r");
                    if (this.nullFile == null) {
                        // empty if block
                    }
                }
            }
            if (((String)fileMapHeader.get("compressed")).equals("")) {
                return false;
            }
            this.compressed = new Integer((String)fileMapHeader.get("compressed"));
            cellhead.close();
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean readRasterRow(int currentfilerow, byte[] rowDataCache, byte[] rowColorDataCache) throws IOException, DataFormatException {
        ByteBuffer rowBuffer = ByteBuffer.wrap(rowDataCache);
        ByteBuffer rowColorBuffer = ByteBuffer.wrap(rowColorDataCache);
        boolean iscompressed = this.compressed == 1;
        double activeewres = this.dataWindow.getWEResolution();
        double activewest = this.dataWindow.getWest();
        double filewest = this.fileWindow.getWest();
        double fileewres = this.fileWindow.getWEResolution();
        ByteBuffer rowCache = ByteBuffer.allocate(this.fileWindow.getCols() * (this.rasterMapType == -2 ? 8 : 4));
        this.getMapRow(currentfilerow, rowCache, iscompressed);
        for (double col = 0.0; col < (double)this.dataWindow.getCols(); col += 1.0) {
            double x = (activewest + col * activeewres - filewest) / fileewres;
            if ((x = Math.floor(x)) < 0.0 || x >= (double)this.fileWindow.getCols()) {
                if (this.rasterMapType > 0) {
                    rowBuffer.putInt(Integer.MAX_VALUE);
                    if (this.colorTable == null) continue;
                    this.colorTable.interpolateColorValue(rowColorBuffer, Integer.MAX_VALUE);
                    continue;
                }
                if (this.rasterMapType == -1) {
                    rowBuffer.putFloat(Float.NaN);
                    if (this.colorTable == null) continue;
                    this.colorTable.interpolateColorValue(rowColorBuffer, Float.NaN);
                    continue;
                }
                if (this.rasterMapType != -2) continue;
                rowBuffer.putDouble(Double.NaN);
                if (this.colorTable == null) continue;
                this.colorTable.interpolateColorValue(rowColorBuffer, Double.NaN);
                continue;
            }
            if (this.readNullValueAtRowCol(currentfilerow, (int)x)) {
                if (this.rasterMapType > 0) {
                    rowBuffer.putInt(Integer.MAX_VALUE);
                    if (this.colorTable == null) continue;
                    this.colorTable.interpolateColorValue(rowColorBuffer, Integer.MAX_VALUE);
                    continue;
                }
                if (this.rasterMapType == -1) {
                    rowBuffer.putFloat(Float.NaN);
                    if (this.colorTable == null) continue;
                    this.colorTable.interpolateColorValue(rowColorBuffer, Float.NaN);
                    continue;
                }
                if (this.rasterMapType != -2) continue;
                rowBuffer.putDouble(Double.NaN);
                if (this.colorTable == null) continue;
                this.colorTable.interpolateColorValue(rowColorBuffer, Double.NaN);
                continue;
            }
            rowCache.position((int)x * this.numberOfBytesPerValue);
            if (this.rasterMapType > 0) {
                int cell = rowCache.getInt();
                if (cell == 0 && this.isOldIntegerMap) {
                    rowBuffer.putInt(Integer.MAX_VALUE);
                    if (this.colorTable == null) continue;
                    this.colorTable.interpolateColorValue(rowColorBuffer, Integer.MAX_VALUE);
                    continue;
                }
                if (this.reclassTable != null) {
                    cell = (Integer)this.reclassTable.elementAt(cell);
                }
                rowBuffer.putInt(cell);
                if (this.colorTable != null) {
                    this.colorTable.interpolateColorValue(rowColorBuffer, cell);
                }
                if ((double)cell < this.dataRange[0]) {
                    this.dataRange[0] = cell;
                    continue;
                }
                if (!((double)cell > this.dataRange[1])) continue;
                this.dataRange[1] = cell;
                continue;
            }
            if (this.rasterMapType == -1) {
                float cell = rowCache.getFloat();
                if (this.reclassTable != null) {
                    cell = ((Integer)this.reclassTable.elementAt((int)cell)).floatValue();
                }
                rowBuffer.putFloat(cell);
                if (this.colorTable != null) {
                    this.colorTable.interpolateColorValue(rowColorBuffer, cell);
                }
                if ((double)cell < this.dataRange[0]) {
                    this.dataRange[0] = cell;
                    continue;
                }
                if (!((double)cell > this.dataRange[1])) continue;
                this.dataRange[1] = cell;
                continue;
            }
            if (this.rasterMapType != -2) continue;
            double cell = rowCache.getDouble();
            if (this.reclassTable != null) {
                cell = ((Integer)this.reclassTable.elementAt((int)cell)).doubleValue();
            }
            rowBuffer.putDouble(cell);
            if (this.colorTable != null) {
                this.colorTable.interpolateColorValue(rowColorBuffer, cell);
            }
            if (cell < this.dataRange[0]) {
                this.dataRange[0] = cell;
                continue;
            }
            if (!(cell > this.dataRange[1])) continue;
            this.dataRange[1] = cell;
        }
        return true;
    }

    private byte[] initNullRow() {
        byte[] nrow;
        block4: {
            int len;
            block5: {
                block3: {
                    len = this.dataWindow.getCols() * this.numberOfBytesPerValue;
                    nrow = new byte[len];
                    if (this.rasterMapType <= 0) break block3;
                    ByteBuffer src = ByteBuffer.allocate(4);
                    src.putInt(Integer.MAX_VALUE);
                    byte[] arr = src.array();
                    for (int i = 0; i < len; i += 4) {
                        System.arraycopy(arr, 0, nrow, i, 4);
                    }
                    break block4;
                }
                if (this.rasterMapType != -1) break block5;
                ByteBuffer src = ByteBuffer.allocate(4);
                src.putFloat(Float.NaN);
                byte[] arr = src.array();
                for (int i = 0; i < len; i += 4) {
                    System.arraycopy(arr, 0, nrow, i, 4);
                }
                break block4;
            }
            if (this.rasterMapType != -2) break block4;
            ByteBuffer src = ByteBuffer.allocate(8);
            src.putDouble(Double.NaN);
            byte[] arr = src.array();
            for (int i = 0; i < len; i += 8) {
                System.arraycopy(arr, 0, nrow, i, 8);
            }
        }
        return nrow;
    }

    private void getMapRow(int currentrow, ByteBuffer rowdata, boolean iscompressed) throws IOException, DataFormatException {
        if (iscompressed) {
            if (this.rasterMapType == -2) {
                this.readCompressedFPRowByNumber(rowdata, currentrow, this.addressesofrows, this.cellFile, this.numberOfBytesPerValue);
            } else if (this.rasterMapType == -1) {
                this.readCompressedFPRowByNumber(rowdata, currentrow, this.addressesofrows, this.cellFile, this.numberOfBytesPerValue);
            } else if (this.rasterMapType > 0) {
                this.readCompressedIntegerRowByNumber(rowdata, currentrow, this.addressesofrows, this.cellFile);
            }
        } else if (this.rasterMapType < 0) {
            this.readUncompressedFPRowByNumber(rowdata, currentrow, this.cellFile, this.numberOfBytesPerValue);
        } else if (this.rasterMapType > 0) {
            this.readUncompressedIntegerRowByNumber(rowdata, currentrow, this.cellFile);
        }
    }

    private void readCompressedFPRowByNumber(ByteBuffer rowdata, int rn, long[] adrows, RandomAccessFile thefile, int typeBytes) throws DataFormatException, IOException {
        int offset = (int)(adrows[rn + 1] - adrows[rn]);
        byte[] tmp = new byte[offset - 1];
        thefile.seek(adrows[rn]);
        int firstbyte = thefile.read() & 0xFF;
        if (firstbyte == 49) {
            thefile.read(tmp, 0, offset - 1);
            Inflater decompresser = new Inflater();
            decompresser.setInput(tmp, 0, tmp.length);
            decompresser.inflate(rowdata.array());
            decompresser.end();
        } else if (firstbyte == 48) {
            thefile.read(rowdata.array(), 0, offset - 1);
        }
    }

    private void readUncompressedFPRowByNumber(ByteBuffer rowdata, int rn, RandomAccessFile thefile, int typeBytes) throws IOException, DataFormatException {
        int datanumber = this.fileWindow.getCols() * typeBytes;
        thefile.seek(rn * datanumber);
        thefile.read(rowdata.array());
    }

    private void readCompressedIntegerRowByNumber(ByteBuffer rowdata, int rn, long[] adrows, RandomAccessFile thefile) throws IOException, DataFormatException {
        int offset = (int)(adrows[rn + 1] - adrows[rn]);
        thefile.seek(adrows[rn]);
        int bytespervalue = thefile.read() & 0xFF;
        ByteBuffer cell = ByteBuffer.allocate(bytespervalue);
        int cellValue = 0;
        byte[] tmp = new byte[offset - 1];
        thefile.read(tmp);
        ByteBuffer tmpBuffer = ByteBuffer.wrap(tmp);
        tmpBuffer.order(ByteOrder.nativeOrder());
        if (offset - 1 == bytespervalue * this.fileWindow.getCols()) {
            for (int i = 0; i < offset - 1; i += bytespervalue) {
                tmpBuffer.get(cell.array());
                if (bytespervalue == 1) {
                    cellValue = cell.get(0) & 0xFF;
                } else if (bytespervalue == 2) {
                    cellValue = cell.getShort(0);
                } else if (bytespervalue == 4) {
                    cellValue = cell.getInt(0);
                }
                rowdata.putInt(cellValue);
            }
        } else {
            int couples = (offset - 1) / (1 + bytespervalue);
            for (int i = 0; i < couples; ++i) {
                int count = tmpBuffer.get() & 0xFF;
                tmpBuffer.get(cell.array());
                if (bytespervalue == 1) {
                    cellValue = cell.get(0) & 0xFF;
                } else if (bytespervalue == 2) {
                    cellValue = cell.getShort(0);
                } else if (bytespervalue == 4) {
                    cellValue = cell.getInt(0);
                }
                for (int j = 0; j < count; ++j) {
                    rowdata.putInt(cellValue);
                }
            }
        }
    }

    private void readUncompressedIntegerRowByNumber(ByteBuffer rowdata, int rn, RandomAccessFile thefile) throws IOException, DataFormatException {
        int cellValue = 0;
        ByteBuffer cell = ByteBuffer.allocate(this.rasterMapType);
        int filerowsize = this.fileWindow.getCols() * this.rasterMapType;
        thefile.seek(rn * filerowsize);
        ByteBuffer tmpBuffer = ByteBuffer.allocate(filerowsize);
        thefile.read(tmpBuffer.array());
        while (tmpBuffer.hasRemaining()) {
            tmpBuffer.get(cell.array());
            if (this.rasterMapType == 1) {
                cellValue = cell.get(0) & 0xFF;
            } else if (this.rasterMapType == 2) {
                cellValue = cell.getShort(0);
            } else if (this.rasterMapType == 4) {
                cellValue = cell.getInt(0);
            }
            rowdata.putInt(cellValue);
        }
    }

    private boolean readNullValueAtRowCol(int currentfilerow, int currentfilecol) throws IOException {
        if (this.nullFile != null) {
            long byteperrow = (long)Math.ceil((double)this.fileWindow.getCols() / 8.0);
            long currentByte = (long)Math.ceil((double)(currentfilecol + 1) / 8.0);
            long byteToRead = byteperrow * (long)currentfilerow + currentByte;
            this.nullFile.seek(byteToRead - 1L);
            int bitposition = currentfilecol % 8;
            byte[] thetmp = new byte[]{this.nullFile.readByte()};
            BitSet tmp = FileUtilities.fromByteArray(thetmp);
            boolean theBit = tmp.get(7 - bitposition);
            return theBit;
        }
        return false;
    }

    private void setRange(double tmp, int i, int k) {
        if (i == 0 && k == 0 && tmp == tmp) {
            this.range[0] = tmp;
            this.range[1] = tmp;
        } else {
            if (tmp < this.range[0] && tmp == tmp) {
                this.range[0] = tmp;
            }
            if (tmp > this.range[1] && tmp == tmp) {
                this.range[1] = tmp;
            }
        }
    }

    @Override
    public double[] getRange() {
        return this.range;
    }
}

