/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.grasslegacy.map;

import java.awt.Point;
import org.hortonmachine.gears.io.grasslegacy.map.RasterData;

public class JGrassRasterData
implements RasterData {
    private double[][] data = null;

    public JGrassRasterData(double[][] data) {
        this.data = data;
    }

    public JGrassRasterData(double[][] data, double value) {
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                data[i][j] = value;
            }
        }
        this.data = data;
    }

    @Override
    public double getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public double getValueAt(int index) {
        int row = index / this.data[0].length;
        int col = index % this.data[0].length;
        return this.data[row][col];
    }

    @Override
    public double getValueAt(Point point) {
        return this.data[point.x][point.y];
    }

    @Override
    public void setValueAt(int row, int col, double value) {
        this.data[row][col] = value;
    }

    @Override
    public void setValueAt(int index, double value) {
        int row = index / this.data[0].length;
        int col = index % this.data[0].length;
        this.data[row][col] = value;
    }

    @Override
    public int getRows() {
        return this.data.length;
    }

    @Override
    public int getCols() {
        return this.data[0].length;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("JGrass Raster Data Matrix: ").append("rows = ").append(this.data.length).append(" cols = ").append(this.data[0].length);
        return buf.toString();
    }

    @Override
    public double[] getRowValue(int row) {
        return this.data[row];
    }

    @Override
    public double[][] getData() {
        return this.data;
    }
}

