/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.grasslegacy.map;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.hortonmachine.gears.io.grasslegacy.io.MapIOFactory;
import org.hortonmachine.gears.io.grasslegacy.io.MapWriter;
import org.hortonmachine.gears.io.grasslegacy.io.RasterWritingFailureException;
import org.hortonmachine.gears.io.grasslegacy.map.JGrassRasterMapReader;
import org.hortonmachine.gears.io.grasslegacy.map.RasterData;
import org.hortonmachine.gears.io.grasslegacy.utils.Window;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.libs.monitor.LogProgressMonitor;
import org.hortonmachine.gears.utils.files.FileUtilities;

public class JGrassRasterMapWriter {
    private MapWriter writer = null;
    private IHMProgressMonitor monitor = new LogProgressMonitor();
    private String mapName = null;
    private String mapsetName = null;
    private String locationPath = null;
    private String mapPath;
    private String fullMapPath = null;

    public JGrassRasterMapWriter(Window writeWindow, String mapName, String mapsetName, String locationPath, Object novalue, String mapType, IHMProgressMonitor monitor) {
        this.monitor = monitor;
        this.mapName = mapName;
        this.mapsetName = mapsetName;
        this.locationPath = locationPath;
        this.writer = MapIOFactory.createGrassRasterMapWriter(mapType);
        this.writer.setDataWindow(writeWindow);
        this.writer.setParameter("novalue", novalue);
        this.writer.setOutputDataObject(new Double(2.0));
        this.writer.setHistoryComment("Created by JGrass in " + new Date().toString());
        this.fullMapPath = locationPath + File.separator + mapsetName + File.separator + "cell" + File.separator + mapName;
    }

    public JGrassRasterMapWriter(Window writeWindow, String mapPath, Object novalue, String mapType, IHMProgressMonitor monitor) {
        this.monitor = monitor;
        this.mapPath = mapPath;
        this.writer = MapIOFactory.createGrassRasterMapWriter(mapType);
        this.writer.setDataWindow(writeWindow);
        this.writer.setParameter("novalue", novalue);
        this.writer.setOutputDataObject(new Double(2.0));
        this.writer.setHistoryComment("Created by JGrass in " + new Date().toString());
        this.fullMapPath = mapPath;
    }

    public JGrassRasterMapWriter(Window writeWindow, String mapName, String mapsetName, String locationPath, Object novalue, IHMProgressMonitor monitor) {
        this(writeWindow, mapName, mapsetName, locationPath, novalue, "grassbinaryraster", monitor);
    }

    public JGrassRasterMapWriter(Window writeWindow, String mapName, String mapsetName, String locationPath, String mapType, IHMProgressMonitor monitor) {
        this(writeWindow, mapName, mapsetName, locationPath, -9999.0, mapType, monitor);
    }

    public JGrassRasterMapWriter(Window writeWindow, String mapName, String mapsetName, String locationPath, IHMProgressMonitor monitor) {
        this(writeWindow, mapName, mapsetName, locationPath, -9999.0, "grassbinaryraster", monitor);
    }

    public boolean open() throws RasterWritingFailureException {
        boolean ok;
        if (this.mapPath != null) {
            ok = this.writer.open(this.mapPath);
        } else if (this.locationPath != null && this.mapsetName != null && this.mapName != null) {
            ok = this.writer.open(this.mapName, this.locationPath, this.mapsetName);
        } else {
            return false;
        }
        return ok;
    }

    public boolean write(RasterData rasterData) throws RasterWritingFailureException {
        try {
            return this.writer.write(rasterData);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RasterWritingFailureException(e.getLocalizedMessage());
        }
    }

    public void close() {
        this.writer.close();
    }

    public String getFullMapPath() {
        return this.fullMapPath;
    }

    public void cloneColorTableFromReader(JGrassRasterMapReader jgReader) throws IOException {
        String readerMapPath = jgReader.getFullMapPath();
        String tmpMapName = new File(readerMapPath).getName();
        File mapsetFile = new File(readerMapPath).getParentFile().getParentFile();
        String colorFilePath = mapsetFile.getAbsolutePath() + File.separator + "colr" + File.separator + tmpMapName;
        String destMapName = new File(this.fullMapPath).getName();
        File destMapsetFile = new File(this.fullMapPath).getParentFile().getParentFile();
        String destColorFilePath = destMapsetFile.getAbsolutePath() + File.separator + "colr" + File.separator + destMapName;
        FileUtilities.copyFile(colorFilePath, destColorFilePath);
    }

    public void cloneCategoriesFromReader(JGrassRasterMapReader jgReader) throws IOException {
        String readerMapPath = jgReader.getFullMapPath();
        String tmpMapName = new File(readerMapPath).getName();
        File mapsetFile = new File(readerMapPath).getParentFile().getParentFile();
        String catsFilePath = mapsetFile.getAbsolutePath() + File.separator + "cats" + File.separator + tmpMapName;
        String destMapName = new File(this.fullMapPath).getName();
        File destMapsetFile = new File(this.fullMapPath).getParentFile().getParentFile();
        String destCatsFilePath = destMapsetFile.getAbsolutePath() + File.separator + "cats" + File.separator + destMapName;
        FileUtilities.copyFile(catsFilePath, destCatsFilePath);
    }
}

