/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.grasslegacy.map.color;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.hortonmachine.gears.io.grasslegacy.map.JGrassRasterMapReader;
import org.hortonmachine.gears.io.grasslegacy.map.color.ColorTable;
import org.hortonmachine.gears.io.grasslegacy.map.color.PredefinedColorRules;
import org.hortonmachine.gears.io.grasslegacy.utils.JlsTokenizer;
import org.hortonmachine.gears.io.grasslegacy.utils.Window;

public class GrassColorTable
extends ColorTable {
    private File colrFile;
    private int alpha = 255;

    public GrassColorTable(String mapsetPath, String mapName, double[] dataRange) throws IOException {
        this(mapsetPath + File.separator + "colr" + File.separator + mapName, dataRange);
    }

    public GrassColorTable(String colorFilePath, double[] dataRange) throws IOException {
        this.colrFile = new File(colorFilePath);
        if (this.colrFile.exists()) {
            BufferedReader rdr = new BufferedReader(new InputStreamReader(new FileInputStream(this.colrFile)));
            String line = rdr.readLine();
            if (line == null) {
                this.colorTableEmpty = true;
                rdr.close();
                if (this.colrFile.delete()) {
                    System.out.println("removed empty color file");
                }
                return;
            }
            if ((line = line.trim()) == null) {
                return;
            }
            if (line.charAt(0) == '%') {
                String[] stringValues = line.split("\\s+");
                if (stringValues.length == 4) {
                    try {
                        this.alpha = Integer.parseInt(stringValues[3]);
                    }
                    catch (NumberFormatException e) {
                        this.alpha = 255;
                    }
                } else {
                    this.alpha = 255;
                }
                while ((line = rdr.readLine()) != null) {
                    if (line.charAt(0) == '%') continue;
                    this.processGrass4ColorRule(line.trim());
                }
            } else if (line.charAt(0) == '#') {
                int catNumber = Integer.parseInt(line.substring(1, 2));
                this.processGrass3ColorRule(-1, rdr.readLine());
                while ((line = rdr.readLine()) != null) {
                    this.processGrass3ColorRule(catNumber++, line.trim());
                }
            } else {
                int catNumber = 0;
                while ((line = rdr.readLine()) != null) {
                    this.processGrass3ColorRule(catNumber++, line.trim());
                }
            }
            rdr.close();
            this.colorTableEmpty = false;
        } else {
            this.colorTableEmpty = true;
        }
    }

    private void processGrass3ColorRule(int lineNumber, String line) {
        if (line == null) {
            return;
        }
        try {
            JlsTokenizer tk = new JlsTokenizer(line, " ");
            if (lineNumber < 0) {
                if (tk.hasMoreTokens()) {
                    String b;
                    String g = b = tk.nextToken();
                    String r = b;
                    if (tk.hasMoreTokens()) {
                        g = tk.nextToken();
                    }
                    if (tk.hasMoreTokens()) {
                        b = tk.nextToken();
                    }
                    if (r.indexOf(46) == -1) {
                        this.setBackgroundColor(new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b)));
                    } else {
                        this.setBackgroundColor(new Color(Float.parseFloat(r), Float.parseFloat(g), Float.parseFloat(b)));
                    }
                }
            } else {
                String b;
                String g = b = tk.nextToken();
                String r = b;
                if (tk.hasMoreTokens()) {
                    g = tk.nextToken();
                }
                if (tk.hasMoreTokens()) {
                    b = tk.nextToken();
                }
                if (r.indexOf(46) == -1) {
                    this.addColorRule(lineNumber, Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
                } else {
                    this.addColorRule(lineNumber, (int)(Float.parseFloat(r) * 255.0f), (int)(Float.parseFloat(g) * 255.0f), (int)(Float.parseFloat(b) * 255.0f));
                }
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
    }

    private void processGrass4ColorRule(String line) {
        int r0 = -1;
        int g0 = -1;
        int b0 = -1;
        int r1 = -1;
        int g1 = -1;
        int b1 = -1;
        float cat0 = 0.0f;
        float cat1 = 0.0f;
        if (line == null) {
            return;
        }
        try {
            JlsTokenizer tk = new JlsTokenizer(line, " ");
            if (tk.hasMoreTokens()) {
                JlsTokenizer tk1 = new JlsTokenizer(tk.nextToken(), ":");
                cat0 = Float.parseFloat(tk1.nextToken());
                g0 = b0 = Integer.parseInt(tk1.nextToken());
                r0 = b0;
                if (tk1.hasMoreTokens()) {
                    g0 = b0 = Integer.parseInt(tk1.nextToken());
                }
                if (tk1.hasMoreTokens()) {
                    b0 = Integer.parseInt(tk1.nextToken());
                }
                if (tk.hasMoreTokens()) {
                    tk1 = new JlsTokenizer(tk.nextToken(), ":");
                    cat1 = Float.parseFloat(tk1.nextToken());
                    g1 = b1 = Integer.parseInt(tk1.nextToken());
                    r1 = b1;
                    if (tk1.hasMoreTokens()) {
                        g1 = b1 = Integer.parseInt(tk1.nextToken());
                    }
                    if (tk1.hasMoreTokens()) {
                        b1 = Integer.parseInt(tk1.nextToken());
                    }
                }
                if (r1 == -1) {
                    this.addColorRule((int)cat0, r0, g0, b0);
                } else {
                    this.addColorRule(cat0, r0, g0, b0, cat1, r1, g1, b1);
                }
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void createDefaultColorTable(double[] dataRange) {
        int[][] rainbow = PredefinedColorRules.rainbow;
        ArrayList<String> rules = new ArrayList<String>();
        float rinc = (float)(dataRange[1] - dataRange[0]) / 5.0f;
        for (int i = 0; i < 4; ++i) {
            this.addColorRule((float)(dataRange[0] + (double)((float)i * rinc)), rainbow[i][0], rainbow[i][1], rainbow[i][2], (float)(dataRange[0] + (double)((float)(i + 1) * rinc)), rainbow[i + 1][0], rainbow[i + 1][1], rainbow[i + 1][2]);
            StringBuffer rule = new StringBuffer();
            rule.append(dataRange[0] + (double)((float)i * rinc) + ":");
            rule.append(rainbow[i][0] + ":" + rainbow[i][1] + ":" + rainbow[i][2] + " ");
            rule.append(dataRange[0] + (double)((float)(i + 1) * rinc) + ":");
            rule.append(rainbow[i + 1][0] + ":" + rainbow[i + 1][1] + ":" + rainbow[i + 1][2] + " ");
            rules.add(rule.toString());
        }
        this.addColorRule((float)(dataRange[1] - (double)rinc), rainbow[4][0], rainbow[4][1], rainbow[4][2], (float)dataRange[1], rainbow[5][0], rainbow[5][1], rainbow[5][2]);
        StringBuffer rule = new StringBuffer();
        rule.append(dataRange[1] - (double)rinc + ":");
        rule.append(rainbow[4][0] + ":" + rainbow[4][1] + ":" + rainbow[4][2] + " ");
        rule.append(dataRange[1] + ":");
        rule.append(rainbow[5][0] + ":" + rainbow[5][1] + ":" + rainbow[5][2] + " ");
        rules.add(rule.toString());
        if (!this.colrFile.exists()) {
            BufferedWriter bw = null;
            try {
                File colFolder = this.colrFile.getParentFile();
                if (!colFolder.exists()) {
                    colFolder.mkdirs();
                }
                bw = new BufferedWriter(new FileWriter(this.colrFile));
                String header = "% " + dataRange[0] + "   " + dataRange[1] + "   255";
                bw.write(header + "\n");
                for (String string : rules) {
                    bw.write(string + "\n");
                }
                bw.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static String setColorTableFromRules(File colrFile, double[] dataRange, int[][] colorRules) throws IOException {
        if (dataRange == null) {
            dataRange = new double[2];
            String name = colrFile.getName();
            File mapsetFile = colrFile.getParentFile().getParentFile();
            String mapsetPath = mapsetFile.getAbsolutePath();
            String mapsetName = mapsetFile.getName();
            String locationPath = mapsetFile.getParent();
            String activeWindowPath = mapsetPath + File.separator + "WIND";
            String rangePath = mapsetPath + File.separator + "cell_misc" + File.separator + name + File.separator + "f_range";
            File ds = new File(rangePath);
            boolean fileok = true;
            int testread = 0;
            if (ds.exists()) {
                FileInputStream is = null;
                is = new FileInputStream(ds);
                byte[] numbers = new byte[16];
                try {
                    testread = ((InputStream)is).read(numbers);
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    fileok = false;
                    e.printStackTrace();
                }
                if (testread == 16) {
                    ByteBuffer rangeBuffer = ByteBuffer.wrap(numbers);
                    dataRange[0] = rangeBuffer.getDouble();
                    dataRange[1] = rangeBuffer.getDouble();
                } else {
                    fileok = false;
                }
            } else {
                fileok = false;
            }
            if (!fileok) {
                JGrassRasterMapReader jGrassMapReader = new JGrassRasterMapReader.BuilderFromPathAndNames(new Window(activeWindowPath), name, mapsetName, locationPath).build();
                if (!jGrassMapReader.open()) {
                    throw new IOException("An error occurred while reading the map.");
                }
                while (jGrassMapReader.hasMoreData()) {
                    jGrassMapReader.getNextData();
                }
                dataRange = jGrassMapReader.getRange();
                jGrassMapReader.close();
            }
        }
        float rinc = (float)(dataRange[1] - dataRange[0]) / (float)(colorRules.length - 1);
        StringBuffer rule = new StringBuffer();
        rule.append("% " + dataRange[0] + "   " + dataRange[1] + "   255\n");
        for (int i = 0; i < colorRules.length - 2; ++i) {
            rule.append(dataRange[0] + (double)((float)i * rinc) + ":");
            rule.append(colorRules[i][0] + ":" + colorRules[i][1] + ":" + colorRules[i][2] + " ");
            rule.append(dataRange[0] + (double)((float)(i + 1) * rinc) + ":");
            rule.append(colorRules[i + 1][0] + ":" + colorRules[i + 1][1] + ":" + colorRules[i + 1][2] + "\n");
        }
        rule.append(dataRange[1] - (double)rinc + ":");
        rule.append(colorRules[colorRules.length - 2][0] + ":" + colorRules[colorRules.length - 2][1] + ":" + colorRules[colorRules.length - 2][2] + " ");
        rule.append(dataRange[1] + ":");
        rule.append(colorRules[colorRules.length - 1][0] + ":" + colorRules[colorRules.length - 1][1] + ":" + colorRules[colorRules.length - 1][2] + "\n");
        BufferedWriter bw = new BufferedWriter(new FileWriter(colrFile));
        bw.write(rule.toString());
        bw.close();
        return rule.toString();
    }

    public String createDefaultColorRulesString(double[] dataRange, boolean writeToDisk) throws Exception {
        int[][] rainbow = PredefinedColorRules.rainbow;
        if (dataRange == null) {
            dataRange = new double[2];
            String name = this.colrFile.getName();
            File mapsetFile = this.colrFile.getParentFile().getParentFile();
            String mapsetPath = mapsetFile.getAbsolutePath();
            String mapsetName = mapsetFile.getName();
            String locationPath = mapsetFile.getParent();
            String activeWindowPath = mapsetPath + File.separator + "WIND";
            String rangePath = mapsetPath + File.separator + "cell_misc" + File.separator + name + File.separator + "f_range";
            File ds = new File(rangePath);
            boolean fileok = true;
            int testread = 0;
            if (ds.exists()) {
                FileInputStream is = null;
                try {
                    is = new FileInputStream(ds);
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                byte[] numbers = new byte[16];
                try {
                    testread = ((InputStream)is).read(numbers);
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    fileok = false;
                    e.printStackTrace();
                }
                if (testread == 16) {
                    ByteBuffer rangeBuffer = ByteBuffer.wrap(numbers);
                    dataRange[0] = rangeBuffer.getDouble();
                    dataRange[1] = rangeBuffer.getDouble();
                } else {
                    fileok = false;
                }
            } else {
                fileok = false;
            }
            if (!fileok) {
                JGrassRasterMapReader jGrassMapReader = new JGrassRasterMapReader.BuilderFromPathAndNames(new Window(activeWindowPath), name, mapsetName, locationPath).build();
                if (!jGrassMapReader.open()) {
                    return null;
                }
                while (jGrassMapReader.hasMoreData()) {
                    jGrassMapReader.getNextData();
                }
                dataRange = jGrassMapReader.getRange();
                jGrassMapReader.close();
            }
        }
        float rinc = (float)(dataRange[1] - dataRange[0]) / 5.0f;
        StringBuffer rule = new StringBuffer();
        rule.append("% " + dataRange[0] + "   " + dataRange[1] + "   255\n");
        for (int i = 0; i < 4; ++i) {
            rule.append(dataRange[0] + (double)((float)i * rinc) + ":");
            rule.append(rainbow[i][0] + ":" + rainbow[i][1] + ":" + rainbow[i][2] + " ");
            rule.append(dataRange[0] + (double)((float)(i + 1) * rinc) + ":");
            rule.append(rainbow[i + 1][0] + ":" + rainbow[i + 1][1] + ":" + rainbow[i + 1][2] + "\n");
        }
        rule.append(dataRange[1] - (double)rinc + ":");
        rule.append(rainbow[4][0] + ":" + rainbow[4][1] + ":" + rainbow[4][2] + " ");
        rule.append(dataRange[1] + ":");
        rule.append(rainbow[5][0] + ":" + rainbow[5][1] + ":" + rainbow[5][2] + "\n");
        if (writeToDisk) {
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(this.colrFile));
                bw.write(rule.toString());
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rule.toString();
    }

    public File getColrFile() {
        return this.colrFile;
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }
}

