/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.grasslegacy.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;

public class FileUtilities {
    public static byte[] double2bytearray(double rastervalue) {
        long l = Double.doubleToLongBits(rastervalue);
        byte[] b = new byte[8];
        int shift = 56;
        int k = 0;
        while (k < 8) {
            b[k] = (byte)(l >>> shift);
            ++k;
            shift -= 8;
        }
        return b;
    }

    public static BitSet fromByteArray(byte[] bytes) {
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[bytes.length - i / 8 - 1] & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public static BitSet fromByte(byte thebyte) {
        BitSet bits = new BitSet();
        for (int i = 0; i < 8; ++i) {
            if ((thebyte & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public static byte[] BitSet2ByteArray(BitSet bs) {
        byte[] bytes = new byte[bs.size() / 8 + 1];
        for (int i = 0; i < bs.size(); ++i) {
            if (!bs.get(i)) continue;
            int n = i / 8;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }

    public static byte[] toByteArray(BitSet bits) {
        byte[] bytes = new byte[bits.length() / 8 + 1];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int n = bytes.length - i / 8 - 1;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }

    public static void copyFile(String fromFile, String toFile) {
        File in = new File(fromFile);
        File out = new File(toFile);
        FileUtilities.copyFile(in, out);
    }

    public static void copyFile(File in, File out) {
        try {
            FileInputStream fis = new FileInputStream(in);
            FileOutputStream fos = new FileOutputStream(out);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
            fis.close();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static float arr2float(byte[] arr, int start) {
        int i = 0;
        int len = 4;
        int cnt = 0;
        byte[] tmp = new byte[len];
        for (i = start; i < start + len; ++i) {
            tmp[cnt] = arr[i];
            ++cnt;
        }
        int accum = 0;
        i = 0;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            accum = (int)((long)accum | (long)(tmp[i] & 0xFF) << shiftBy);
            ++i;
        }
        return Float.intBitsToFloat(accum);
    }

    public static int arr2int(byte[] arr, int start) {
        int low = arr[start] & 0xFF;
        int high = arr[start + 1] & 0xFF;
        return high << 8 | low;
    }

    public static long arr2long(byte[] arr, int start) {
        int i = 0;
        int len = 4;
        int cnt = 0;
        byte[] tmp = new byte[len];
        for (i = start; i < start + len; ++i) {
            tmp[cnt] = arr[i];
            ++cnt;
        }
        long accum = 0L;
        i = 0;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            accum |= (long)(tmp[i] & 0xFF) << shiftBy;
            ++i;
        }
        return accum;
    }

    public static double arr2double(byte[] arr, int start) {
        int i = 0;
        int len = 8;
        int cnt = 0;
        byte[] tmp = new byte[len];
        for (i = start; i < start + len; ++i) {
            tmp[cnt] = arr[i];
            ++cnt;
        }
        long accum = 0L;
        i = 0;
        for (int shiftBy = 0; shiftBy < 64; shiftBy += 8) {
            accum |= (long)(tmp[i] & 0xFF) << shiftBy;
            ++i;
        }
        return Double.longBitsToDouble(accum);
    }

    public static boolean deleteFileOrDir(File filehandle) {
        boolean isdel;
        if (filehandle.isDirectory()) {
            String[] children = filehandle.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtilities.deleteFileOrDir(new File(filehandle, children[i]));
                if (success) continue;
                return false;
            }
        }
        if (!(isdel = filehandle.delete())) {
            filehandle.deleteOnExit();
        }
        return isdel;
    }

    public static boolean deleteFileOrDirOnExit(File filehandle) {
        if (filehandle.isDirectory()) {
            String[] children = filehandle.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtilities.deleteFileOrDir(new File(filehandle, children[i]));
                if (success) continue;
                return false;
            }
        }
        filehandle.deleteOnExit();
        return true;
    }

    public static String readInputStreamToString(InputStream inputStream) {
        try {
            ArrayList<Byte> bytesList = new ArrayList<Byte>();
            byte b = 0;
            while ((b = (byte)inputStream.read()) != -1) {
                bytesList.add(b);
            }
            inputStream.close();
            byte[] bArray = new byte[bytesList.size()];
            for (int i = 0; i < bArray.length; ++i) {
                bArray[i] = (Byte)bytesList.get(i);
            }
            String file = new String(bArray);
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String replaceBackSlashes(String path) {
        return path.replaceAll("\\\\", "\\\\\\\\");
    }

    public static String getNameWithoutExtention(File file) {
        String name = file.getName();
        int lastDot = name.lastIndexOf(".");
        name = name.substring(0, lastDot);
        return name;
    }
}

