/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.grasslegacy.utils;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public abstract class GDataObject {
    public static final int POINT_DATA = 1;
    public static final int VECTOR_DATA = 2;
    public static final int RASTER_DATA = 3;
    public static final Integer VECTOR_LINE_DATA = new Integer(1);
    public static final Integer VECTOR_AREA_DATA = new Integer(2);
    public static final int USE_BACKING_FILE = 1;
    public static final int USE_BACKING_MEMORY = 2;
    public static final int COLUMN_TYPE_DOUBLE = -1;
    public static final int COLUMN_TYPE_INT = -2;
    public static final int COLUMN_TYPE_FLOAT = -3;
    public static final int COLUMN_TYPE_STRING = 256;
    protected boolean dataIsVolatile = false;
    protected DataStore dstore = null;
    private ArrayList columnNames = null;
    public static Vector rafHandles = new Vector(20);

    public GDataObject() {
        this.dataIsVolatile = false;
        this.dstore = null;
        this.columnNames = new ArrayList();
    }

    public GDataObject(int dtype, int[] xyz, int[] c) {
        this.columnNames = new ArrayList();
        this.dataIsVolatile = false;
        this.dstore = new DataStore(dtype, xyz, c, 0, 1);
        this.createColumnHeader(this.dstore.getColumnCount());
    }

    public GDataObject(int dtype, int use) {
        this.columnNames = null;
        this.dataIsVolatile = false;
        this.dstore = new DataStore(dtype, null, null, 0, use);
    }

    public GDataObject(int dtype, ByteBuffer buf) {
        this.columnNames = null;
        this.dataIsVolatile = false;
        this.dstore = new DataStore(dtype, buf);
    }

    public GDataObject(int dtype, int len, int use) {
        this.columnNames = null;
        this.dataIsVolatile = false;
        this.dstore = new DataStore(dtype, null, null, len, use);
    }

    private void createColumnHeader(int cols) {
        for (int i = 0; i < cols; ++i) {
            this.columnNames.add(String.valueOf((char)(65 + i)));
        }
    }

    public boolean hasData() {
        return this.dstore.rows != 0;
    }

    public ByteBuffer getReadBuffer() {
        return this.dstore.readBuffer;
    }

    public ByteBuffer setReadBuffer(ByteBuffer newBuffer) {
        this.dstore.readBuffer = null;
        this.dstore.readBuffer = newBuffer;
        return newBuffer;
    }

    public void setColumnNames(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            this.columnNames.set(i, names[i]);
        }
    }

    public void setColumnName(int col, String name) {
        this.columnNames.set(col, name);
    }

    public String getColumnName(int col) {
        return (String)this.columnNames.get(col);
    }

    public int getColumnType(int col) {
        return this.dstore == null ? 0 : this.dstore.getColumnType(col);
    }

    public Object get(int row, int col) {
        return this.dstore == null ? null : this.dstore.get(row, col);
    }

    public void writeRow(Vector v) {
        if (this.dstore != null) {
            this.dstore.writeRow(v);
        }
    }

    public void setInt(int row, int col, int val) {
    }

    public void setFloat(int row, int col, float val) {
    }

    public void setDouble(int row, int col, double val) {
    }

    public void setString(int row, int col, String val) {
    }

    public Enumeration enumerator() {
        return this.dstore.initEnumerator();
    }

    public int getColumnCount() {
        return this.dstore.columns == null ? -1 : this.dstore.columns.length;
    }

    public int getRowCount() {
        return this.dstore.rows;
    }

    private class DataStore
    implements Enumeration {
        private File backingTempFile = null;
        private RandomAccessFile backingFile = null;
        protected int rows = 0;
        protected int[] columns = null;
        protected int offset = 0;
        protected int bytesToRead = 0;
        protected int columnwidth = 0;
        private int backing = 0;
        protected ByteBuffer readBuffer = null;
        protected int dataType = 0;

        private DataStore(int dtype, int[] xyz, int[] c, int len, int backingType) {
            this.dataType = dtype;
            this.backing = backingType;
            if (dtype == 3) {
                this.columns = null;
                this.columnwidth = 0;
                if (backingType == 2 || backingType == 1) {
                    this.readBuffer = ByteBuffer.allocate(len);
                } else if (backingType == 1) {
                    try {
                        this.backingFile = this.createBackingFile(len);
                        this.readBuffer = null;
                        this.readBuffer = this.backingFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.backingFile.length()).force().load();
                        this.readBuffer.rewind();
                    }
                    catch (Exception e) {
                        this.backingTempFile = null;
                        this.backingFile = null;
                    }
                }
            } else if (dtype == 1) {
                int i;
                this.columns = new int[3 + (c == null ? 0 : c.length)];
                for (i = 0; i < xyz.length; ++i) {
                    this.columns[i] = xyz[i];
                    this.columnwidth += xyz[i] == -1 ? 8 : (xyz[i] == -3 ? 4 : (xyz[i] == -2 ? 4 : xyz[i]));
                }
                if (c != null) {
                    for (i = 0; i < c.length; ++i) {
                        this.columns[i + 3] = c[i];
                        this.columnwidth += c[i] == -1 ? 8 : (c[i] == -3 ? 4 : (c[i] == -2 ? 4 : c[i]));
                    }
                }
                if (backingType == 1) {
                    try {
                        this.backingFile = this.createBackingFile(0);
                    }
                    catch (Exception e) {
                        this.backingTempFile = null;
                        this.backingFile = null;
                    }
                }
            } else if (dtype == 2 && backingType == 1) {
                try {
                    this.backingFile = this.createBackingFile(0);
                }
                catch (Exception e) {
                    this.backingTempFile = null;
                    this.backingFile = null;
                }
            }
        }

        private DataStore(int dtype, ByteBuffer buf) {
            if (dtype == 3) {
                this.columns = null;
                this.columnwidth = 0;
                this.backing = 2;
                this.readBuffer = buf;
            }
        }

        public int getRowCount() {
            return this.rows;
        }

        public int getColumnCount() {
            return this.columns == null ? -1 : this.columns.length;
        }

        public int getColumnType(int col) {
            return this.columns[col];
        }

        public void writeRow(Vector v) {
            if (this.dataType == 1) {
                if (this.columns != null) {
                    int[] c = this.columns;
                    for (int i = 0; i < c.length; ++i) {
                        if (i >= v.size()) continue;
                        if (c[i] == -3) {
                            if (i < 3) {
                                this.writeFloat(((Double)v.elementAt(i)).floatValue());
                                continue;
                            }
                            this.writeFloat(((Float)v.elementAt(i)).floatValue());
                            continue;
                        }
                        if (c[i] == -1) {
                            this.writeDouble((Double)v.elementAt(i));
                            continue;
                        }
                        if (c[i] == -2) {
                            if (i < 3) {
                                this.writeInt(((Double)v.elementAt(i)).intValue());
                                continue;
                            }
                            this.writeInt((Integer)v.elementAt(i));
                            continue;
                        }
                        if (c[i] != 256) continue;
                        this.writeString((String)v.elementAt(i));
                    }
                    ++this.rows;
                }
            } else if (this.dataType == 2) {
                int i;
                this.writeInt((Integer)v.elementAt(0));
                int numParts = (Integer)v.elementAt(1);
                this.writeInt(numParts);
                int numPoints = (Integer)v.elementAt(2);
                this.writeInt(numPoints);
                for (i = 0; i < numParts; ++i) {
                    this.writeInt((Integer)v.elementAt(3 + i));
                }
                for (i = 0; i < numPoints * 2; ++i) {
                    this.writeFloat(((Float)v.elementAt(3 + numParts + i)).floatValue());
                }
                this.rows += numPoints;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void writeFloat(float f) {
            try {
                if (this.backing == 1) {
                    this.backingFile.writeFloat(f);
                    return;
                }
                if (this.backing != 2) return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void writeDouble(double d) {
            try {
                if (this.backing == 1) {
                    this.backingFile.writeDouble(d);
                    return;
                }
                if (this.backing != 2) return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void writeInt(int i) {
            try {
                if (this.backing == 1) {
                    this.backingFile.writeInt(i);
                    return;
                }
                if (this.backing != 2) return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void writeString(String s) {
            try {
                if (this.backing == 1) {
                    StringBuffer buf = new StringBuffer(256);
                    buf.insert(0, s);
                    buf.setLength(256);
                    this.backingFile.writeBytes(buf.toString());
                    return;
                }
                if (this.backing != 2) return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public DataStore initEnumerator() {
            try {
                if (this.dataType == 1) {
                    if (this.backing == 1) {
                        this.readBuffer = null;
                        this.readBuffer = this.backingFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.backingFile.length()).force().load();
                    } else if (this.backing == 2) {
                        this.readBuffer.rewind();
                    }
                    this.offset = 0;
                    this.bytesToRead = this.columnwidth;
                    return this;
                }
                if (this.dataType == 2) {
                    if (this.backing == 1) {
                        this.readBuffer = null;
                        this.readBuffer = this.backingFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.backingFile.length()).force().load();
                    } else if (this.backing == 2) {
                        this.readBuffer.rewind();
                    }
                    this.offset = 0;
                    this.bytesToRead = this.readBuffer.getInt(0) * 8 + 4;
                    return this;
                }
                if (this.dataType == 3) {
                    if (this.backing == 2) {
                        this.readBuffer.rewind();
                    }
                    return this;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public boolean hasMoreElements() {
            return this.bytesToRead <= this.readBuffer.limit() - this.offset;
        }

        public Object nextElement() {
            if (this.dataType == 2) {
                int numParts = this.readBuffer.getInt(this.offset + 4);
                int numPoints = this.readBuffer.getInt(this.offset + 8);
                this.bytesToRead = numParts * 4 + numPoints * 8 + 12;
            }
            this.readBuffer.position(this.offset);
            this.offset += this.bytesToRead;
            return this.readBuffer;
        }

        public Object get(int row, int col) {
            if (col < 0 || col >= this.columns.length) {
                return "";
            }
            if (row < 0 || row >= this.rows) {
                return "";
            }
            int offset = 0;
            for (int i = 0; i < col; ++i) {
                offset += this.columns[i] == -1 ? 8 : (this.columns[i] == -3 ? 4 : (this.columns[i] == -2 ? 4 : this.columns[i]));
            }
            offset += row * this.columnwidth;
            if (this.columns[col] == -3) {
                return new Float(this.readBuffer.getFloat(offset));
            }
            if (this.columns[col] == -1) {
                return new Double(this.readBuffer.getDouble(offset));
            }
            if (this.columns[col] == -2) {
                return new Integer(this.readBuffer.getInt(offset));
            }
            byte[] s = new byte[this.columns[col]];
            this.readBuffer.position(offset);
            this.readBuffer.get(s, 0, this.columns[col]);
            return new String(s, 0, this.columns[col]).trim();
        }

        private RandomAccessFile createBackingFile(int len) throws IOException {
            this.backingTempFile = File.createTempFile("jgrass", "dat");
            this.backingTempFile.deleteOnExit();
            RandomAccessFile raf = new RandomAccessFile(this.backingTempFile, "rw");
            if (len > 0) {
                raf.setLength(len);
            }
            rafHandles.add(raf);
            return raf;
        }

        public String toString() {
            return "datatype=" + (this.dataType == 3 ? "RASTER" : (this.dataType == 1 ? "POINT" : "VECTOR")) + ", rows=" + this.rows + ", columns=" + (String)(this.columns == null ? "" : "" + this.columns.length) + ", backing=" + (this.backing == 1 ? this.backingTempFile.getName() : "MEMORY") + ", limit=" + (String)(this.readBuffer == null ? "" : "" + this.readBuffer.limit());
        }
    }

    public static class GridData
    extends GDataObject {
        public GridData(int size, int backing) {
            super(3, size, backing);
        }

        public GridData(int size) {
            super(3, size, 2);
        }

        public GridData(ByteBuffer buf) {
            super(3, buf);
        }

        public String toString() {
            return "RasterData object, datastore=" + this.dstore.toString();
        }
    }

    public static class VectorData
    extends GDataObject {
        public VectorData() {
            super(2, 1);
        }

        public String toString() {
            return "VectorData object, datastore=" + this.dstore.toString();
        }
    }

    public static class PointData
    extends GDataObject {
        public PointData(int[] c) {
            super(1, new int[]{-1, -1, -1}, c);
        }

        public String toString() {
            return "PointData object, " + this.dstore.toString();
        }
    }
}

