/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.las;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.hortonmachine.dbs.compat.EDb;
import org.hortonmachine.gears.io.las.DatabaseLasDataManager;
import org.hortonmachine.gears.io.las.LasFileDataManager;
import org.hortonmachine.gears.io.las.LasFolderIndexDataManager;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class ALasDataManager
implements AutoCloseable {
    protected GeometryFactory gf = GeometryUtilities.gf();
    protected double[] intensityRange;
    protected double[] impulses;
    protected int impulsesNum = -1;
    protected double[] classes;
    protected boolean hasConstraint = false;
    protected CoordinateReferenceSystem crs;

    public static ALasDataManager getDataManager(File dataFile, GridCoverage2D inDem, double elevThreshold, CoordinateReferenceSystem inCrs) {
        String lcName = dataFile.getName().toLowerCase();
        if (lcName.endsWith(".las") || lcName.endsWith(".laz")) {
            return new LasFileDataManager(dataFile, inDem, elevThreshold, inCrs);
        }
        if (lcName.equals("index.lasfolder")) {
            return new LasFolderIndexDataManager(dataFile, inDem, elevThreshold, inCrs);
        }
        try {
            EDb edb = EDb.fromFileDesktop((File)dataFile);
            if (edb != null && edb.isSpatial()) {
                return new DatabaseLasDataManager(dataFile, inDem, elevThreshold, inCrs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("Can only read .las and index.lasfolder files.");
    }

    public abstract File getFile();

    public abstract void open() throws Exception;

    public void setIntensityConstraint(double[] minMax) {
        if (minMax == null) {
            return;
        }
        this.intensityRange = minMax;
        this.hasConstraint = true;
    }

    public void setImpulsesConstraint(double[] impulsesToKeep) {
        if (impulsesToKeep == null) {
            return;
        }
        this.impulses = impulsesToKeep;
        this.hasConstraint = true;
    }

    public void setImpulsesNumConstraint(int impulsesNumToKeep) {
        this.impulsesNum = impulsesNumToKeep;
        this.hasConstraint = true;
    }

    public void setClassesConstraint(double[] classesToKeep) {
        if (classesToKeep == null) {
            return;
        }
        this.classes = classesToKeep;
        this.hasConstraint = true;
    }

    public abstract List<LasRecord> getPointsInGeometry(Geometry var1, boolean var2) throws Exception;

    public abstract List<Geometry> getEnvelopesInGeometry(Geometry var1, boolean var2, double[] var3) throws Exception;

    public abstract ReferencedEnvelope getOverallEnvelope() throws Exception;

    public abstract List<ReferencedEnvelope> getEnvelopeList() throws Exception;

    public abstract ReferencedEnvelope3D getEnvelope3D() throws Exception;

    public abstract SimpleFeatureCollection getOverviewFeatures() throws Exception;

    public synchronized SimpleFeatureCollection getEnvelopeFeaturesInGeometry(Geometry checkGeom, boolean doOnlyEnvelope, double[] minMaxZI, boolean doPoints) throws Exception {
        List<Geometry> envelopesInGeometry = this.getEnvelopesInGeometry(checkGeom, doOnlyEnvelope, null);
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("overview");
        b.setCRS(this.crs);
        if (!doPoints) {
            b.add("the_geom", Polygon.class);
        } else {
            b.add("the_geom", Point.class);
        }
        b.add("elev", Double.class);
        b.add("intensity", Double.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        double minI = Double.POSITIVE_INFINITY;
        double maxI = Double.NEGATIVE_INFINITY;
        DefaultFeatureCollection newFeatures = new DefaultFeatureCollection();
        for (int i = 0; i < envelopesInGeometry.size(); ++i) {
            Geometry geom = envelopesInGeometry.get(i);
            if (doPoints) {
                Envelope envelope = geom.getEnvelopeInternal();
                Coordinate centre = envelope.centre();
                geom = this.gf.createPoint(centre);
            }
            double elev = -9999.0;
            double intens = -9999.0;
            Object userData = geom.getUserData();
            if (userData instanceof double[]) {
                double[] data = (double[])userData;
                elev = data[0];
                intens = data[1];
            }
            if (minMaxZI != null) {
                minZ = Math.min(minZ, elev);
                maxZ = Math.max(maxZ, elev);
                minI = Math.min(minI, intens);
                maxI = Math.max(maxI, intens);
            }
            Object[] objs = new Object[]{geom, elev, intens};
            builder.addAll(objs);
            SimpleFeature feature = builder.buildFeature(null);
            newFeatures.add(feature);
        }
        if (minMaxZI != null) {
            minMaxZI[0] = minZ;
            minMaxZI[1] = maxZ;
            minMaxZI[2] = minI;
            minMaxZI[3] = maxI;
        }
        return newFeatures;
    }

    protected boolean doAccept(LasRecord lasDot) {
        short numOfReturns;
        if (!this.hasConstraint) {
            return true;
        }
        boolean takeIt = true;
        if (this.intensityRange != null) {
            short intensity = lasDot.intensity;
            if ((double)intensity >= this.intensityRange[0] && (double)intensity <= this.intensityRange[1]) {
                takeIt = true;
            } else {
                return false;
            }
        }
        if (this.impulses != null) {
            short impulse = lasDot.returnNumber;
            takeIt = false;
            for (double imp : this.impulses) {
                if (impulse != (int)imp) continue;
                takeIt = true;
                break;
            }
            if (!takeIt) {
                return false;
            }
        }
        if (this.impulsesNum != -1 && (numOfReturns = lasDot.numberOfReturns) != this.impulsesNum) {
            return false;
        }
        if (this.classes != null) {
            byte classification = lasDot.classification;
            takeIt = false;
            for (double classs : this.classes) {
                if (classification != (int)classs) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static List<LasRecord> getPointsInVerticalRange(List<LasRecord> pointsList, double min, double max, boolean isGroundElev) {
        ArrayList<LasRecord> pointsListInVertical = new ArrayList<LasRecord>();
        if (!isGroundElev) {
            for (LasRecord lasRecord : pointsList) {
                if (!NumericsUtilities.isBetween(lasRecord.z, min, max)) continue;
                pointsListInVertical.add(lasRecord);
            }
        } else {
            for (LasRecord lasRecord : pointsList) {
                if (!NumericsUtilities.isBetween(lasRecord.groundElevation, min, max)) continue;
                pointsListInVertical.add(lasRecord);
            }
        }
        return pointsListInVertical;
    }

    public static List<LasRecord> getPointsInHeightRange(List<LasRecord> pointsList, double min, double max) {
        ArrayList<LasRecord> pointsListInVertical = new ArrayList<LasRecord>();
        for (LasRecord lasRecord : pointsList) {
            if (!NumericsUtilities.isBetween(lasRecord.groundElevation, min, max)) continue;
            pointsListInVertical.add(lasRecord);
        }
        return pointsListInVertical;
    }
}

