/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.las;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.hortonmachine.dbs.compat.ASpatialDb;
import org.hortonmachine.dbs.compat.EDb;
import org.hortonmachine.dbs.compat.GeometryColumn;
import org.hortonmachine.gears.io.las.ALasDataManager;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.io.las.databases.LasCell;
import org.hortonmachine.gears.io.las.databases.LasCellsTable;
import org.hortonmachine.gears.io.las.databases.LasSource;
import org.hortonmachine.gears.io.las.databases.LasSourcesTable;
import org.hortonmachine.gears.io.las.index.LasIndexer;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class DatabaseLasDataManager
extends ALasDataManager {
    private File databaseFile;
    private GridCoverage2D inDem;
    private double elevThreshold;
    private SimpleFeatureCollection overviewFeatures;
    private ReferencedEnvelope referencedEnvelope2D;
    private List<ReferencedEnvelope> referencedEnvelope2DList = new ArrayList<ReferencedEnvelope>();
    private ReferencedEnvelope3D referencedEnvelope3D;
    private boolean isOpen;
    private ASpatialDb spatialDb;

    DatabaseLasDataManager(File databaseFile, GridCoverage2D inDem, double elevThreshold, CoordinateReferenceSystem inCrs) {
        this.databaseFile = databaseFile;
        this.inDem = inDem;
        this.elevThreshold = elevThreshold;
    }

    @Override
    public File getFile() {
        return this.databaseFile;
    }

    @Override
    public void open() throws Exception {
        EDb edb = EDb.fromFileDesktop((File)this.databaseFile);
        this.spatialDb = edb.getSpatialDb();
        this.spatialDb.open(this.databaseFile.getAbsolutePath());
        GeometryColumn geometryColumnsForTable = this.spatialDb.getGeometryColumnsForTable("lascells");
        this.crs = CrsUtilities.getCrsFromSrid(geometryColumnsForTable.srid);
        this.isOpen = true;
    }

    @Override
    public synchronized List<LasRecord> getPointsInGeometry(Geometry checkGeom, boolean doOnlyEnvelope) throws Exception {
        this.checkOpen();
        ArrayList<LasRecord> pointsListForTile = new ArrayList<LasRecord>();
        Envelope checkEnvelope = checkGeom.getEnvelopeInternal();
        PreparedGeometry preparedGeometry = null;
        if (!doOnlyEnvelope) {
            preparedGeometry = PreparedGeometryFactory.prepare((Geometry)checkGeom);
        }
        PreparedGeometry _preparedGeometry = preparedGeometry;
        List<LasCell> lasCells = LasCellsTable.getLasCells(this.spatialDb, checkGeom, true, true, false, false, false);
        lasCells.stream().forEach(cell -> {
            double[][] positions = LasCellsTable.getCellPositions(cell);
            short[][] cellIntensityClass = LasCellsTable.getCellIntensityClass(cell);
            for (int i = 0; i < positions.length; ++i) {
                LasRecord dot = new LasRecord();
                dot.x = positions[i][0];
                dot.y = positions[i][1];
                dot.z = positions[i][2];
                Coordinate c = new Coordinate(dot.x, dot.y);
                if (doOnlyEnvelope && !checkEnvelope.contains(c) || !doOnlyEnvelope && !_preparedGeometry.contains((Geometry)this.gf.createPoint(c))) continue;
                if (this.inDem != null) {
                    double value = CoverageUtilities.getValue(this.inDem, c);
                    if (HMConstants.isNovalue(value)) continue;
                    double height = dot.z - value;
                    if (height > this.elevThreshold) {
                        dot.groundElevation = height;
                    }
                }
                dot.intensity = cellIntensityClass[i][0];
                dot.classification = (byte)cellIntensityClass[i][1];
                pointsListForTile.add(dot);
            }
        });
        return pointsListForTile;
    }

    @Override
    public synchronized List<Geometry> getEnvelopesInGeometry(Geometry checkGeom, boolean doOnlyEnvelope, double[] minMaxZ) throws Exception {
        this.checkOpen();
        List<LasCell> lasCells = LasCellsTable.getLasCells(this.spatialDb, checkGeom, true, false, false, false, false);
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        Envelope env = new Envelope();
        for (LasCell lasCell : lasCells) {
            minZ = Math.min(minZ, lasCell.minElev);
            maxZ = Math.max(maxZ, lasCell.maxElev);
            env.expandToInclude(lasCell.polygon.getEnvelopeInternal());
        }
        ReferencedEnvelope3D dataEnvelope = new ReferencedEnvelope3D(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), minZ, maxZ, this.crs);
        Polygon envelopePolygon = LasIndexer.envelopeToPolygon((Envelope)dataEnvelope);
        ArrayList<Geometry> envelopeList = new ArrayList<Geometry>();
        envelopeList.add((Geometry)envelopePolygon);
        return envelopeList;
    }

    @Override
    public synchronized ReferencedEnvelope getOverallEnvelope() throws Exception {
        if (this.referencedEnvelope2D == null) {
            this.checkOpen();
            List<LasSource> lasSources = LasSourcesTable.getLasSources(this.spatialDb);
            ReferencedEnvelope total = new ReferencedEnvelope(this.crs);
            for (LasSource lasSource : lasSources) {
                Envelope envelopeInternal = lasSource.polygon.getEnvelopeInternal();
                total.expandToInclude(envelopeInternal);
            }
            this.referencedEnvelope2D = total;
            this.referencedEnvelope2DList.add(this.referencedEnvelope2D);
        }
        return this.referencedEnvelope2D;
    }

    @Override
    public List<ReferencedEnvelope> getEnvelopeList() throws Exception {
        this.getOverallEnvelope();
        return this.referencedEnvelope2DList;
    }

    @Override
    public synchronized ReferencedEnvelope3D getEnvelope3D() throws Exception {
        if (this.referencedEnvelope3D == null) {
            this.checkOpen();
            List<LasSource> lasSources = LasSourcesTable.getLasSources(this.spatialDb);
            ReferencedEnvelope total = new ReferencedEnvelope(this.crs);
            double minZ = Double.POSITIVE_INFINITY;
            double maxZ = Double.NEGATIVE_INFINITY;
            for (LasSource lasSource : lasSources) {
                Envelope envelopeInternal = lasSource.polygon.getEnvelopeInternal();
                total.expandToInclude(envelopeInternal);
                minZ = Math.min(minZ, lasSource.minElev);
                maxZ = Math.max(maxZ, lasSource.maxElev);
            }
            this.referencedEnvelope3D = new ReferencedEnvelope3D(total.getMinX(), total.getMaxX(), total.getMinY(), total.getMaxY(), minZ, maxZ, this.crs);
        }
        return this.referencedEnvelope3D;
    }

    @Override
    public synchronized SimpleFeatureCollection getOverviewFeatures() throws Exception {
        if (this.overviewFeatures == null) {
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName("overview");
            b.setCRS(this.crs);
            b.add("the_geom", Polygon.class);
            b.add("name", String.class);
            SimpleFeatureType type = b.buildFeatureType();
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
            this.overviewFeatures = new DefaultFeatureCollection();
            List<LasSource> lasSources = LasSourcesTable.getLasSources(this.spatialDb);
            for (int i = 0; i < lasSources.size(); ++i) {
                LasSource lasSource = lasSources.get(i);
                String name = lasSource.name;
                Object[] objs = new Object[]{lasSource.polygon, name};
                builder.addAll(objs);
                SimpleFeature feature = builder.buildFeature(null);
                ((DefaultFeatureCollection)this.overviewFeatures).add(feature);
            }
        }
        return this.overviewFeatures;
    }

    private void checkOpen() throws Exception {
        if (!this.isOpen) {
            this.open();
        }
    }

    @Override
    public void close() throws Exception {
        this.isOpen = false;
        if (this.spatialDb != null) {
            this.spatialDb.close();
        }
    }
}

