/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.las;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.hortonmachine.gears.io.las.ALasDataManager;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.io.las.index.LasIndexer;
import org.hortonmachine.gears.io.las.index.OmsLasIndexReader;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.index.strtree.STRtree;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class LasFileDataManager
extends ALasDataManager {
    private File lasFile;
    private GridCoverage2D inDem;
    private double elevThreshold;
    private SimpleFeatureCollection overviewFeatures;
    private ReferencedEnvelope referencedEnvelope2D;
    private List<ReferencedEnvelope> referencedEnvelope2DList = new ArrayList<ReferencedEnvelope>();
    private List<String> fileNamesList = new ArrayList<String>();
    private ReferencedEnvelope3D referencedEnvelope3D;
    private ALasReader lasReader;
    private ILasHeader lasHeader;
    private boolean isOpen;
    private STRtree pointsTree;

    LasFileDataManager(File lasFile, GridCoverage2D inDem, double elevThreshold, CoordinateReferenceSystem inCrs) {
        this.lasFile = lasFile;
        this.inDem = inDem;
        this.elevThreshold = elevThreshold;
        this.fileNamesList.add(lasFile.getName());
        try {
            inCrs = CrsUtilities.readProjectionFile(lasFile.getAbsolutePath(), "las");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inCrs != null) {
            this.crs = inCrs;
        } else if (inDem != null) {
            this.crs = inDem.getCoordinateReferenceSystem();
        } else {
            throw new IllegalArgumentException("The Crs can't be null.");
        }
    }

    @Override
    public File getFile() {
        return this.lasFile;
    }

    @Override
    public void open() throws Exception {
        this.lasReader = ALasReader.getReader(this.lasFile, this.crs);
        this.lasReader.open();
        this.lasHeader = this.lasReader.getHeader();
        this.isOpen = true;
    }

    @Override
    public synchronized List<LasRecord> getPointsInGeometry(Geometry checkGeom, boolean doOnlyEnvelope) throws Exception {
        this.checkOpen();
        ArrayList<LasRecord> pointsListForTile = new ArrayList<LasRecord>();
        Envelope checkEnvelope = checkGeom.getEnvelopeInternal();
        if (this.pointsTree != null) {
            List pointsList = this.pointsTree.query(checkEnvelope);
            PreparedGeometry preparedGeometry = null;
            if (!doOnlyEnvelope) {
                preparedGeometry = PreparedGeometryFactory.prepare((Geometry)checkGeom);
            }
            for (LasRecord lasDot : pointsList) {
                Coordinate c = new Coordinate(lasDot.x, lasDot.y);
                if (!checkEnvelope.contains(c) || !doOnlyEnvelope && !preparedGeometry.contains((Geometry)this.gf.createPoint(c))) continue;
                pointsListForTile.add(lasDot);
            }
        } else {
            this.pointsTree = new STRtree();
            ReferencedEnvelope overallEnvelope = this.getOverallEnvelope();
            if (doOnlyEnvelope && checkEnvelope.covers((Envelope)overallEnvelope)) {
                while (this.lasReader.hasNextPoint()) {
                    LasRecord lasDot = this.lasReader.getNextPoint();
                    if (!this.doAccept(lasDot)) continue;
                    this.pointsTree.insert(new Envelope(new Coordinate(lasDot.x, lasDot.y)), (Object)lasDot);
                    pointsListForTile.add(lasDot);
                }
            } else {
                Envelope env = checkGeom.getEnvelopeInternal();
                PreparedGeometry preparedGeometry = null;
                if (!doOnlyEnvelope) {
                    preparedGeometry = PreparedGeometryFactory.prepare((Geometry)checkGeom);
                }
                while (this.lasReader.hasNextPoint()) {
                    LasRecord lasDot = this.lasReader.getNextPoint();
                    if (!this.doAccept(lasDot)) continue;
                    Coordinate c = new Coordinate(lasDot.x, lasDot.y);
                    this.pointsTree.insert(new Envelope(c), (Object)lasDot);
                    if (!env.contains(c)) continue;
                    if (this.inDem != null) {
                        double height;
                        double value;
                        if (!doOnlyEnvelope && !preparedGeometry.contains((Geometry)this.gf.createPoint(c)) || HMConstants.isNovalue(value = CoverageUtilities.getValue(this.inDem, lasDot.x, lasDot.y)) || !((height = lasDot.z - value) > this.elevThreshold)) continue;
                        lasDot.groundElevation = height;
                        pointsListForTile.add(lasDot);
                        continue;
                    }
                    if (!doOnlyEnvelope && !preparedGeometry.contains((Geometry)this.gf.createPoint(c))) continue;
                    pointsListForTile.add(lasDot);
                }
            }
            this.close();
        }
        return pointsListForTile;
    }

    @Override
    public synchronized List<Geometry> getEnvelopesInGeometry(Geometry checkGeom, boolean doOnlyEnvelope, double[] minMaxZ) throws Exception {
        this.checkOpen();
        ReferencedEnvelope3D dataEnvelope = this.lasHeader.getDataEnvelope();
        Polygon envelopePolygon = LasIndexer.envelopeToPolygon((Envelope)dataEnvelope);
        ArrayList<Geometry> envelopeList = new ArrayList<Geometry>();
        envelopeList.add((Geometry)envelopePolygon);
        return envelopeList;
    }

    @Override
    public synchronized ReferencedEnvelope getOverallEnvelope() throws Exception {
        if (this.referencedEnvelope2D == null) {
            this.checkOpen();
            ReferencedEnvelope3D dataEnvelope = this.lasHeader.getDataEnvelope();
            this.referencedEnvelope2D = new ReferencedEnvelope((Envelope)dataEnvelope, this.crs);
            this.referencedEnvelope2DList.add(this.referencedEnvelope2D);
        }
        return this.referencedEnvelope2D;
    }

    @Override
    public List<ReferencedEnvelope> getEnvelopeList() throws Exception {
        this.getOverallEnvelope();
        return this.referencedEnvelope2DList;
    }

    @Override
    public synchronized ReferencedEnvelope3D getEnvelope3D() throws Exception {
        if (this.referencedEnvelope3D == null) {
            this.checkOpen();
            ReferencedEnvelope3D dataEnvelope = this.lasHeader.getDataEnvelope();
            this.referencedEnvelope3D = new ReferencedEnvelope3D(dataEnvelope, this.crs);
        }
        return this.referencedEnvelope3D;
    }

    @Override
    public synchronized SimpleFeatureCollection getOverviewFeatures() throws Exception {
        if (this.overviewFeatures == null) {
            List<ReferencedEnvelope> envelopeList = this.getEnvelopeList();
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName("overview");
            b.setCRS(this.crs);
            b.add("the_geom", Polygon.class);
            b.add("name", String.class);
            SimpleFeatureType type = b.buildFeatureType();
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
            this.overviewFeatures = new DefaultFeatureCollection();
            for (int i = 0; i < envelopeList.size(); ++i) {
                String name = this.fileNamesList.get(i);
                ReferencedEnvelope envelope = envelopeList.get(i);
                Polygon polygon = OmsLasIndexReader.envelopeToPolygon((Envelope)envelope);
                Object[] objs = new Object[]{polygon, name};
                builder.addAll(objs);
                SimpleFeature feature = builder.buildFeature(null);
                ((DefaultFeatureCollection)this.overviewFeatures).add(feature);
            }
        }
        return this.overviewFeatures;
    }

    private void checkOpen() throws Exception {
        if (!this.isOpen) {
            this.open();
        }
    }

    @Override
    public void close() throws Exception {
        this.isOpen = false;
        if (this.lasReader != null) {
            this.lasReader.close();
        }
    }
}

