/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.las.core;

import java.io.File;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ALasWriter;
import org.hortonmachine.gears.io.las.core.laszip4j.LaszipReader;
import org.hortonmachine.gears.io.las.core.v_1_0.LasReaderBuffered;
import org.hortonmachine.gears.io.las.core.v_1_0.LasWriterBuffered;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class Las {
    private static boolean isLaz(String name) {
        return name.toLowerCase().endsWith(".laz");
    }

    public static ALasReader getReader(File lasFile) throws Exception {
        String nameWithoutExtention = FileUtilities.getNameWithoutExtention(lasFile);
        File prjFile = new File(lasFile.getParentFile(), nameWithoutExtention + ".prj");
        CoordinateReferenceSystem crs = null;
        if (prjFile.exists()) {
            try {
                crs = CrsUtilities.readProjectionFile(prjFile.getAbsolutePath(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Las.getReader(lasFile, crs);
    }

    public static ALasReader getReader(File lasFile, CoordinateReferenceSystem crs) throws Exception {
        if (Las.isLaz(lasFile.getName())) {
            return new LaszipReader(lasFile, crs);
        }
        return new LasReaderBuffered(lasFile, crs);
    }

    public static ALasWriter getWriter(File lasFile, CoordinateReferenceSystem crs) throws Exception {
        return new LasWriterBuffered(lasFile, crs);
    }
}

