/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.las.core.laszip4j;

import com.github.mreutegg.laszip4j.LASHeader;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.utils.LasUtils;
import org.joda.time.DateTime;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LaszipHeader
implements ILasHeader {
    private LASHeader header;
    private CoordinateReferenceSystem crs;
    private ReferencedEnvelope3D dataEnvelope;

    public LaszipHeader(LASHeader header, CoordinateReferenceSystem crs) {
        this.header = header;
        this.crs = crs;
    }

    @Override
    public String getVersion() {
        return this.header.getVersionMajor() + "." + this.header.getVersionMinor();
    }

    @Override
    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    @Override
    public long getRecordsCount() {
        return this.header.getLegacyNumberOfPointRecords();
    }

    @Override
    public long getOffset() {
        return this.header.getOffsetToPointData();
    }

    @Override
    public double[] getXYZScale() {
        return new double[]{this.header.getXScaleFactor(), this.header.getYScaleFactor(), this.header.getZScaleFactor()};
    }

    @Override
    public double[] getXYZOffset() {
        return new double[]{this.header.getXOffset(), this.header.getYOffset(), this.header.getZOffset()};
    }

    @Override
    public short getRecordLength() {
        return (short)this.header.getPointDataRecordLength();
    }

    @Override
    public ReferencedEnvelope3D getDataEnvelope() {
        if (this.dataEnvelope == null) {
            this.dataEnvelope = new ReferencedEnvelope3D(this.header.getMinX(), this.header.getMaxX(), this.header.getMinY(), this.header.getMaxY(), this.header.getMinZ(), this.header.getMaxZ(), this.getCrs());
        }
        return this.dataEnvelope;
    }

    @Override
    public boolean hasGpsTime() {
        return true;
    }

    @Override
    public int getGpsTimeType() {
        return 0;
    }

    @Override
    public boolean hasRGB() {
        return true;
    }

    @Override
    public byte getPointDataFormat() {
        return this.getPointDataFormat();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("File signature: ").append(new String(this.header.getFileSignature())).append("\n");
        sb.append("File source ID: ").append(this.header.getFileSourceID()).append("\n");
        sb.append("Project ID - data 1: ").append(this.header.getProjectID_GUIDData1()).append("\n");
        sb.append("Project ID - data 2: ").append(this.header.getProjectID_GUIDData2()).append("\n");
        sb.append("Project ID - data 3: ").append(this.header.getProjectID_GUIDData3()).append("\n");
        sb.append("Project ID - data 4: ").append(new String(this.header.getProjectID_GUIDData4())).append("\n");
        sb.append("Version: ").append(this.getVersion()).append("\n");
        sb.append("System identifier: ").append(new String(this.header.getSystemIdentifier())).append("\n");
        sb.append("Generating software: ").append(this.header.getGeneratingSoftware()).append("\n");
        try {
            short fileCreationYear = (short)this.header.getFileCreationYear();
            short fileCreationDayOfYear = (short)this.header.getFileCreationDayOfYear();
            String dtString = " - nv - ";
            if (fileCreationYear != 0 && fileCreationDayOfYear != 0) {
                DateTime dateTime = new DateTime();
                dateTime = dateTime.withYear((int)fileCreationYear).withDayOfYear((int)fileCreationDayOfYear);
                dtString = dateTime.toString(LasUtils.dateTimeFormatterYYYYMMDD);
            }
            sb.append("File creation date: ").append(dtString).append("\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sb.append("Header size: ").append(this.header.getHeaderSize()).append("\n");
        sb.append("Offset to data: ").append(this.getOffset()).append("\n");
        sb.append("Variable length records: ").append(this.header.getNumberOfVariableLengthRecords()).append("\n");
        sb.append("Point data format ID (0-99 for spec): ").append(this.header.getPointDataRecordFormat()).append("\n");
        sb.append("Number of point records: ").append(this.getRecordsCount()).append("\n");
        sb.append("Record length: ").append(this.getRecordLength()).append("\n");
        sb.append("Scale: [").append(this.header.getXScaleFactor()).append(", ").append(this.header.getYScaleFactor()).append(", ").append(this.header.getZScaleFactor()).append("]\n");
        sb.append("Offset: [").append(this.header.getXOffset()).append(", ").append(this.header.getYOffset()).append(", ").append(this.header.getZOffset()).append("]\n");
        sb.append("X Range: [").append(this.header.getMinX()).append(", ").append(this.header.getMaxX()).append("]\n");
        sb.append("Y Range: [").append(this.header.getMinY()).append(", ").append(this.header.getMaxY()).append("]\n");
        sb.append("Z Range: [").append(this.header.getMinZ()).append(", ").append(this.header.getMaxZ()).append("]\n");
        sb.append("Has gps time info: ").append(this.hasGpsTime()).append("\n");
        sb.append("Has color info: ").append(this.hasRGB()).append("\n");
        sb.append("Gps time type: ").append(this.getGpsTimeType()).append("\n");
        return sb.toString();
    }

    @Override
    public double[] getRawDataEnvelope() {
        return new double[]{this.header.getMinX(), this.header.getMaxX(), this.header.getMinY(), this.header.getMaxY(), this.header.getMinZ(), this.header.getMaxZ()};
    }

    @Override
    public String getFileSignature() {
        return this.header.getFileSignature();
    }

    @Override
    public char getFileSourceID() {
        return this.header.getFileSourceID();
    }

    @Override
    public int getProjectID_GUIDData1() {
        return this.header.getProjectID_GUIDData1();
    }

    @Override
    public char getProjectID_GUIDData2() {
        return this.header.getProjectID_GUIDData2();
    }

    @Override
    public char getProjectID_GUIDData3() {
        return this.header.getProjectID_GUIDData3();
    }

    @Override
    public byte[] getProjectID_GUIDData4() {
        return this.header.getProjectID_GUIDData4();
    }

    @Override
    public String getSystemIdentifier() {
        return this.header.getSystemIdentifier();
    }

    @Override
    public String getGeneratingSoftware() {
        return this.header.getGeneratingSoftware();
    }

    @Override
    public short getFileCreationYear() {
        return (short)this.header.getFileCreationYear();
    }

    @Override
    public short getFileCreationDayOfYear() {
        return (short)this.header.getFileCreationDayOfYear();
    }

    @Override
    public char getHeaderSize() {
        return this.header.getHeaderSize();
    }

    @Override
    public int getNumberOfVariableLengthRecords() {
        return this.header.getNumberOfVariableLengthRecords();
    }

    @Override
    public byte getPointDataRecordFormat() {
        return this.header.getPointDataRecordFormat();
    }
}

