/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.las.core.laszip4j;

import com.github.mreutegg.laszip4j.LASHeader;
import com.github.mreutegg.laszip4j.LASPoint;
import com.github.mreutegg.laszip4j.LASReader;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.io.las.core.laszip4j.LaszipHeader;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LaszipReader
extends ALasReader {
    private File lasFile;
    private CoordinateReferenceSystem crs;
    private LaszipHeader header;
    private LASReader reader;
    private Iterator<LASPoint> pointsIterator;
    private double[] xyzOffset;
    private double[] xyzScale;
    private boolean isOpen;

    public LaszipReader(File lasFile, CoordinateReferenceSystem crs) throws Exception {
        this.lasFile = lasFile;
        this.crs = crs;
    }

    @Override
    public File getLasFile() {
        return this.lasFile;
    }

    @Override
    public void open() throws Exception {
        this.reader = new LASReader(this.lasFile);
        LASHeader laszipHeader = this.reader.getHeader();
        this.header = new LaszipHeader(laszipHeader, this.crs);
        this.xyzOffset = this.header.getXYZOffset();
        this.xyzScale = this.header.getXYZScale();
        this.isOpen = true;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void setOverrideGpsTimeType(int type) {
    }

    @Override
    public boolean hasNextPoint() throws IOException {
        if (this.pointsIterator == null) {
            Iterable pointsIterable = this.reader.getPoints();
            this.pointsIterator = pointsIterable.iterator();
        }
        return this.pointsIterator.hasNext();
    }

    @Override
    public LasRecord getNextPoint() throws IOException {
        LASPoint next = this.pointsIterator.next();
        LasRecord lr = new LasRecord();
        lr.x = (double)next.getX() * this.xyzScale[0] + this.xyzOffset[0];
        lr.y = (double)next.getY() * this.xyzScale[1] + this.xyzOffset[1];
        lr.z = (double)next.getZ() * this.xyzScale[2] + this.xyzOffset[2];
        lr.intensity = (short)next.getIntensity();
        lr.returnNumber = next.getReturnNumber();
        lr.numberOfReturns = next.getNumberOfReturns();
        lr.classification = next.getClassification();
        lr.gpsTime = next.getGPSTime();
        lr.color = new short[]{(short)next.getRed(), (short)next.getGreen(), (short)next.getBlue()};
        return lr;
    }

    @Override
    public LasRecord getPointAtAddress(long address) throws IOException {
        throw new RuntimeException("Not supported in laszip reader");
    }

    @Override
    public LasRecord getPointAt(long pointNumber) throws IOException {
        throw new RuntimeException("Not supported in laszip reader");
    }

    @Override
    public double[] readNextLasXYZAddress() throws IOException {
        throw new RuntimeException("Not supported in laszip reader");
    }

    @Override
    public void seek(long pointNumber) throws IOException {
        throw new RuntimeException("Not supported in laszip reader");
    }

    @Override
    public ILasHeader getHeader() {
        this.checkOpen();
        return this.header;
    }

    private void checkOpen() {
        if (!this.isOpen) {
            try {
                this.open();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void rewind() throws IOException {
        this.pointsIterator = null;
    }
}

